/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.cps.common.utils;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.io.Writer;

public class EncodingUtils {
    private static final String[] hex;
    private static boolean[] dontNeedEncoding;

    public static void urlEncode(String s, String enc, boolean form, Writer writer) throws NullPointerException, IOException {
        if (s == null || enc == null) {
            throw new NullPointerException();
        }
        byte[] sbytes = s.getBytes(enc);
        int ch = 0;
        if (form) {
            for (int i = 0; i < sbytes.length; ++i) {
                if (sbytes[i] >= 0 && sbytes[i] <= 127) {
                    ch = sbytes[i];
                    if (dontNeedEncoding[ch]) {
                        writer.write((char)ch);
                        continue;
                    }
                    if (ch == 32) {
                        writer.write(43);
                        continue;
                    }
                    writer.write(hex[ch]);
                    continue;
                }
                ch = 128 + (sbytes[i] & 0x7F);
                writer.write(hex[ch]);
            }
        } else {
            for (int i = 0; i < sbytes.length; ++i) {
                if (sbytes[i] >= 0 && sbytes[i] <= 127) {
                    ch = sbytes[i];
                    if (dontNeedEncoding[ch]) {
                        writer.write((char)ch);
                        continue;
                    }
                    writer.write(hex[ch]);
                    continue;
                }
                ch = 128 + (sbytes[i] & 0x7F);
                writer.write(hex[ch]);
            }
        }
    }

    public static String urlEncode(String s, String enc, boolean form) throws NullPointerException, UnsupportedEncodingException {
        if (s == null || enc == null) {
            throw new NullPointerException();
        }
        byte[] sbytes = s.getBytes(enc);
        int rsize = sbytes.length * 2;
        StringBuffer sbuf = new StringBuffer(rsize);
        int ch = 0;
        if (form) {
            for (int i = 0; i < sbytes.length; ++i) {
                if (sbytes[i] >= 0 && sbytes[i] <= 127) {
                    ch = sbytes[i];
                    if (dontNeedEncoding[ch]) {
                        sbuf.append((char)ch);
                        continue;
                    }
                    if (ch == 32) {
                        sbuf.append('+');
                        continue;
                    }
                    sbuf.append(hex[ch]);
                    continue;
                }
                ch = 128 + (sbytes[i] & 0x7F);
                sbuf.append(hex[ch]);
            }
        } else {
            for (int i = 0; i < sbytes.length; ++i) {
                if (sbytes[i] >= 0 && sbytes[i] <= 127) {
                    ch = sbytes[i];
                    if (dontNeedEncoding[ch]) {
                        sbuf.append((char)ch);
                        continue;
                    }
                    sbuf.append(hex[ch]);
                    continue;
                }
                ch = 128 + (sbytes[i] & 0x7F);
                sbuf.append(hex[ch]);
            }
        }
        return sbuf.toString();
    }

    public static String urlDecode(String s, String enc) throws NullPointerException, UnsupportedEncodingException {
        if (s == null || enc == null) {
            throw new NullPointerException();
        }
        ByteArrayOutputStream bos = new ByteArrayOutputStream(s.length());
        int ch = -1;
        block4: for (int i = 0; i < s.length(); ++i) {
            char c = s.charAt(i);
            ch = c;
            switch (c) {
                case '%': {
                    ch = s.charAt(++i);
                    int hb = (Character.isDigit((char)ch) ? ch - 48 : 10 + Character.toLowerCase((char)ch) - 97) & 0xF;
                    ch = s.charAt(++i);
                    int lb = (Character.isDigit((char)ch) ? ch - 48 : 10 + Character.toLowerCase((char)ch) - 97) & 0xF;
                    int b = hb << 4 | lb;
                    bos.write((byte)b);
                    continue block4;
                }
                case '+': {
                    bos.write(32);
                    continue block4;
                }
                default: {
                    bos.write((byte)ch);
                }
            }
        }
        return bos.toString(enc);
    }

    public static void xmlEncode(String value, StringBuffer sbuf) {
        block7: for (int i = 0; i < value.length(); ++i) {
            char x = value.charAt(i);
            switch (x) {
                case '\'': {
                    sbuf.append("&apos;");
                    continue block7;
                }
                case '<': {
                    sbuf.append("&lt;");
                    continue block7;
                }
                case '>': {
                    sbuf.append("&gt;");
                    continue block7;
                }
                case '&': {
                    sbuf.append("&amp;");
                    continue block7;
                }
                case '\"': {
                    sbuf.append("&quot;");
                    continue block7;
                }
                default: {
                    sbuf.append(x);
                }
            }
        }
    }

    public static void xmldecode(String value, StringBuffer sbuf) {
        int i = 0;
        while (i < value.length()) {
            char x = value.charAt(i);
            if (x != '&') {
                sbuf.append(x);
                ++i;
                continue;
            }
            if (value.startsWith("&apos;", i)) {
                sbuf.append('\'');
                i += 6;
                continue;
            }
            if (value.startsWith("&lt;", i)) {
                sbuf.append('<');
                i += 4;
                continue;
            }
            if (value.startsWith("&gt;", i)) {
                sbuf.append('>');
                i += 4;
                continue;
            }
            if (value.startsWith("&amp;", i)) {
                sbuf.append('&');
                i += 5;
                continue;
            }
            if (value.startsWith("&quot;", i)) {
                sbuf.append('\"');
                i += 6;
                continue;
            }
            sbuf.append('&');
            ++i;
        }
    }

    public static void htmlEncode(String value, StringBuffer sbuf) {
        block6: for (int i = 0; i < value.length(); ++i) {
            char x = value.charAt(i);
            switch (x) {
                case '<': {
                    sbuf.append("&lt;");
                    continue block6;
                }
                case '>': {
                    sbuf.append("&gt;");
                    continue block6;
                }
                case '&': {
                    sbuf.append("&amp;");
                    continue block6;
                }
                case '\"': {
                    sbuf.append("&quot;");
                    continue block6;
                }
                default: {
                    sbuf.append(x);
                }
            }
        }
    }

    public static String javascriptEncode(String value) {
        String prev;
        do {
            prev = value;
        } while (!(value = value.replaceAll("<\\/[sS][cC][rR][iI][pP][tT]", "")).equals(prev));
        int rsize = value.length() * 2;
        StringBuffer sbuf = new StringBuffer(rsize);
        block14: for (int i = 0; i < value.length(); ++i) {
            char x = value.charAt(i);
            switch (x) {
                case '\b': {
                    sbuf.append("\\b");
                    continue block14;
                }
                case '\t': {
                    sbuf.append("\\t");
                    continue block14;
                }
                case '\n': {
                    sbuf.append("\\n");
                    continue block14;
                }
                case '\u000b': {
                    sbuf.append("\\v");
                    continue block14;
                }
                case '\f': {
                    sbuf.append("\\f");
                    continue block14;
                }
                case '\r': {
                    sbuf.append("\\r");
                    continue block14;
                }
                case '\"': {
                    sbuf.append("\\\"");
                    continue block14;
                }
                case '\'': {
                    sbuf.append("\\'");
                    continue block14;
                }
                case '\\': {
                    sbuf.append("\\\\");
                    continue block14;
                }
                case '<': {
                    sbuf.append("\\<");
                    continue block14;
                }
                case '>': {
                    sbuf.append("\\>");
                    continue block14;
                }
                default: {
                    sbuf.append(x);
                }
            }
        }
        return sbuf.toString();
    }

    public static String urlUnicodeDecode(String s) {
        if (s == null || s.length() == 0) {
            return s;
        }
        StringBuffer value = new StringBuffer();
        int len = s.length();
        char ch = '\u0000';
        int i = 0;
        block3: while (i < len) {
            ch = s.charAt(i);
            switch (ch) {
                case '%': {
                    if (i == len - 1) break;
                    if (s.charAt(i + 1) == '%') {
                        i += 2;
                        value.append('%');
                        continue block3;
                    }
                    if (s.charAt(i + 1) != 'u') break;
                    ++i;
                    String unicodeValue = s.substring(++i, i += 4);
                    value.append((char)Integer.parseInt(unicodeValue, 16));
                    continue block3;
                }
            }
            ++i;
            value.append(ch);
        }
        return value.toString();
    }

    public static void escapeString(String s, String unsafeChars, char escapeChar, StringBuffer sbuf) {
        for (int i = 0; i < s.length(); ++i) {
            char x = s.charAt(i);
            if (x == escapeChar || unsafeChars.indexOf(x) >= 0) {
                sbuf.append(escapeChar);
            }
            sbuf.append(x);
        }
    }

    public static void unescapeString(String s, char escapeChar, StringBuffer sbuf) {
        boolean lastWasEscape = false;
        for (int i = 0; i < s.length(); ++i) {
            char x = s.charAt(i);
            if (x == escapeChar && !lastWasEscape) {
                lastWasEscape = true;
                continue;
            }
            sbuf.append(x);
            lastWasEscape = false;
        }
    }

    static {
        int i;
        hex = new String[]{"%00", "%01", "%02", "%03", "%04", "%05", "%06", "%07", "%08", "%09", "%0a", "%0b", "%0c", "%0d", "%0e", "%0f", "%10", "%11", "%12", "%13", "%14", "%15", "%16", "%17", "%18", "%19", "%1a", "%1b", "%1c", "%1d", "%1e", "%1f", "%20", "%21", "%22", "%23", "%24", "%25", "%26", "%27", "%28", "%29", "%2a", "%2b", "%2c", "%2d", "%2e", "%2f", "%30", "%31", "%32", "%33", "%34", "%35", "%36", "%37", "%38", "%39", "%3a", "%3b", "%3c", "%3d", "%3e", "%3f", "%40", "%41", "%42", "%43", "%44", "%45", "%46", "%47", "%48", "%49", "%4a", "%4b", "%4c", "%4d", "%4e", "%4f", "%50", "%51", "%52", "%53", "%54", "%55", "%56", "%57", "%58", "%59", "%5a", "%5b", "%5c", "%5d", "%5e", "%5f", "%60", "%61", "%62", "%63", "%64", "%65", "%66", "%67", "%68", "%69", "%6a", "%6b", "%6c", "%6d", "%6e", "%6f", "%70", "%71", "%72", "%73", "%74", "%75", "%76", "%77", "%78", "%79", "%7a", "%7b", "%7c", "%7d", "%7e", "%7f", "%80", "%81", "%82", "%83", "%84", "%85", "%86", "%87", "%88", "%89", "%8a", "%8b", "%8c", "%8d", "%8e", "%8f", "%90", "%91", "%92", "%93", "%94", "%95", "%96", "%97", "%98", "%99", "%9a", "%9b", "%9c", "%9d", "%9e", "%9f", "%a0", "%a1", "%a2", "%a3", "%a4", "%a5", "%a6", "%a7", "%a8", "%a9", "%aa", "%ab", "%ac", "%ad", "%ae", "%af", "%b0", "%b1", "%b2", "%b3", "%b4", "%b5", "%b6", "%b7", "%b8", "%b9", "%ba", "%bb", "%bc", "%bd", "%be", "%bf", "%c0", "%c1", "%c2", "%c3", "%c4", "%c5", "%c6", "%c7", "%c8", "%c9", "%ca", "%cb", "%cc", "%cd", "%ce", "%cf", "%d0", "%d1", "%d2", "%d3", "%d4", "%d5", "%d6", "%d7", "%d8", "%d9", "%da", "%db", "%dc", "%dd", "%de", "%df", "%e0", "%e1", "%e2", "%e3", "%e4", "%e5", "%e6", "%e7", "%e8", "%e9", "%ea", "%eb", "%ec", "%ed", "%ee", "%ef", "%f0", "%f1", "%f2", "%f3", "%f4", "%f5", "%f6", "%f7", "%f8", "%f9", "%fa", "%fb", "%fc", "%fd", "%fe", "%ff"};
        dontNeedEncoding = new boolean[256];
        for (i = 0; i < 256; ++i) {
            EncodingUtils.dontNeedEncoding[i] = false;
        }
        for (i = 97; i <= 122; ++i) {
            EncodingUtils.dontNeedEncoding[i] = true;
        }
        for (i = 65; i <= 90; ++i) {
            EncodingUtils.dontNeedEncoding[i] = true;
        }
        for (i = 48; i <= 57; ++i) {
            EncodingUtils.dontNeedEncoding[i] = true;
        }
        EncodingUtils.dontNeedEncoding[45] = true;
        EncodingUtils.dontNeedEncoding[95] = true;
        EncodingUtils.dontNeedEncoding[46] = true;
        EncodingUtils.dontNeedEncoding[33] = true;
        EncodingUtils.dontNeedEncoding[126] = true;
        EncodingUtils.dontNeedEncoding[42] = true;
        EncodingUtils.dontNeedEncoding[40] = true;
        EncodingUtils.dontNeedEncoding[41] = true;
    }
}

