/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.cps.wsrp.consumer;

import com.cognos.cps.common.logging.ServiceLogger;
import com.cognos.cps.services.pagelet.objects.v1.types.Param;
import com.cognos.cps.services.pagelet.objects.v1.types.PortalContext;
import com.cognos.cps.services.wsrp.v1.types.Property;
import com.cognos.cps.services.wsrp.v1.types.RegistrationData;
import com.cognos.cps.services.wsrp.v1.types.TypeFactory;
import com.cognos.cps.wsrp.consumer.ConsumerException;
import com.cognos.cps.wsrp.consumer.ObjectHandler;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Locale;

public abstract class ObjectHandlerDefault
implements ObjectHandler {
    protected boolean m_includeVersionInfo = false;
    protected ServiceLogger m_logger;
    private static final String PROPERTY_GATEWAY_URL = "_gatewayURL";
    private static final String PROPERTY_WEBCONTENT_URL = "_webcontentURL";

    protected PortalContext createPortalContext() {
        String webcontentURL;
        com.cognos.cps.services.pagelet.objects.v1.types.TypeFactory portalContextFactory = com.cognos.cps.services.pagelet.objects.v1.types.TypeFactory.newInstance();
        PortalContext portalContext = portalContextFactory.createPortalContext();
        portalContext.setPortalAgent(this.getPortalAgent());
        String gatewayURL = this.getConfigProperty(this.getPropertyGatewayUrl());
        if (gatewayURL != null && !gatewayURL.equals("") && !gatewayURL.equals("(none)")) {
            Param gatewayURLParam = portalContextFactory.createParam();
            gatewayURLParam.setName("gatewayURL");
            gatewayURLParam.setContent(gatewayURL);
            portalContext.addParam(gatewayURLParam);
        }
        if ((webcontentURL = this.getConfigProperty(this.getPropertyWebcontentUrl())) != null && !webcontentURL.equals("") && !webcontentURL.equals("(none)")) {
            Param webcontentURLParam = portalContextFactory.createParam();
            webcontentURLParam.setName("webContentURL");
            if (webcontentURL.endsWith("/")) {
                webcontentURL = webcontentURL.substring(0, webcontentURL.length() - 1);
            }
            webcontentURLParam.setContent(webcontentURL);
            portalContext.addParam(webcontentURLParam);
        }
        return portalContext;
    }

    @Override
    public RegistrationData createRegistrationData(String hashkey) throws ConsumerException {
        this.m_logger.debug("createRegistrationData() called.");
        RegistrationData registrationData = TypeFactory.newInstance().createRegistrationData();
        registrationData.setConsumerName("Cognos Portal Services - " + this.getConsumerAgent());
        registrationData.setConsumerAgent(this.getConsumerAgent());
        registrationData.setMethodGetSupported(true);
        registrationData.setConsumerModes(this.getSupportedModes());
        registrationData.setConsumerWindowStates(this.getSupportedWindowStates());
        Enumeration paramsEnum = this.getRequestParameterNames();
        while (paramsEnum.hasMoreElements()) {
            String name = (String)paramsEnum.nextElement();
            if (name.startsWith("wsrp-")) continue;
            String[] values = this.getRequestParameterValues(name);
            for (int i = 0; i < values.length; ++i) {
                Property property = TypeFactory.newInstance().createProperty();
                property.setName(name);
                property.setStringValue(values[i]);
                property.setLang("en");
                registrationData.addRegistrationProperties(property);
            }
        }
        return registrationData;
    }

    protected abstract String getPortalAgent();

    protected abstract String getConsumerAgent();

    protected abstract String[] getSupportedModes();

    protected abstract String[] getSupportedWindowStates();

    protected abstract Enumeration getRequestParameterNames();

    protected abstract String[] getRequestParameterValues(String var1);

    protected static String buildLocaleString(Locale locale) {
        String lang = locale.getLanguage();
        String country = locale.getCountry();
        if (country.length() == 0) {
            return lang;
        }
        return lang + "-" + country.toLowerCase();
    }

    public String[] convertLocalesEnum(Enumeration localesEnum) {
        ArrayList<String> localesList = new ArrayList<String>();
        Locale desiredLocale = null;
        while (localesEnum.hasMoreElements()) {
            desiredLocale = (Locale)localesEnum.nextElement();
            localesList.add(ObjectHandlerDefault.buildLocaleString(desiredLocale));
        }
        String[] localesArray = new String[localesList.size()];
        localesList.toArray(localesArray);
        return localesArray;
    }

    public String getPropertyWebcontentUrl() {
        return PROPERTY_WEBCONTENT_URL;
    }

    public String getPropertyGatewayUrl() {
        return PROPERTY_GATEWAY_URL;
    }

    public static String getPropertyGatewayUrl_Static() {
        return PROPERTY_GATEWAY_URL;
    }
}

