/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.cps.wsrp.consumer.helpers;

import com.cognos.cps.common.logging.ServiceLogger;
import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.net.HttpURLConnection;
import java.net.URL;

public class HttpServiceLogger
implements ServiceLogger,
Cloneable {
    private URL m_url;

    private HttpServiceLogger() {
    }

    public HttpServiceLogger(URL url) {
        this.m_url = url;
    }

    public void info(String message) {
        this.sendMessage("info", message);
    }

    public void warn(String message) {
        this.sendMessage("warn", message);
    }

    public void error(String message) {
        this.sendMessage("error", message);
    }

    public void error(String message, Throwable cause) {
        this.sendMessage("error", message, cause);
    }

    public void debug(String message) {
        this.sendMessage("debug", message);
    }

    public void enter(String method) {
        this.sendMessage("enter", method);
    }

    public void enter(String method, Object[] objects) {
        this.sendMessage("enter", method + " " + objects.toString());
    }

    public void exit(String method) {
        this.sendMessage("exit", method);
    }

    public void exit(String method, Object[] objects) {
        this.sendMessage("exit", method + " " + objects.toString());
    }

    public ServiceLogger cloneForClass(Class className) {
        try {
            return (ServiceLogger)this.clone();
        }
        catch (CloneNotSupportedException e) {
            return null;
        }
    }

    public boolean isInfoEnabled() {
        return true;
    }

    public boolean isWarnEnabled() {
        return true;
    }

    public boolean isErrorEnabled() {
        return true;
    }

    public boolean isDebugEnabled() {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void sendMessage(String level, String message, Throwable cause) {
        HttpURLConnection conn = null;
        try {
            conn = (HttpURLConnection)this.m_url.openConnection();
            conn.setRequestMethod("POST");
            conn.setDoOutput(true);
            conn.setDoInput(true);
            conn.connect();
            BufferedOutputStream output = new BufferedOutputStream(conn.getOutputStream());
            ((OutputStream)output).write("[".getBytes());
            ((OutputStream)output).write(level.getBytes());
            ((OutputStream)output).write(",".getBytes());
            ((OutputStream)output).write(Thread.currentThread().getName().getBytes());
            ((OutputStream)output).write("]".getBytes());
            ((OutputStream)output).write(message.getBytes());
            if (cause != null) {
                PrintWriter writer = new PrintWriter(output);
                writer.println();
                cause.printStackTrace(writer);
                writer.flush();
            }
            ((OutputStream)output).close();
            conn.getInputStream().close();
        }
        catch (IOException e) {
            e.printStackTrace(System.err);
        }
        finally {
            conn.disconnect();
        }
    }

    private void sendMessage(String level, String message) {
        this.sendMessage(level, message, null);
    }

    public boolean isAuditLevelEnabled(int level) {
        return false;
    }

    public void logAudit(int level, int operation, String message) {
    }

    public boolean isPerfLevelEnabled(int level) {
        return false;
    }

    public Object startTimer(int level, String method, String description, Object obj) {
        return null;
    }

    public void stopTimer(Object timer) {
    }
}

