/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.cps.common.io;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;

public class FilterInputStreamReader
extends InputStreamReader {
    String filter;
    char[] buffer;
    int currentIndex;
    int bufferSize;

    public FilterInputStreamReader(InputStream arg0) {
        super(arg0);
    }

    public FilterInputStreamReader(InputStream arg0, String s) throws UnsupportedEncodingException {
        super(arg0, s);
    }

    public void setFilter(String filter) {
        if (filter != null && filter.length() > 0) {
            this.filter = filter;
        }
    }

    private int readBuffered(char[] cbuf, int off, int length) throws IOException {
        if (this.buffer != null && this.currentIndex < this.bufferSize) {
            int available = this.bufferSize - this.currentIndex;
            if (length > available) {
                System.arraycopy(this.buffer, this.currentIndex, cbuf, off, available);
                this.buffer = null;
                int read = super.read(cbuf, off + available, length - available);
                if (read != -1) {
                    return available + read;
                }
                return available;
            }
            System.arraycopy(this.buffer, this.currentIndex, cbuf, off, length);
            this.currentIndex += length;
            return length;
        }
        return super.read(cbuf, off, length);
    }

    @Override
    public int read(char[] cbuf, int off, int length) throws IOException {
        if (this.filter != null) {
            this.buffer = new char[this.filter.length()];
            int read = 0;
            int readLength = this.filter.length();
            this.bufferSize = 0;
            while ((read = super.read(this.buffer, this.bufferSize, readLength)) != -1) {
                this.bufferSize += read;
                if ((readLength -= read) > 0) continue;
            }
            if (this.filter.equals(String.valueOf(this.buffer, 0, this.bufferSize))) {
                this.buffer = null;
            }
            this.filter = null;
        }
        return this.readBuffered(cbuf, off, length);
    }
}

