/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.cps.common.sax;

import java.util.List;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;

public class EventSequenceValidatorContentHandler
implements ContentHandler {
    private List m_saxEvents;
    private boolean m_debug;

    private EventSequenceValidatorContentHandler() {
    }

    public EventSequenceValidatorContentHandler(List events, boolean debug) {
        this.m_saxEvents = events;
        this.m_debug = debug;
    }

    public EventSequenceValidatorContentHandler(List events) {
        this.m_saxEvents = events;
        this.m_debug = false;
    }

    public Object[] getNextExpectedEvent() {
        if (this.m_saxEvents.isEmpty()) {
            return null;
        }
        return (Object[])this.m_saxEvents.get(0);
    }

    @Override
    public void characters(char[] ch, int start, int length) throws SAXException {
        if (this.m_saxEvents.size() == 0) {
            throw new SAXException("No more events were expected, however a 'characters' event was recieved.");
        }
        Object[] event = (Object[])this.m_saxEvents.get(0);
        if (this.m_debug) {
            System.out.print("Expected: ");
            for (int i = 0; i < event.length - 1; ++i) {
                System.out.print(event[i] + ", ");
            }
            System.out.println(event[event.length - 1]);
            System.out.println("Recieved: characters, " + new String(ch, start, length));
        }
        if (!event[0].equals("characters")) {
            throw new SAXException("Expected a '" + event[0] + "', but got a 'characters' event.");
        }
        String characters = new String(ch, start, length);
        if (!event[1].equals(characters)) {
            throw new SAXException("characters event: expected '" + event[1] + "', but got '" + characters + "' event.");
        }
        this.m_saxEvents.remove(0);
    }

    @Override
    public void endDocument() throws SAXException {
        if (this.m_saxEvents.size() == 0) {
            throw new SAXException("No more events were expected, however a 'endDocument' event was recieved.");
        }
        Object[] event = (Object[])this.m_saxEvents.get(0);
        if (this.m_debug) {
            System.out.print("Expected: ");
            for (int i = 0; i < event.length - 1; ++i) {
                System.out.print(event[i] + ", ");
            }
            System.out.println(event[event.length - 1]);
            System.out.println("Recieved: endDocument");
        }
        if (!event[0].equals("endDocument")) {
            throw new SAXException("Expected a '" + event[0] + "' but got a 'endDocument' event.");
        }
        this.m_saxEvents.remove(0);
    }

    @Override
    public void endElement(String uri, String localName, String qName) throws SAXException {
        if (this.m_saxEvents.size() == 0) {
            throw new SAXException("No more events were expected, however a 'endElement' event was recieved.");
        }
        Object[] event = (Object[])this.m_saxEvents.get(0);
        if (this.m_debug) {
            System.out.print("Expected: ");
            for (int i = 0; i < event.length - 1; ++i) {
                System.out.print(event[i] + ", ");
            }
            System.out.println(event[event.length - 1]);
            System.out.println("Recieved: endElement, " + uri + ", " + localName + ", " + qName);
        }
        if (!event[0].equals("endElement")) {
            throw new SAXException("Expected a '" + event[0] + "', but got a 'endElement' event.");
        }
        if (!event[1].equals(uri)) {
            throw new SAXException("endElement event: expected '" + event[1] + "', but got '" + uri + "' event.");
        }
        if (!event[2].equals(localName)) {
            throw new SAXException("endElement event: expected '" + event[2] + "', but got '" + localName + "' event.");
        }
        if (!event[3].equals(qName)) {
            throw new SAXException("endElement event: expected '" + event[3] + "', but got '" + qName + "' event.");
        }
        this.m_saxEvents.remove(0);
    }

    @Override
    public void endPrefixMapping(String prefix) throws SAXException {
        if (this.m_saxEvents.size() == 0) {
            throw new SAXException("No more events were expected, however a 'endPrefixMapping' event was recieved.");
        }
        Object[] event = (Object[])this.m_saxEvents.get(0);
        if (this.m_debug) {
            System.out.print("Expected: ");
            for (int i = 0; i < event.length - 1; ++i) {
                System.out.print(event[i] + ", ");
            }
            System.out.println(event[event.length - 1]);
            System.out.println("Recieved: endPrefixMapping, " + prefix);
        }
        if (!event[0].equals("endPrefixMapping")) {
            throw new SAXException("Expected a '" + event[0] + "', but got a 'endPrefixMapping' event.");
        }
        if (!event[1].equals(prefix)) {
            throw new SAXException("endPrefixMapping event: expected '" + event[1] + "', but got '" + prefix + "' event.");
        }
        this.m_saxEvents.remove(0);
    }

    @Override
    public void ignorableWhitespace(char[] ch, int start, int length) throws SAXException {
        if (this.m_saxEvents.size() == 0) {
            throw new SAXException("No more events were expected, however a 'ignorableWhitespace' event was recieved.");
        }
        Object[] event = (Object[])this.m_saxEvents.get(0);
        if (this.m_debug) {
            System.out.print("Expected: ");
            for (int i = 0; i < event.length - 1; ++i) {
                System.out.print(event[i] + ", ");
            }
            System.out.println(event[event.length - 1]);
            System.out.println("Recieved: ignorableWhitespace, " + new String(ch, start, length));
        }
        if (!event[0].equals("ignorableWhitespace")) {
            throw new SAXException("Expected a '" + event[0] + "', but got a 'ignorableWhitespace' event.");
        }
        if (!event[1].equals(new String(ch, start, length))) {
            throw new SAXException("ignorableWhitespace event: expected '" + event[1] + "', but got '" + new String(ch, start, length) + "' event.");
        }
        this.m_saxEvents.remove(0);
    }

    @Override
    public void processingInstruction(String target, String data) throws SAXException {
        if (this.m_saxEvents.size() == 0) {
            throw new SAXException("No more events were expected, however a 'processingInstruction' event was recieved.");
        }
        Object[] event = (Object[])this.m_saxEvents.get(0);
        if (this.m_debug) {
            System.out.print("Expected: ");
            for (int i = 0; i < event.length - 1; ++i) {
                System.out.print(event[i] + ", ");
            }
            System.out.println(event[event.length - 1]);
            System.out.println("Recieved: processingInstruction, " + target + ", " + data);
        }
        if (!event[0].equals("processingInstruction")) {
            throw new SAXException("Expected a '" + event[0] + "', but got a 'processingInstruction' event.");
        }
        if (!event[1].equals(target)) {
            throw new SAXException("processingInstruction event: expected '" + event[1] + "', but got '" + target + "' event.");
        }
        if (!event[2].equals(data)) {
            throw new SAXException("processingInstruction event: expected '" + event[2] + "', but got '" + data + "' event.");
        }
        this.m_saxEvents.remove(0);
    }

    @Override
    public void setDocumentLocator(Locator locator) {
    }

    @Override
    public void skippedEntity(String name) throws SAXException {
        if (this.m_saxEvents.size() == 0) {
            throw new SAXException("No more events were expected, however a 'skippedEntity' event was recieved.");
        }
        Object[] event = (Object[])this.m_saxEvents.get(0);
        if (this.m_debug) {
            System.out.print("Expected: ");
            for (int i = 0; i < event.length - 1; ++i) {
                System.out.print(event[i] + ", ");
            }
            System.out.println(event[event.length - 1]);
            System.out.println("Recieved: skippedEntity, " + name);
        }
        if (!event[0].equals("skippedEntity")) {
            throw new SAXException("Expected a '" + event[0] + "', but got a 'skippedEntity' event.");
        }
        if (!event[1].equals(name)) {
            throw new SAXException("skippedEntity event: expected '" + event[1] + "', but got '" + name + "' event.");
        }
        this.m_saxEvents.remove(0);
    }

    @Override
    public void startDocument() throws SAXException {
        if (this.m_saxEvents.size() == 0) {
            throw new SAXException("No more events were expected, however a 'startDocument' event was recieved.");
        }
        Object[] event = (Object[])this.m_saxEvents.get(0);
        if (this.m_debug) {
            System.out.print("Expected: ");
            for (int i = 0; i < event.length - 1; ++i) {
                System.out.print(event[i] + ", ");
            }
            System.out.println(event[event.length - 1]);
            System.out.println("Recieved: startDocument");
        }
        if (!event[0].equals("startDocument")) {
            throw new SAXException("Expected a '" + event[0] + "', but got a 'startDocument' event.");
        }
        this.m_saxEvents.remove(0);
    }

    @Override
    public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
        if (this.m_saxEvents.size() == 0) {
            throw new SAXException("No more events were expected, however a 'startElement' event was recieved.");
        }
        Object[] event = (Object[])this.m_saxEvents.get(0);
        if (this.m_debug) {
            System.out.print("Expected: ");
            for (int i = 0; i < event.length - 1; ++i) {
                System.out.print(event[i] + ", ");
            }
            System.out.println(event[event.length - 1]);
            System.out.println("Recieved: startElement, " + uri + ", " + localName + ", " + qName + ", " + attributes);
        }
        if (!event[0].equals("startElement")) {
            throw new SAXException("Expected a '" + event[0] + "', but got a 'startElement' event.");
        }
        if (!event[1].equals(uri)) {
            throw new SAXException("startElement event: expected '" + event[1] + "', but got '" + uri + "' event.");
        }
        if (!event[2].equals(localName)) {
            throw new SAXException("startElement event: expected '" + event[2] + "', but got '" + localName + "' event.");
        }
        if (!event[3].equals(qName)) {
            throw new SAXException("startElement event: expected '" + event[3] + "', but got '" + qName + "' event.");
        }
        this.m_saxEvents.remove(0);
    }

    @Override
    public void startPrefixMapping(String prefix, String uri) throws SAXException {
        if (this.m_saxEvents.size() == 0) {
            throw new SAXException("No more events were expected, however a 'startPrefixMapping' event was recieved.");
        }
        Object[] event = (Object[])this.m_saxEvents.get(0);
        if (this.m_debug) {
            System.out.print("Expected: ");
            for (int i = 0; i < event.length - 1; ++i) {
                System.out.print(event[i] + ", ");
            }
            System.out.println(event[event.length - 1]);
            System.out.println("Recieved: startPrefixMapping, " + prefix + ", " + uri);
        }
        if (!event[0].equals("startPrefixMapping")) {
            throw new SAXException("Expected a '" + event[0] + "', but got a 'startPrefixMapping' event.");
        }
        if (!event[1].equals(prefix)) {
            throw new SAXException("startPrefixMapping event: expected '" + event[1] + "', but got '" + prefix + "' event.");
        }
        if (!event[2].equals(uri)) {
            throw new SAXException("startPrefixMapping event: expected '" + event[2] + "', but got '" + uri + "' event.");
        }
        this.m_saxEvents.remove(0);
    }
}

