/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.cps.common.utils;

import com.cognos.cps.common.utils.EncodingUtils;
import java.util.ArrayList;

public final class Strings {
    public static String[] split(String src, char sep) {
        if (src == null) {
            return null;
        }
        ArrayList<String> arr = new ArrayList<String>();
        int i = src.indexOf(sep);
        while (i >= 0) {
            arr.add(src.substring(0, i));
            src = src.substring(i + 1);
            i = src.indexOf(sep);
        }
        arr.add(src);
        return arr.toArray(new String[arr.size()]);
    }

    public static String[] split(String src, char sep, char escapeChar) {
        if (src == null) {
            return null;
        }
        StringBuffer sbuf = new StringBuffer();
        ArrayList<String> arr = new ArrayList<String>();
        int i = src.indexOf(sep);
        while (i >= 0) {
            if (i > 0 && src.charAt(i - 1) == escapeChar) {
                i = src.indexOf(sep, i + 1);
                continue;
            }
            sbuf.setLength(0);
            EncodingUtils.unescapeString(src.substring(0, i), escapeChar, sbuf);
            arr.add(sbuf.toString());
            src = src.substring(i + 1);
            i = src.indexOf(sep);
        }
        sbuf.setLength(0);
        EncodingUtils.unescapeString(src, escapeChar, sbuf);
        arr.add(sbuf.toString());
        return arr.toArray(new String[arr.size()]);
    }

    public static String normalizeSpace(String src) {
        if (src == null) {
            return null;
        }
        StringBuffer buffer = new StringBuffer();
        boolean trim = true;
        for (int i = 0; i < src.length(); ++i) {
            char c = src.charAt(i);
            if (c != ' ' && c != '\t' && c != '\r' && c != '\n') {
                if (trim) {
                    if (buffer.length() > 0) {
                        buffer.append(' ');
                    }
                    trim = false;
                }
                buffer.append(c);
                continue;
            }
            if (trim) continue;
            trim = true;
        }
        return buffer.toString();
    }
}

