/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.db2.jcc;

import com.ibm.db2.jcc.am.ke;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.TimeZone;

public class DBTimestamp
extends Timestamp {
    private static final long serialVersionUID = 8862206636371820956L;
    private static Calendar calendarCached__ = Calendar.getInstance();
    private long picos_;
    private TimeZone timeZone_;

    public DBTimestamp(long l2) {
        super(l2);
        this.picos_ = (long)this.getNanos() * 1000L;
        this.timeZone_ = TimeZone.getDefault();
    }

    public DBTimestamp(long l2, Calendar calendar) {
        super(l2);
        this.picos_ = (long)this.getNanos() * 1000L;
        this.timeZone_ = (TimeZone)calendar.getTimeZone().clone();
    }

    public DBTimestamp(Timestamp timestamp) {
        super(timestamp.getTime());
        if (timestamp instanceof DBTimestamp) {
            this.setPicos(((DBTimestamp)timestamp).getPicos());
        } else {
            this.setNanos(timestamp.getNanos());
        }
        this.timeZone_ = TimeZone.getDefault();
    }

    public DBTimestamp(Timestamp timestamp, Calendar calendar) {
        super(timestamp.getTime());
        if (timestamp instanceof DBTimestamp) {
            this.setPicos(((DBTimestamp)timestamp).getPicos());
        } else {
            this.setNanos(timestamp.getNanos());
        }
        this.timeZone_ = (TimeZone)calendar.getTimeZone().clone();
    }

    public void setPicos(long l2) {
        if (l2 > 999999999999L || l2 < 0L) {
            throw new IllegalArgumentException("picos > 999999999999 or < 0");
        }
        this.setNanos((int)(l2 / 1000L));
        this.picos_ = l2;
    }

    public long getPicos() {
        return this.picos_;
    }

    public void setTimeZone(TimeZone timeZone) {
        this.timeZone_ = (TimeZone)timeZone.clone();
    }

    public TimeZone getTimeZone() {
        return this.timeZone_;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setTime(long l2) {
        DBTimestamp dBTimestamp = this;
        synchronized (dBTimestamp) {
            super.setTime(l2);
            this.picos_ = (long)this.getNanos() * 1000L;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setNanos(int n2) {
        DBTimestamp dBTimestamp = this;
        synchronized (dBTimestamp) {
            super.setNanos(n2);
            this.picos_ = (long)n2 * 1000L;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static DBTimestamp valueOfDBString(String string) {
        ke ke2 = ke.a(1);
        Calendar calendar = calendarCached__;
        synchronized (calendar) {
            return (DBTimestamp)ke2.a(string, calendarCached__, false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String toDBString(boolean bl2) {
        int n2;
        int n3;
        int n4;
        int n5;
        int n6;
        int n7;
        Comparable<Calendar> comparable = calendarCached__;
        synchronized (comparable) {
            calendarCached__.setTimeZone(this.timeZone_);
            calendarCached__.setTimeInMillis(this.getTime());
            n7 = calendarCached__.get(5);
            n6 = calendarCached__.get(2);
            n5 = calendarCached__.get(1) - 1900;
            n4 = calendarCached__.get(11);
            n3 = calendarCached__.get(12);
            n2 = calendarCached__.get(13);
        }
        comparable = new StringBuffer(38);
        ((StringBuffer)comparable).append(n5 + 1900);
        ((StringBuffer)comparable).append('-');
        ((StringBuffer)comparable).append((n6 + 1) / 10);
        ((StringBuffer)comparable).append((n6 + 1) % 10);
        ((StringBuffer)comparable).append('-');
        ((StringBuffer)comparable).append(n7 / 10);
        ((StringBuffer)comparable).append(n7 % 10);
        ((StringBuffer)comparable).append('-');
        ((StringBuffer)comparable).append(n4 / 10);
        ((StringBuffer)comparable).append(n4 % 10);
        ((StringBuffer)comparable).append('.');
        ((StringBuffer)comparable).append(n3 / 10);
        ((StringBuffer)comparable).append(n3 % 10);
        ((StringBuffer)comparable).append('.');
        ((StringBuffer)comparable).append(n2 / 10);
        ((StringBuffer)comparable).append(n2 % 10);
        ((StringBuffer)comparable).append('.');
        String string = Long.toString(this.picos_);
        String string2 = "000000000000";
        if (this.picos_ != 0L) {
            string = string2.substring(0, 12 - string.length()) + string;
            char[] cArray = new char[string.length()];
            string.getChars(0, string.length(), cArray, 0);
            int n8 = 11;
            while (cArray[n8] == '0') {
                --n8;
            }
            if (n8 != 11) {
                string = new String(cArray, 0, n8 + 1);
            }
        }
        ((StringBuffer)comparable).append(string);
        if (bl2) {
            ((StringBuffer)comparable).append(this.formatTimeZone());
        }
        return ((StringBuffer)comparable).toString();
    }

    private String formatTimeZone() {
        int n2 = this.timeZone_.getOffset(this.getTime()) / 60000;
        int n3 = n2 < 0 ? 45 : 43;
        n2 = n2 < 0 ? -1 * n2 : n2;
        int n4 = n2 / 60;
        int n5 = n2 % 60;
        char[] cArray = new char[6];
        int n6 = 48;
        cArray[0] = n3;
        cArray[1] = (char)(n4 / 10 + n6);
        cArray[2] = (char)(n4 % 10 + n6);
        cArray[3] = 58;
        cArray[4] = (char)(n5 / 10 + n6);
        cArray[5] = (char)(n5 % 10 + n6);
        return new String(cArray);
    }
}

