/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.sqlserver.jdbc;

import com.microsoft.sqlserver.jdbc.DriverJDBCVersion;
import com.microsoft.sqlserver.jdbc.ISQLServerConnection;
import com.microsoft.sqlserver.jdbc.SQLServerConnection;
import com.microsoft.sqlserver.jdbc.SQLServerException;
import java.io.Serializable;
import java.security.Permission;
import java.sql.Array;
import java.sql.Blob;
import java.sql.CallableStatement;
import java.sql.Clob;
import java.sql.DatabaseMetaData;
import java.sql.NClob;
import java.sql.PreparedStatement;
import java.sql.SQLClientInfoException;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.sql.SQLPermission;
import java.sql.SQLWarning;
import java.sql.SQLXML;
import java.sql.Savepoint;
import java.sql.Statement;
import java.sql.Struct;
import java.text.Format;
import java.text.MessageFormat;
import java.util.Map;
import java.util.Properties;
import java.util.UUID;
import java.util.concurrent.Executor;
import java.util.logging.Level;

class SQLServerConnectionPoolProxy
implements ISQLServerConnection,
Serializable {
    private SQLServerConnection wrappedConnection;
    private boolean bIsOpen;
    private static int baseConnectionID = 0;
    private final String traceID = " ProxyConnectionID:" + SQLServerConnectionPoolProxy.nextConnectionID();
    private static final String callAbortPerm = "callAbort";

    private static synchronized int nextConnectionID() {
        return ++baseConnectionID;
    }

    public String toString() {
        return this.traceID;
    }

    SQLServerConnectionPoolProxy(SQLServerConnection sQLServerConnection) {
        this.wrappedConnection = sQLServerConnection;
        sQLServerConnection.setAssociatedProxy(this);
        this.bIsOpen = true;
    }

    void checkClosed() throws SQLServerException {
        if (!this.bIsOpen) {
            SQLServerException.makeFromDriverError(null, null, SQLServerException.getErrString("R_connectionIsClosed"), null, false);
        }
    }

    @Override
    public Statement createStatement() throws SQLServerException {
        this.checkClosed();
        return this.wrappedConnection.createStatement();
    }

    @Override
    public PreparedStatement prepareStatement(String string) throws SQLServerException {
        this.checkClosed();
        return this.wrappedConnection.prepareStatement(string);
    }

    @Override
    public CallableStatement prepareCall(String string) throws SQLServerException {
        this.checkClosed();
        return this.wrappedConnection.prepareCall(string);
    }

    @Override
    public String nativeSQL(String string) throws SQLServerException {
        this.checkClosed();
        return this.wrappedConnection.nativeSQL(string);
    }

    @Override
    public void setAutoCommit(boolean bl) throws SQLServerException {
        this.checkClosed();
        this.wrappedConnection.setAutoCommit(bl);
    }

    @Override
    public boolean getAutoCommit() throws SQLServerException {
        this.checkClosed();
        return this.wrappedConnection.getAutoCommit();
    }

    @Override
    public void commit() throws SQLServerException {
        this.checkClosed();
        this.wrappedConnection.commit();
    }

    @Override
    public void rollback() throws SQLServerException {
        this.checkClosed();
        this.wrappedConnection.rollback();
    }

    @Override
    public void abort(Executor executor) throws SQLException {
        Object[] objectArray;
        Object object;
        DriverJDBCVersion.checkSupportsJDBC41();
        if (!this.bIsOpen || null == this.wrappedConnection) {
            return;
        }
        if (null == executor) {
            object = new MessageFormat(SQLServerException.getErrString("R_invalidArgument"));
            objectArray = new Object[]{"executor"};
            SQLServerException.makeFromDriverError(null, null, ((Format)object).format(objectArray), null, false);
        }
        if ((object = System.getSecurityManager()) != null) {
            try {
                objectArray = new SQLPermission(callAbortPerm);
                ((SecurityManager)object).checkPermission((Permission)objectArray);
            }
            catch (SecurityException securityException) {
                MessageFormat messageFormat = new MessageFormat(SQLServerException.getErrString("R_permissionDenied"));
                Object[] objectArray2 = new Object[]{callAbortPerm};
                throw new SQLServerException(messageFormat.format(objectArray2), null, 0, (Throwable)securityException);
            }
        }
        this.bIsOpen = false;
        executor.execute(new Runnable(){

            @Override
            public void run() {
                if (SQLServerConnectionPoolProxy.this.wrappedConnection.getConnectionLogger().isLoggable(Level.FINER)) {
                    SQLServerConnectionPoolProxy.this.wrappedConnection.getConnectionLogger().finer(this.toString() + " Connection proxy aborted ");
                }
                try {
                    SQLServerConnectionPoolProxy.this.wrappedConnection.poolCloseEventNotify();
                    SQLServerConnectionPoolProxy.this.wrappedConnection = null;
                }
                catch (SQLException sQLException) {
                    throw new RuntimeException(sQLException);
                }
            }
        });
    }

    @Override
    public void close() throws SQLServerException {
        if (this.bIsOpen && null != this.wrappedConnection) {
            if (this.wrappedConnection.getConnectionLogger().isLoggable(Level.FINER)) {
                this.wrappedConnection.getConnectionLogger().finer(this.toString() + " Connection proxy closed ");
            }
            this.wrappedConnection.poolCloseEventNotify();
            this.wrappedConnection = null;
        }
        this.bIsOpen = false;
    }

    void internalClose() {
        this.bIsOpen = false;
        this.wrappedConnection = null;
    }

    @Override
    public boolean isClosed() throws SQLServerException {
        return !this.bIsOpen;
    }

    @Override
    public DatabaseMetaData getMetaData() throws SQLServerException {
        this.checkClosed();
        return this.wrappedConnection.getMetaData();
    }

    @Override
    public void setReadOnly(boolean bl) throws SQLServerException {
        this.checkClosed();
        this.wrappedConnection.setReadOnly(bl);
    }

    @Override
    public boolean isReadOnly() throws SQLServerException {
        this.checkClosed();
        return this.wrappedConnection.isReadOnly();
    }

    @Override
    public void setCatalog(String string) throws SQLServerException {
        this.checkClosed();
        this.wrappedConnection.setCatalog(string);
    }

    @Override
    public String getCatalog() throws SQLServerException {
        this.checkClosed();
        return this.wrappedConnection.getCatalog();
    }

    @Override
    public void setTransactionIsolation(int n) throws SQLServerException {
        this.checkClosed();
        this.wrappedConnection.setTransactionIsolation(n);
    }

    @Override
    public int getTransactionIsolation() throws SQLServerException {
        this.checkClosed();
        return this.wrappedConnection.getTransactionIsolation();
    }

    @Override
    public SQLWarning getWarnings() throws SQLServerException {
        this.checkClosed();
        return this.wrappedConnection.getWarnings();
    }

    @Override
    public void clearWarnings() throws SQLServerException {
        this.checkClosed();
        this.wrappedConnection.clearWarnings();
    }

    @Override
    public Statement createStatement(int n, int n2) throws SQLException {
        this.checkClosed();
        return this.wrappedConnection.createStatement(n, n2);
    }

    @Override
    public PreparedStatement prepareStatement(String string, int n, int n2) throws SQLException {
        this.checkClosed();
        return this.wrappedConnection.prepareStatement(string, n, n2);
    }

    @Override
    public CallableStatement prepareCall(String string, int n, int n2) throws SQLException {
        this.checkClosed();
        return this.wrappedConnection.prepareCall(string, n, n2);
    }

    @Override
    public void setTypeMap(Map<String, Class<?>> map) throws SQLServerException {
        this.checkClosed();
        this.wrappedConnection.setTypeMap(map);
    }

    @Override
    public Map<String, Class<?>> getTypeMap() throws SQLServerException {
        this.checkClosed();
        return this.wrappedConnection.getTypeMap();
    }

    @Override
    public Statement createStatement(int n, int n2, int n3) throws SQLServerException {
        this.checkClosed();
        return this.wrappedConnection.createStatement(n, n2, n3);
    }

    @Override
    public PreparedStatement prepareStatement(String string, int n, int n2, int n3) throws SQLServerException {
        this.checkClosed();
        return this.wrappedConnection.prepareStatement(string, n, n2, n3);
    }

    @Override
    public CallableStatement prepareCall(String string, int n, int n2, int n3) throws SQLServerException {
        this.checkClosed();
        return this.wrappedConnection.prepareCall(string, n, n2, n3);
    }

    @Override
    public PreparedStatement prepareStatement(String string, int n) throws SQLServerException {
        this.checkClosed();
        return this.wrappedConnection.prepareStatement(string, n);
    }

    @Override
    public PreparedStatement prepareStatement(String string, int[] nArray) throws SQLServerException {
        this.checkClosed();
        return this.wrappedConnection.prepareStatement(string, nArray);
    }

    @Override
    public PreparedStatement prepareStatement(String string, String[] stringArray) throws SQLServerException {
        this.checkClosed();
        return this.wrappedConnection.prepareStatement(string, stringArray);
    }

    @Override
    public void releaseSavepoint(Savepoint savepoint) throws SQLServerException {
        this.checkClosed();
        this.wrappedConnection.releaseSavepoint(savepoint);
    }

    @Override
    public Savepoint setSavepoint(String string) throws SQLServerException {
        this.checkClosed();
        return this.wrappedConnection.setSavepoint(string);
    }

    @Override
    public Savepoint setSavepoint() throws SQLServerException {
        this.checkClosed();
        return this.wrappedConnection.setSavepoint();
    }

    @Override
    public void rollback(Savepoint savepoint) throws SQLServerException {
        this.checkClosed();
        this.wrappedConnection.rollback(savepoint);
    }

    @Override
    public int getHoldability() throws SQLServerException {
        this.checkClosed();
        return this.wrappedConnection.getHoldability();
    }

    @Override
    public void setHoldability(int n) throws SQLServerException {
        this.checkClosed();
        this.wrappedConnection.setHoldability(n);
    }

    @Override
    public int getNetworkTimeout() throws SQLException {
        DriverJDBCVersion.checkSupportsJDBC41();
        throw new SQLFeatureNotSupportedException(SQLServerException.getErrString("R_notSupported"));
    }

    @Override
    public void setNetworkTimeout(Executor executor, int n) throws SQLException {
        DriverJDBCVersion.checkSupportsJDBC41();
        throw new SQLFeatureNotSupportedException(SQLServerException.getErrString("R_notSupported"));
    }

    @Override
    public String getSchema() throws SQLException {
        DriverJDBCVersion.checkSupportsJDBC41();
        this.checkClosed();
        return this.wrappedConnection.getSchema();
    }

    @Override
    public void setSchema(String string) throws SQLException {
        DriverJDBCVersion.checkSupportsJDBC41();
        this.checkClosed();
        this.wrappedConnection.setSchema(string);
    }

    @Override
    public Array createArrayOf(String string, Object[] objectArray) throws SQLException {
        DriverJDBCVersion.checkSupportsJDBC4();
        this.checkClosed();
        return this.wrappedConnection.createArrayOf(string, objectArray);
    }

    @Override
    public Blob createBlob() throws SQLException {
        DriverJDBCVersion.checkSupportsJDBC4();
        this.checkClosed();
        return this.wrappedConnection.createBlob();
    }

    @Override
    public Clob createClob() throws SQLException {
        DriverJDBCVersion.checkSupportsJDBC4();
        this.checkClosed();
        return this.wrappedConnection.createClob();
    }

    @Override
    public NClob createNClob() throws SQLException {
        DriverJDBCVersion.checkSupportsJDBC4();
        this.checkClosed();
        return this.wrappedConnection.createNClob();
    }

    @Override
    public SQLXML createSQLXML() throws SQLException {
        DriverJDBCVersion.checkSupportsJDBC4();
        this.checkClosed();
        return this.wrappedConnection.createSQLXML();
    }

    @Override
    public Struct createStruct(String string, Object[] objectArray) throws SQLException {
        DriverJDBCVersion.checkSupportsJDBC4();
        this.checkClosed();
        return this.wrappedConnection.createStruct(string, objectArray);
    }

    @Override
    public Properties getClientInfo() throws SQLException {
        DriverJDBCVersion.checkSupportsJDBC4();
        this.checkClosed();
        return this.wrappedConnection.getClientInfo();
    }

    @Override
    public String getClientInfo(String string) throws SQLException {
        DriverJDBCVersion.checkSupportsJDBC4();
        this.checkClosed();
        return this.wrappedConnection.getClientInfo(string);
    }

    @Override
    public void setClientInfo(Properties properties) throws SQLClientInfoException {
        DriverJDBCVersion.checkSupportsJDBC4();
        this.wrappedConnection.setClientInfo(properties);
    }

    @Override
    public void setClientInfo(String string, String string2) throws SQLClientInfoException {
        DriverJDBCVersion.checkSupportsJDBC4();
        this.wrappedConnection.setClientInfo(string, string2);
    }

    @Override
    public boolean isValid(int n) throws SQLException {
        DriverJDBCVersion.checkSupportsJDBC4();
        this.checkClosed();
        return this.wrappedConnection.isValid(n);
    }

    @Override
    public boolean isWrapperFor(Class<?> clazz) throws SQLException {
        this.wrappedConnection.getConnectionLogger().entering(this.toString(), "isWrapperFor", clazz);
        DriverJDBCVersion.checkSupportsJDBC4();
        boolean bl = clazz.isInstance(this);
        this.wrappedConnection.getConnectionLogger().exiting(this.toString(), "isWrapperFor", bl);
        return bl;
    }

    @Override
    public <T> T unwrap(Class<T> clazz) throws SQLException {
        T t;
        this.wrappedConnection.getConnectionLogger().entering(this.toString(), "unwrap", clazz);
        DriverJDBCVersion.checkSupportsJDBC4();
        try {
            t = clazz.cast(this);
        }
        catch (ClassCastException classCastException) {
            SQLServerException sQLServerException = new SQLServerException(classCastException.getMessage(), classCastException);
            throw sQLServerException;
        }
        this.wrappedConnection.getConnectionLogger().exiting(this.toString(), "unwrap", t);
        return t;
    }

    @Override
    public UUID getClientConnectionId() throws SQLServerException {
        this.checkClosed();
        return this.wrappedConnection.getClientConnectionId();
    }
}

