/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.bux.contributor.impl;

import com.ibm.cognos.bux.BUXBaseActivator;
import com.ibm.cognos.bux.config.BiBusConfiguration;
import com.ibm.cognos.bux.config.BiBusConfigurationManager;
import com.ibm.cognos.bux.contributor.impl.EntryClassMappingImpl;
import com.ibm.cognos.bux.contributor.impl.EntryContributor;
import com.ibm.cognos.bux.contributor.impl.HostAliasImpl;
import com.ibm.cognos.bux.contributor.impl.LinkContributorImpl;
import com.ibm.cognos.bux.contributor.impl.MultiConfigHashMap;
import com.ibm.cognos.bux.contributor.impl.ProxyConfigRulesImpl;
import com.ibm.cognos.bux.contributor.impl.RemoteProviderMappingImpl;
import com.ibm.cognos.bux.contributor.launcher.IContributorFragmentsInstalled;
import com.ibm.cognos.bux.contributor.launcher.IContributorImplRegistered;
import com.ibm.cognos.bux.contributor.launcher.IContributorImplStarted;
import com.ibm.cognos.bux.ext.proxy.ProxyConfigRules;
import com.ibm.cognos.bux.http.RemoteTarget;
import com.ibm.cognos.bux.http.TemplateRemoteTarget;
import com.ibm.cognos.bux.http.URLTemplate;
import com.ibm.cognos.bux.logging.BUXLoggerFactory;
import com.ibm.cognos.bux.logging.BUXTraceLogger;
import com.ibm.cognos.bux.schemas.XmlBase;
import com.ibm.cognos.bux.schemas.atom.AtomBase;
import com.ibm.cognos.bux.schemas.atom.AtomType;
import com.ibm.cognos.bux.schemas.atom.CategoryType;
import com.ibm.cognos.bux.schemas.atom.EntryType;
import com.ibm.cognos.bux.schemas.atom.FeedType;
import com.ibm.cognos.bux.schemas.atom.LinkType;
import com.ibm.cognos.bux.service.atom.ext.intf.AtomProcessor;
import com.ibm.cognos.bux.service.atom.ext.intf.EntryClass;
import com.ibm.cognos.bux.service.atom.ext.intf.EntryClassImpl;
import com.ibm.cognos.bux.service.atom.ext.intf.EntryClassMapping;
import com.ibm.cognos.bux.service.atom.ext.intf.HostAlias;
import com.ibm.cognos.bux.service.atom.ext.intf.LinkContributor;
import com.ibm.cognos.bux.service.atom.ext.intf.RemoteProviderMapping;
import com.ibm.cognos.bux.utils.EncodingUtils;
import com.ibm.cognos.bux.utils.xml.dom.DomUtils;
import com.ibm.cognos.bux.utils.xml.dom.TraverseCallback;
import com.ibm.cognos.bux.utils.xml.stream.XMLStreamFactory;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Dictionary;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamReader;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.osgi.framework.ServiceRegistration;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DynamicContributorActivator
extends BUXBaseActivator {
    private BundleContext bundleContext;
    private ServiceRegistration regIContributorInstalled;
    private ServiceRegistration regIContributorImplStarted;
    private final List<ServiceRegistration> registrations = new ArrayList<ServiceRegistration>();
    private final BiBusConfiguration bibusConfig = BiBusConfigurationManager.getInstance();
    private Map<String, Object> tokens;
    private static BUXTraceLogger traceLogger = BUXLoggerFactory.getLogger((String)DynamicContributorActivator.class.getName());
    private static final String ATOM_EXTENSION = ".atom";

    public void start(BundleContext context) throws Exception {
        boolean isContributorFragmentsInstalled;
        this.bundleContext = context;
        EntryContributor.setResourceClassLoader(((Object)((Object)this)).getClass().getClassLoader());
        ServiceReference refIContributorFragmentsInstalled = null;
        try {
            refIContributorFragmentsInstalled = this.bundleContext.getServiceReference(IContributorFragmentsInstalled.class.getName());
            boolean bl = isContributorFragmentsInstalled = refIContributorFragmentsInstalled != null;
            if (traceLogger.isDebugEnabled()) {
                traceLogger.debug("start()", "isContributorFragmentsInstalled=" + isContributorFragmentsInstalled, null);
            }
        }
        finally {
            if (refIContributorFragmentsInstalled != null) {
                this.bundleContext.ungetService(refIContributorFragmentsInstalled);
            }
        }
        ContributorImplStarted implStartedService = new ContributorImplStarted(isContributorFragmentsInstalled);
        Hashtable<String, String> props = new Hashtable<String, String>();
        ((Dictionary)props).put("contributorsDetected", Boolean.toString(isContributorFragmentsInstalled));
        if (traceLogger.isDebugEnabled()) {
            traceLogger.debug("start()", "pre-register impl started service", null);
        }
        this.regIContributorImplStarted = this.bundleContext.registerService(IContributorImplStarted.class.getName(), (Object)implStartedService, props);
        if (traceLogger.isDebugEnabled()) {
            traceLogger.debug("start()", "post-register impl started service", null);
        }
        if (isContributorFragmentsInstalled) {
            Bundle bundle = context.getBundle();
            this.registerCommonAliases();
            Enumeration paths = bundle.findEntries("/contrib", "*.atom", false);
            while (paths != null && paths.hasMoreElements()) {
                URL entryPath = (URL)paths.nextElement();
                String contributorName = DynamicContributorActivator.getContributorName(entryPath);
                if (contributorName == null) continue;
                this.processContribution(contributorName, entryPath);
            }
            this.regIContributorInstalled = this.bundleContext.registerService(IContributorImplRegistered.class.getName(), (Object)new ContributorInstalledImpl(), new Hashtable());
        }
        if (traceLogger.isDebugEnabled()) {
            traceLogger.debug("start()", "started.", null);
        }
        super.start(context);
    }

    public static String getContributorName(URL entryPath) {
        int posOfATOMExtention;
        String path = entryPath.toString();
        int posOfLastSeparator = path.lastIndexOf(47);
        if (posOfLastSeparator >= 0 && (posOfATOMExtention = path.toLowerCase().lastIndexOf(ATOM_EXTENSION)) > 0) {
            return path.substring(posOfLastSeparator + 1, posOfATOMExtention);
        }
        return null;
    }

    public void stop(BundleContext context) throws Exception {
        for (ServiceRegistration sr : this.registrations) {
            sr.unregister();
        }
        if (this.regIContributorInstalled != null) {
            this.regIContributorInstalled.unregister();
            this.regIContributorInstalled = null;
        }
        if (this.regIContributorImplStarted != null) {
            this.regIContributorImplStarted.unregister();
            this.regIContributorImplStarted = null;
        }
        this.tokens = null;
        if (traceLogger.isDebugEnabled()) {
            traceLogger.debug("stop()", "stopped.", null);
        }
        super.stop(context);
    }

    private CategoryType getContributionType(EntryType entry) {
        for (CategoryType cat : entry.getCategoryList()) {
            if (!cat.getScheme().equals("http://www.ibm.com/xmlns/prod/cognos/icd/contribution#type")) continue;
            return cat;
        }
        return null;
    }

    private Map<String, Object> getMacrosTokens() {
        if (this.tokens == null) {
            MultiConfigHashMap result = new MultiConfigHashMap(((Object)((Object)this)).getClass().getClassLoader());
            String dispatcherURI = this.bibusConfig.getDispatcherURI();
            result.put("bus", dispatcherURI);
            result.put("enc:bus", EncodingUtils.urlencode((String)dispatcherURI, (String)"UTF8", (boolean)false, (StringBuilder)new StringBuilder()));
            this.tokens = result;
        }
        return this.tokens;
    }

    private void processContribution(String contributorName, URL entryPath) {
        if (traceLogger.isDebugEnabled()) {
            traceLogger.debug("processContribution()", "processing " + entryPath.toString(), null);
        }
        FeedType feed = this.parseFeed(entryPath);
        this.publishContributions(contributorName, (AtomType)feed);
        for (EntryType entry : feed.getEntryList()) {
            CategoryType contributionTypeCategory = this.getContributionType(entry);
            if (contributionTypeCategory != null) {
                String contributionType = contributionTypeCategory.getTerm();
                if ("toolbox".equals(contributionType)) {
                    this.addToolboxContributor(contributorName, entry);
                } else if ("rootfeed".equals(contributionType)) {
                    this.addRootFeedContributor(contributorName, entry);
                } else if ("typedfeed".equals(contributionType)) {
                    this.addTypedFeedContributor(contributorName, contributionTypeCategory, entry);
                } else if ("typedviewer".equals(contributionType)) {
                    this.addTypedViewerContributor(contributorName, contributionTypeCategory, entry);
                }
            }
            this.publishContributions(contributorName, (AtomType)entry);
        }
    }

    private void publishContributions(String contributorName, AtomType atom) {
        Iterator it = atom.getDomOtherList().iterator();
        while (it.hasNext()) {
            Element element = (Element)it.next();
            if (!this.publishRemoteProviderMappings(contributorName, element) && !this.publishProxyRules(contributorName, element) && !this.publishAliases(contributorName, element)) continue;
            it.remove();
        }
        for (LinkType link : atom.getLinkList()) {
            Iterator it2 = link.getDomOtherList().iterator();
            while (it2.hasNext()) {
                Element element = (Element)it2.next();
                if (!this.publishRemoteProviderMappings(contributorName, element) && !this.publishProxyRules(contributorName, element) && !this.publishAliases(contributorName, element) && !this.publishEntryClassMappings(contributorName, element)) continue;
                it2.remove();
            }
        }
    }

    private void registerCommonAliases() {
        Hashtable<String, String> props = new Hashtable<String, String>();
        ((Dictionary)props).put("contributor", "system");
        String cfgcgi = this.bibusConfig.getValue("gateway", true);
        this.registrations.add(this.bundleContext.registerService(HostAlias.class.getName(), (Object)new HostAliasImpl("cfgcgi", cfgcgi), props));
    }

    private FeedType parseFeed(URL resourceURL) {
        AtomBase atom;
        block16: {
            atom = null;
            InputStream is = null;
            XMLStreamReader xsr = null;
            try {
                try {
                    is = resourceURL.openStream();
                    xsr = XMLStreamFactory.createXMLStreamReader((InputStream)is);
                    if (xsr != null && 1 == xsr.nextTag()) {
                        Class klass = XmlBase.findElementClass((QName)xsr.getName());
                        atom = (AtomBase)klass.newInstance();
                        atom.read(xsr, null);
                    }
                }
                catch (Exception x) {
                    if (traceLogger.isErrorEnabled()) {
                        traceLogger.error("parseFeed()", "problem parsing contribution: " + x.getMessage(), (Throwable)x, null);
                    }
                    XMLStreamFactory.closeXMLStreamAndIgnoreExceptions((XMLStreamReader)xsr);
                    try {
                        if (is != null) {
                            is.close();
                        }
                        break block16;
                    }
                    catch (Exception exception) {}
                    break block16;
                }
            }
            catch (Throwable throwable) {
                XMLStreamFactory.closeXMLStreamAndIgnoreExceptions(xsr);
                try {
                    if (is != null) {
                        is.close();
                    }
                }
                catch (Exception exception) {}
                throw throwable;
            }
            XMLStreamFactory.closeXMLStreamAndIgnoreExceptions((XMLStreamReader)xsr);
            try {
                if (is != null) {
                    is.close();
                }
            }
            catch (Exception exception) {}
        }
        return (FeedType)atom;
    }

    private void addToolboxContributor(String contributorName, EntryType entry) {
        Hashtable<String, String> registrationProperties = new Hashtable<String, String>();
        ((Dictionary)registrationProperties).put("purpose", "toolbox");
        ((Dictionary)registrationProperties).put("stage", "contentgeneration");
        ((Dictionary)registrationProperties).put("contributor", contributorName);
        EntryContributor entryContributor = new EntryContributor(entry);
        this.registrations.add(this.bundleContext.registerService(AtomProcessor.class.getName(), (Object)entryContributor, registrationProperties));
    }

    private void addRootFeedContributor(String contributorName, EntryType entry) {
        Hashtable<String, String> registrationProperties = new Hashtable<String, String>();
        ((Dictionary)registrationProperties).put("purpose", "rootfeed");
        ((Dictionary)registrationProperties).put("stage", "contentgeneration");
        ((Dictionary)registrationProperties).put("contributor", contributorName);
        EntryContributor entryContributor = new EntryContributor(entry);
        this.registrations.add(this.bundleContext.registerService(AtomProcessor.class.getName(), (Object)entryContributor, registrationProperties));
    }

    private void addTypedFeedContributor(String contributorName, CategoryType contributionTypeCategory, EntryType entry) {
        this.addLinkContributors(contributorName, contributionTypeCategory, entry, "alternate", "application/atom+xml");
    }

    private void addTypedViewerContributor(String contributorName, CategoryType contributionTypeCategory, EntryType entry) {
        this.addLinkContributors(contributorName, contributionTypeCategory, entry, "alternate", "application/x-iwidget+xml");
    }

    private void addLinkContributors(String contributorName, CategoryType contribTypeCategory, EntryType entry, String rel, String type) {
        Hashtable<String, String> registrationProperties = new Hashtable<String, String>();
        ((Dictionary)registrationProperties).put("contributor", contributorName);
        List<EntryClass> entryClasses = this.getEntryClasses(contribTypeCategory);
        LinkType link = DynamicContributorActivator.findLink(entry, rel, type);
        if (entryClasses != null && link != null) {
            for (EntryClass entryClass : entryClasses) {
                LinkContributorImpl linkContributor = new LinkContributorImpl(entryClass);
                for (LinkType anyLink : entry.getLinkList()) {
                    linkContributor.addLink(anyLink);
                }
                this.registrations.add(this.bundleContext.registerService(LinkContributor.class.getName(), (Object)linkContributor, registrationProperties));
            }
        }
    }

    private List<EntryClass> getEntryClasses(CategoryType contributionTypeCategory) {
        List domOtherList = contributionTypeCategory.getDomOtherList();
        ArrayList<EntryClassImpl> entryClasses = null;
        Iterator it = domOtherList.iterator();
        while (it.hasNext()) {
            block4: {
                Element element = (Element)it.next();
                if (!"http://www.ibm.com/xmlns/prod/cognos/icd/contribution".equals(element.getNamespaceURI()) || !"associatedtype".equals(element.getLocalName())) continue;
                String associatedtype = DomUtils.getTextContent((Node)element).trim();
                try {
                    EntryClassImpl entryClass = new EntryClassImpl(associatedtype);
                    if (entryClasses == null) {
                        entryClasses = new ArrayList<EntryClassImpl>();
                    }
                    entryClasses.add(entryClass);
                }
                catch (Exception x) {
                    if (!traceLogger.isErrorEnabled()) break block4;
                    traceLogger.error("getEntryClasses()", "problem processing associatedtype entry class value: " + associatedtype, (Throwable)x, null);
                }
            }
            it.remove();
        }
        return entryClasses;
    }

    private boolean publishRemoteProviderMappings(String contributorName, Element element) {
        if ("http://www.ibm.com/xmlns/prod/cognos/icd/contribution".equals(element.getNamespaceURI()) && "externalFeedMapping".equals(element.getLocalName())) {
            String localPath = DynamicContributorActivator.getChildElementTextValue(element, "local");
            String remoteUrl = DynamicContributorActivator.getChildElementTextValue(element, "remote");
            String cookiePolicy = DynamicContributorActivator.getChildElementTextValue(element, "cookiePolicy");
            if (localPath != null && remoteUrl != null) {
                URLTemplate urlTemplate = new URLTemplate(remoteUrl);
                DynamicContributorActivator.addInclusionExclusion(element, urlTemplate);
                TemplateRemoteTarget remoteTarget = new TemplateRemoteTarget(urlTemplate, cookiePolicy);
                Hashtable<String, String> props = new Hashtable<String, String>();
                ((Dictionary)props).put("contributor", contributorName);
                ((Dictionary)props).put("localPath", localPath);
                ((Dictionary)props).put("remoteUrl", remoteUrl);
                this.registrations.add(this.bundleContext.registerService(RemoteProviderMapping.class.getName(), (Object)new RemoteProviderMappingImpl(localPath, (RemoteTarget)remoteTarget), props));
            }
            return true;
        }
        return false;
    }

    private boolean publishEntryClassMappings(String contributorName, Element element) {
        if ("http://www.ibm.com/xmlns/prod/cognos/icd/contribution".equals(element.getNamespaceURI()) && "entryClassMapping".equals(element.getLocalName())) {
            String objectClass = DynamicContributorActivator.getChildElementTextValue(element, "objectClass");
            String userInterface = DynamicContributorActivator.getChildElementTextValue(element, "userInterface");
            String entryClass = DynamicContributorActivator.getChildElementTextValue(element, "entryClass");
            if (objectClass != null && userInterface != null && entryClass != null) {
                EntryClassMappingImpl mapping = new EntryClassMappingImpl(objectClass, userInterface, entryClass);
                Hashtable<String, String> props = new Hashtable<String, String>();
                ((Dictionary)props).put("contributor", contributorName);
                ((Dictionary)props).put("object_Class", objectClass);
                ((Dictionary)props).put("userInterface", userInterface);
                ((Dictionary)props).put("entryClass", entryClass);
                this.registrations.add(this.bundleContext.registerService(EntryClassMapping.class.getName(), (Object)mapping, props));
            }
            return true;
        }
        return false;
    }

    private boolean publishProxyRules(String contributorName, Element element) {
        if ("http://www.ibm.com/xmlns/prod/cognos/icd/contribution".equals(element.getNamespaceURI()) && "externalProxyRules".equals(element.getLocalName())) {
            Node node = DomUtils.selectSingleNode((Element)element, (String)"proxy-rules");
            if (node != null) {
                this.replaceMacros(node);
                Hashtable<String, String> props = new Hashtable<String, String>();
                ((Dictionary)props).put("contributor", contributorName);
                this.registrations.add(this.bundleContext.registerService(ProxyConfigRules.class.getName(), (Object)new ProxyConfigRulesImpl(node), props));
            }
            return true;
        }
        return false;
    }

    private boolean publishAliases(String contributorName, Element element) {
        if ("http://www.ibm.com/xmlns/prod/cognos/icd/contribution".equals(element.getNamespaceURI()) && "aliases".equals(element.getLocalName())) {
            Map<String, Object> macrosTokens = this.getMacrosTokens();
            NodeList nodes = DomUtils.selectNodes((Element)element, (String)"host");
            int i = 0;
            while (i < nodes.getLength()) {
                Element elem = (Element)nodes.item(i);
                String alias = elem.getAttribute("alias");
                String hostName = DomUtils.getTextContent((Node)elem);
                if (alias != null && alias.length() > 0 && hostName != null && hostName.length() > 0) {
                    URLTemplate template = new URLTemplate(hostName);
                    hostName = template.generateURL(macrosTokens, Collections.emptyMap());
                    Hashtable<String, String> props = new Hashtable<String, String>();
                    props.put("contributor", contributorName);
                    this.registrations.add(this.bundleContext.registerService(HostAlias.class.getName(), (Object)new HostAliasImpl(alias, hostName), props));
                }
                ++i;
            }
            return true;
        }
        return false;
    }

    private void replaceMacros(Node configNode) {
        final Map<String, Object> macrosTokens = this.getMacrosTokens();
        TraverseCallback callback = new TraverseCallback(){

            public TraverseCallback.TraverseState handle(Node node) {
                String url;
                Element el;
                String localName;
                if (1 == node.getNodeType() && ("mapping".equals(localName = DomUtils.getLocalName((Element)(el = (Element)node))) || "policy".equals(localName)) && (url = el.getAttribute("url")) != null && !"".equals(url)) {
                    URLTemplate template = new URLTemplate(url);
                    url = template.generateURL(macrosTokens, Collections.emptyMap());
                    el.setAttribute("url", url);
                }
                return TraverseCallback.TraverseState.continueNormal;
            }
        };
        DomUtils.traverse((Node)configNode, (TraverseCallback)callback);
    }

    private static void addInclusionExclusion(Element remoteMappingElement, URLTemplate urlTemplate) {
        String pattern;
        Element el;
        NodeList els = DomUtils.selectNodes((Element)remoteMappingElement, (String)"parameterInclusionPattern");
        int i = 0;
        while (i < els.getLength()) {
            el = (Element)els.item(i);
            pattern = DomUtils.getTextContent((Node)el);
            urlTemplate.addInclusionPattern(pattern);
            ++i;
        }
        if (els.getLength() > 0) {
            els = DomUtils.selectNodes((Element)remoteMappingElement, (String)"parameterExclusionPattern");
            i = 0;
            while (i < els.getLength()) {
                el = (Element)els.item(i);
                pattern = DomUtils.getTextContent((Node)el);
                urlTemplate.addExclusionPattern(pattern);
                ++i;
            }
        }
    }

    private static LinkType findLink(EntryType entry, String rel, String type) {
        for (LinkType link : entry.getLinkList()) {
            if (!rel.equals(link.getRel()) || !type.equals(link.getType())) continue;
            return link;
        }
        return null;
    }

    private static String getChildElementTextValue(Element element, String name) {
        String result = null;
        Node node = DomUtils.selectSingleNode((Element)element, (String)name);
        if (node != null) {
            result = DomUtils.getTextContent((Node)node);
        }
        return result;
    }

    static class ContributorImplStarted
    implements IContributorImplStarted {
        private final boolean contributorsAvailable;

        ContributorImplStarted(boolean contributorsAvailable) {
            this.contributorsAvailable = contributorsAvailable;
        }

        public boolean isContributorsAvailable() {
            return this.contributorsAvailable;
        }
    }

    static class ContributorInstalledImpl
    implements IContributorImplRegistered {
        ContributorInstalledImpl() {
        }

        public boolean isContributorsRegistered() {
            return true;
        }
    }
}

