/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.bux.contributor.impl;

import com.ibm.cognos.bux.config.BiBusConfigurationManager;
import com.ibm.cognos.bux.contributor.impl.MultiConfigHashMap;
import com.ibm.cognos.bux.http.RequestInformation;
import com.ibm.cognos.bux.http.ResponseInformation;
import com.ibm.cognos.bux.http.URLInformation;
import com.ibm.cognos.bux.http.URLTemplate;
import com.ibm.cognos.bux.schemas.atom.DateType;
import com.ibm.cognos.bux.schemas.atom.EntryType;
import com.ibm.cognos.bux.schemas.atom.FeedType;
import com.ibm.cognos.bux.schemas.atom.LinkType;
import com.ibm.cognos.bux.schemas.atom.PersonType;
import com.ibm.cognos.bux.schemas.atom.TextType;
import com.ibm.cognos.bux.schemas.atom._Feed;
import com.ibm.cognos.bux.service.atom.ext.intf.AtomProcessor;
import com.ibm.cognos.bux.service.atom.util.AtomOptions;
import com.ibm.cognos.bux.service.atom.util.PersonComparator;
import com.ibm.cognos.bux.utils.EncodingUtils;
import java.text.Collator;
import java.util.Calendar;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.w3c.dom.Element;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EntryContributor
implements AtomProcessor {
    private final EntryType contributionEntry;
    private static ClassLoader resourceClassLoader;
    private static final Pattern pairPattern;

    static {
        pairPattern = Pattern.compile("\\{(\\w+:\\w+)\\}");
    }

    public EntryContributor(EntryType entry) {
        this.contributionEntry = entry;
    }

    public static void setResourceClassLoader(ClassLoader classLoader) {
        resourceClassLoader = classLoader;
    }

    public ResponseInformation processFeed(RequestInformation origRequest, ResponseInformation response) throws Exception {
        if (response.getOutput() instanceof _Feed) {
            Locale localeToUse = !EntryContributor.isToolBoxFeed(origRequest) ? origRequest.getContentLocale() : origRequest.getProductLocale();
            EntryType newEntry = (EntryType)this.contributionEntry.clone(null);
            Map parameters = origRequest.getParameters();
            this.replaceMacros(newEntry, this.getTokens(origRequest, localeToUse), parameters);
            FeedType feed = (FeedType)response.getOutput();
            AtomOptions options = AtomOptions.parseParameters((Map)parameters, (boolean)EntryContributor.isCMRootRequest(origRequest));
            int index = EntryContributor.findInsertIndex(feed.getEntryList(), newEntry, localeToUse, options);
            feed.getEntryList().add(index, newEntry);
            EntryContributor.cleanLinks(feed);
            EntryContributor.cleanExtensions(feed);
        }
        return response;
    }

    private static boolean isToolBoxFeed(RequestInformation request) {
        URLInformation urlInfo = request.getUrlInfo();
        return urlInfo == null ? false : urlInfo.getPathInfo().equalsIgnoreCase("/toolbox");
    }

    private static boolean isCMRootRequest(RequestInformation request) {
        URLInformation urlInfo = request.getUrlInfo();
        return urlInfo == null ? false : urlInfo.getPathInfo().equalsIgnoreCase("/cm");
    }

    private static void cleanExtensions(FeedType feed) {
        Iterator it = feed.getDomOtherList().iterator();
        while (it.hasNext()) {
            Element element = (Element)it.next();
            if (!"http://a9.com/-/spec/opensearch/1.1/".equals(element.getNamespaceURI())) continue;
            it.remove();
        }
    }

    private static void cleanLinks(FeedType feed) {
        Iterator it = feed.getLinkList().iterator();
        while (it.hasNext()) {
            String rel = ((LinkType)it.next()).getRel();
            if (!"last".equals(rel) && !"first".equals(rel) && !"next".equals(rel) && !"previous".equals(rel)) continue;
            it.remove();
        }
    }

    private static int findInsertIndex(List<EntryType> entries, EntryType entry, Locale locale, AtomOptions options) {
        Comparator<EntryType> fieldComp;
        if (options.getSortOrder() == AtomOptions.SortOrder.defaultOrder && options.isNoSort()) {
            return entries.size();
        }
        switch (options.getSortField()) {
            case createdby: {
                fieldComp = new Comparator<EntryType>(){

                    @Override
                    public int compare(EntryType entry1, EntryType entry2) {
                        List list1 = entry1.getAuthorList();
                        List list2 = entry2.getAuthorList();
                        PersonType person1 = list1.size() > 0 ? (PersonType)list1.get(0) : null;
                        PersonType person2 = list2.size() > 0 ? (PersonType)list2.get(0) : null;
                        return PersonComparator.getInstance().compare(person1, person2);
                    }
                };
                break;
            }
            case lastmod: {
                fieldComp = new Comparator<EntryType>(){

                    @Override
                    public int compare(EntryType entry1, EntryType entry2) {
                        Calendar cal2;
                        DateType date1 = entry1.getUpdated();
                        DateType date2 = entry2.getUpdated();
                        Calendar cal1 = date1 == null ? null : date1.getValue();
                        Calendar calendar = cal2 = date2 == null ? null : date2.getValue();
                        if (cal1 != null && cal2 != null) {
                            return cal1.compareTo(cal2);
                        }
                        return cal1 == null ? (cal2 == null ? 0 : 1) : -1;
                    }
                };
                break;
            }
            default: {
                final Collator coll = Collator.getInstance(locale);
                fieldComp = new Comparator<EntryType>(){

                    @Override
                    public int compare(EntryType entry1, EntryType entry2) {
                        String text2;
                        TextType title1 = entry1.getTitle();
                        TextType title2 = entry2.getTitle();
                        String text1 = title1 == null ? null : title1.getContent();
                        String string = text2 = title2 == null ? null : title2.getContent();
                        if (text1 != null && text2 != null) {
                            return coll.compare(text1, text2);
                        }
                        return text1 == null ? (text2 == null ? 0 : 1) : -1;
                    }
                };
            }
        }
        Comparator<EntryType> orderComp = options.getSortOrder() == AtomOptions.SortOrder.descending ? new Comparator<EntryType>(){

            @Override
            public int compare(EntryType entry1, EntryType entry2) {
                return fieldComp.compare(entry2, entry1);
            }
        } : fieldComp;
        return EntryContributor.searchInsertIndex(entries, entry, orderComp);
    }

    private Map<String, Object> getTokens(RequestInformation request, Locale locale) {
        MultiConfigHashMap tokens = new MultiConfigHashMap(resourceClassLoader, locale);
        if (request.getHeaders() != null) {
            String cgiURI = (String)request.getHeaders().get("script-name");
            tokens.put("web", request.getHeaders().get("original-web-url"));
            tokens.put("cgi", cgiURI);
            tokens.put("enc:cgi", EncodingUtils.urlencode((String)cgiURI, (String)"UTF8", (boolean)false, (StringBuilder)new StringBuilder()));
        }
        tokens.put("dispatcherURI", BiBusConfigurationManager.getInstance().getDispatcherURI());
        return tokens;
    }

    private void replaceMacros(EntryType entry, Map<String, Object> tokens, Map<String, String[]> params) {
        List links;
        String text;
        if (entry.getTitle() != null && (text = EntryContributor.replaceText(entry.getTitle().getContent(), tokens)) != null) {
            entry.getTitle().setContent(text);
        }
        if (entry.getSummary() != null && (text = EntryContributor.replaceText(entry.getSummary().getContent(), tokens)) != null) {
            entry.getSummary().setContent(text);
        }
        if ((links = entry.getLinkList()) != null) {
            for (LinkType link : links) {
                text = EntryContributor.replaceText(link.getTitle(), tokens);
                if (text != null) {
                    link.setTitle(text);
                }
                if ((text = link.getHref()) == null) continue;
                link.setHref(new URLTemplate(text).generateURL(tokens, params));
            }
        }
    }

    private static String replaceText(String text, Map<String, Object> tokens) {
        Object result;
        Matcher matcher;
        if (text != null && (matcher = pairPattern.matcher(text)).matches() && (result = tokens.get(matcher.group(1))) != null) {
            return result.toString();
        }
        return null;
    }

    private static <T> int searchInsertIndex(List<T> list, T value, Comparator<T> comparator) {
        int start = 0;
        int end = list.size() - 1;
        while (start <= end) {
            int mid = start + end >> 1;
            int result = comparator.compare(list.get(mid), value);
            if (result < 0) {
                start = mid + 1;
                continue;
            }
            if (result > 0) {
                end = mid - 1;
                continue;
            }
            return mid;
        }
        return start;
    }
}

