/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.bux.proxy;

import com.ibm.cognos.bux.config.BiBusConfiguration;
import com.ibm.cognos.bux.config.BiBusConfigurationManager;
import com.ibm.cognos.bux.http.RequestCookie;
import com.ibm.cognos.bux.http.RequestInformation;
import com.ibm.cognos.bux.http.ResponseInformation;
import com.ibm.cognos.bux.http.ResponsePayload;
import com.ibm.cognos.bux.http.URLInformation;
import com.ibm.cognos.bux.logging.BUXLoggerFactory;
import com.ibm.cognos.bux.logging.BUXTraceLogger;
import com.ibm.cognos.bux.logging.BUXZipiTraceLogger;
import com.ibm.cognos.bux.proxy.Activator;
import com.ibm.cognos.bux.proxy.Messages;
import com.ibm.cognos.bux.proxy.parser.ProxyConfigParser;
import com.ibm.cognos.bux.utils.EncodingUtils;
import com.ibm.cognos.bux.utils.http.ErrorResponse;
import com.ibm.cognos.bux.utils.http.HttpHelper;
import com.ibm.cognos.bux.utils.http.PooledHttpClientFactory;
import com.ibm.cognos.bux.utils.io.SharedByteArrayResponsePayload;
import com.ibm.cognos.bux.utils.io.StreamUtils;
import com.ibm.cognos.bux.utils.xml.dom.DomUtils;
import com.ibm.ws.ajaxproxy.proxy.Policy;
import com.ibm.ws.ajaxproxy.proxy.RequestBean;
import com.ibm.ws.ajaxproxy.util.EasySSLProtocolSocketFactory;
import com.ibm.ws.ajaxproxy.util.URIMatcher;
import com.ibm.ws.ajaxproxy.util.URLHelper;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.text.MessageFormat;
import java.util.Collection;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.xml.transform.TransformerException;
import org.apache.commons.httpclient.Credentials;
import org.apache.commons.httpclient.Header;
import org.apache.commons.httpclient.HostConfiguration;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpConnectionManager;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.HttpMethodBase;
import org.apache.commons.httpclient.MultiThreadedHttpConnectionManager;
import org.apache.commons.httpclient.UsernamePasswordCredentials;
import org.apache.commons.httpclient.auth.AuthScope;
import org.apache.commons.httpclient.methods.DeleteMethod;
import org.apache.commons.httpclient.methods.EntityEnclosingMethod;
import org.apache.commons.httpclient.methods.GetMethod;
import org.apache.commons.httpclient.methods.InputStreamRequestEntity;
import org.apache.commons.httpclient.methods.PostMethod;
import org.apache.commons.httpclient.methods.PutMethod;
import org.apache.commons.httpclient.methods.RequestEntity;
import org.apache.commons.httpclient.params.HttpClientParams;
import org.apache.commons.httpclient.params.HttpConnectionManagerParams;
import org.apache.commons.httpclient.protocol.Protocol;
import org.apache.commons.httpclient.protocol.ProtocolSocketFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ProxyHandler {
    private static final String CONTENT_LENGTH = "Content-Length";
    private static final String CONTENT_TYPE_APPLICATION_X_WWW_FORM_URLENCODED = "application/x-www-form-urlencoded";
    private static final String CONFIG_PATH = "/data/proxy-config.xml";
    private static final String PROXY_PORT = "8888";
    private static final String ANY = "ANY";
    private static final String HDR_COOKIE = "Cookie";
    private static final String HDR_CONTENT_TYPE = "Content-Type";
    private static final String HDR_SET_COOKIE = "Set-Cookie";
    private static final String HDR_TRANSFER_ENCODING = "Transfer-Encoding";
    private final ReentrantReadWriteLock lock = new ReentrantReadWriteLock();
    private final URIMatcher mappingMatcher = new URIMatcher(false);
    private final URIMatcher policyMatcher = new URIMatcher(false);
    private final Hashtable<String, String> metaParams = new Hashtable();
    private HttpClient httpClient;
    private Element proxyConfig;
    private final Policy safeDomainPolicy;
    private static BUXTraceLogger traceLogger;
    private static final Collection<String> GET_REQUEST_EXCLUDE_HEADERS_SET;
    private static BUXZipiTraceLogger zipiTraceLogger;
    private final PooledHttpClientFactory httpClientFactory = new PooledHttpClientFactory(){

        protected void initializeParams(HttpClient httpclnt) {
            ProxyHandler.this.setupHttpClient(httpclnt);
            HttpConnectionManager connectionManager = httpclnt.getHttpConnectionManager();
            if (connectionManager == null) {
                connectionManager = new MultiThreadedHttpConnectionManager();
                ProxyHandler.this.setupConnectionManager(connectionManager);
                httpclnt.setHttpConnectionManager(connectionManager);
            } else {
                ProxyHandler.this.setupConnectionManager(connectionManager);
            }
        }
    };

    static {
        GET_REQUEST_EXCLUDE_HEADERS_SET = new HashSet<String>(2);
        GET_REQUEST_EXCLUDE_HEADERS_SET.add("transfer-encoding");
        GET_REQUEST_EXCLUDE_HEADERS_SET.add("content-length");
        traceLogger = BUXLoggerFactory.getLogger((String)ProxyHandler.class.getName());
        zipiTraceLogger = BUXLoggerFactory.getZipiLogger();
    }

    public ProxyHandler() {
        Policy policy = new Policy();
        policy.getActions().add("GET");
        policy.getActions().add("POST");
        policy.getCookies().add("");
        this.safeDomainPolicy = policy;
    }

    public void loadDefaultProxyRules() {
        block13: {
            InputStream is = this.openConfigurationStream();
            if (is != null) {
                try {
                    try {
                        this.lock.writeLock().lock();
                        Document doc = DomUtils.parseDocument((InputStream)is);
                        if (doc != null) {
                            this.proxyConfig = doc.getDocumentElement();
                            this.updateProxyRules();
                        }
                    }
                    catch (Exception e) {
                        traceLogger.error(ProxyHandler.class.getName(), e.getLocalizedMessage(), (Throwable)e, null);
                        this.lock.writeLock().unlock();
                        try {
                            is.close();
                        }
                        catch (IOException iOException) {}
                        break block13;
                    }
                }
                catch (Throwable throwable) {
                    this.lock.writeLock().unlock();
                    try {
                        is.close();
                    }
                    catch (IOException iOException) {}
                    throw throwable;
                }
                this.lock.writeLock().unlock();
                try {
                    is.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    public ResponseInformation performRequest(RequestInformation request, String pathInfo) {
        ErrorResponse response;
        block28: {
            GetMethod method = null;
            response = null;
            try {
                this.lock.readLock().lock();
                String targetPath = (String)this.mappingMatcher.match(pathInfo);
                if (targetPath == null) {
                    response = new ResponseInformation(403, Messages.PROXY_UI_MAPPING_NOT_CONFIGURED);
                    break block28;
                }
                String normalizedURL = this.constructURL(targetPath, EncodingUtils.urlPathEncode((String)pathInfo, (String)"UTF8"), null);
                Policy policy = (Policy)this.policyMatcher.match(URLHelper.URLAsPath(normalizedURL));
                if (policy == null && this.isSafeDomainUrl(normalizedURL)) {
                    policy = this.safeDomainPolicy;
                }
                if (policy == null) {
                    response = new ResponseInformation(403, MessageFormat.format(Messages.PROXY_UI_URL_NOT_ALLOWED, pathInfo));
                    break block28;
                }
                String orgURL = normalizedURL;
                HttpClient client = this.getHttpClient(normalizedURL);
                if (normalizedURL.startsWith("https")) {
                    normalizedURL = HttpHelper.getURLFilePath((String)normalizedURL);
                }
                client.getState().clearCookies();
                switch (request.getType()) {
                    case 0: {
                        method = new GetMethod(normalizedURL);
                        break;
                    }
                    case 1: {
                        method = new PostMethod(normalizedURL);
                        break;
                    }
                    case 2: {
                        method = new PutMethod(normalizedURL);
                        break;
                    }
                    case 3: {
                        method = new DeleteMethod(normalizedURL);
                        break;
                    }
                    default: {
                        ResponseInformation responseInformation = new ResponseInformation(405, Messages.PROXY_UI_METHOD_NOT_ALLOWED);
                        return responseInformation;
                    }
                }
                try {
                    String qs = request.getQueryString();
                    if (method instanceof EntityEnclosingMethod) {
                        EntityEnclosingMethod entityMethod = (EntityEnclosingMethod)method;
                        InputStreamRequestEntity isr = null;
                        if (this.shouldRecreateEntityBody(request)) {
                            byte[] temp = qs.getBytes("UTF8");
                            this.addContentLengthHeader(request, temp.length);
                            isr = new InputStreamRequestEntity((InputStream)new ByteArrayInputStream(temp));
                        } else {
                            isr = new InputStreamRequestEntity(request.getInputStream());
                            method.setQueryString(qs);
                        }
                        entityMethod.setRequestEntity((RequestEntity)isr);
                    } else {
                        method.setQueryString(qs);
                    }
                    this.addRequestHeaders(request, (HttpMethodBase)method, policy);
                    Object timer = zipiTraceLogger.handleHttpRequest((HttpMethodBase)method);
                    try {
                        int statusCode = client.executeMethod((HttpMethod)method);
                        if (traceLogger.isDebugEnabled() && normalizedURL != null) {
                            String msg = "URL: " + normalizedURL + " Status Code: " + statusCode;
                            traceLogger.debug(ProxyHandler.class.getName(), msg, null);
                        }
                        response = this.createResponse((HttpMethodBase)method, policy, statusCode, orgURL);
                    }
                    finally {
                        zipiTraceLogger.handleHttpResponse(timer, (HttpMethodBase)method);
                    }
                    if (response.getStatus() != 403) {
                        URLInformation urlInfo = request.getUrlInfo();
                        String proxiedCookiePath = String.valueOf(urlInfo.getRequestURL()) + urlInfo.getPathInfo();
                        this.addResponseHeaders((HttpMethodBase)method, policy, (ResponseInformation)response, proxiedCookiePath);
                        SharedByteArrayResponsePayload payload = new SharedByteArrayResponsePayload(4096);
                        StreamUtils.writeTo((InputStream)method.getResponseBodyAsStream(), (OutputStream)payload);
                        response.setOutput((ResponsePayload)payload);
                    }
                }
                catch (IOException e) {
                    traceLogger.error(ProxyHandler.class.getName(), e.getLocalizedMessage(), (Throwable)e, null);
                    response = new ErrorResponse(500, Messages.PROXY_UI_FAILED_TO_CREATE_PAYLOAD, (Exception)e);
                }
                catch (Exception e) {
                    traceLogger.error(ProxyHandler.class.getName(), e.getLocalizedMessage(), (Throwable)e, null);
                    response = new ErrorResponse(response == null ? 500 : response.getStatus(), Messages.PROXY_UI_MAPPING_BAD_GATEWAY, e);
                }
            }
            finally {
                this.lock.readLock().unlock();
                if (method != null) {
                    method.releaseConnection();
                }
            }
        }
        return response;
    }

    private void addContentLengthHeader(RequestInformation request, int length) {
        Map headers = request.getHeaders();
        if (headers.get(CONTENT_LENGTH) != null) {
            headers.remove(CONTENT_LENGTH);
        }
        headers.put(CONTENT_LENGTH, Integer.toString(length));
    }

    private boolean shouldRecreateEntityBody(RequestInformation request) {
        return request.getContentType().startsWith(CONTENT_TYPE_APPLICATION_X_WWW_FORM_URLENCODED) && request.getInputStream() == null;
    }

    public void addProxyRules(Node proxyRules) {
        try {
            try {
                this.lock.writeLock().lock();
                ProxyConfigParser parser = new ProxyConfigParser(this.mappingMatcher, this.policyMatcher, this.metaParams);
                parser.addProxyRules(proxyRules, false);
                this.updateProxyRules();
            }
            catch (TransformerException e) {
                traceLogger.error(ProxyHandler.class.getName(), e.getLocalizedMessage(), (Throwable)e, null);
                this.lock.writeLock().unlock();
            }
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    public void modifyProxyRules(Node proxyRules) {
        try {
            try {
                this.lock.writeLock().lock();
                ProxyConfigParser parser = new ProxyConfigParser(this.mappingMatcher, this.policyMatcher, this.metaParams);
                parser.addProxyRules(proxyRules, false);
                this.updateProxyRules();
            }
            catch (TransformerException e) {
                traceLogger.error(ProxyHandler.class.getName(), e.getLocalizedMessage(), (Throwable)e, null);
                this.lock.writeLock().unlock();
            }
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    public void removeProxyRules(Node proxyRules) {
        try {
            try {
                this.lock.writeLock().lock();
                ProxyConfigParser parser = new ProxyConfigParser(this.mappingMatcher, this.policyMatcher, this.metaParams);
                parser.removeProxyRules(proxyRules);
                this.updateProxyRules();
            }
            catch (TransformerException e) {
                traceLogger.error(ProxyHandler.class.getName(), e.getLocalizedMessage(), (Throwable)e, null);
                this.lock.writeLock().unlock();
            }
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    protected URIMatcher getMappingMatcher() {
        return this.mappingMatcher;
    }

    protected Hashtable<String, String> getMetaParams() {
        return this.metaParams;
    }

    protected URIMatcher getPolicyMatcher() {
        return this.policyMatcher;
    }

    protected void setupConnectionManager(HttpConnectionManager connectionManager) {
        HttpConnectionManagerParams params = connectionManager.getParams();
        int maxConnPerHost = this.readIntValue("maxconnectionsperhost", params.getMaxConnectionsPerHost(HostConfiguration.ANY_HOST_CONFIGURATION), Messages.PROXY_UI_MAX_CONNS_PERHOST_EXC);
        int maxTotalConn = this.readIntValue("maxtotalconnections", params.getMaxTotalConnections(), Messages.PROXY_UI_MAX_TOTAL_CONNS_EXC);
        int connTimeout = this.readIntValue("connection-timeout", params.getConnectionTimeout(), Messages.PROXY_UI_CONN_TIMEOUT_EXC);
        int soTimeout = this.readIntValue("socket-timeout", params.getSoTimeout(), Messages.PROXY_UI_SO_TIMEOUT_EXC);
        params.setMaxConnectionsPerHost(HostConfiguration.ANY_HOST_CONFIGURATION, maxConnPerHost);
        params.setMaxTotalConnections(maxTotalConn);
        params.setConnectionTimeout(connTimeout);
        params.setSoTimeout(soTimeout);
    }

    protected void updateHttpClient() {
        HttpConnectionManager connectionManager;
        if (this.httpClient != null && (connectionManager = this.httpClient.getHttpConnectionManager()) instanceof MultiThreadedHttpConnectionManager) {
            ((MultiThreadedHttpConnectionManager)connectionManager).shutdown();
        }
        this.checkUnsignedSSLCertificate();
        connectionManager = new MultiThreadedHttpConnectionManager();
        this.setupConnectionManager(connectionManager);
        this.httpClient = new HttpClient(connectionManager);
        this.setupHttpClient(this.httpClient);
        this.httpClientFactory.reconfigureHttpClients();
    }

    protected void setupHttpClient(HttpClient httpClient) {
        HttpClientParams clientParams = httpClient.getParams();
        boolean allowRedirects = this.readBooleanValue("circular_redirects", clientParams.getBooleanParameter("http.protocol.allow-circular-redirects", false));
        int maxRedirects = this.readIntValue("max_circular_redirects", clientParams.getIntParameter("http.protocol.max-redirects", 100), Messages.PROXY_UI_MAX_REDIRECT_EXEC);
        clientParams.setBooleanParameter("http.protocol.allow-circular-redirects", allowRedirects);
        clientParams.setIntParameter("http.protocol.max-redirects", maxRedirects);
        this.setupProxy(httpClient);
    }

    private void addHeader(HttpMethodBase method, String headerName, String headerValue) {
        if (!headerName.equalsIgnoreCase(HDR_COOKIE)) {
            method.addRequestHeader(headerName, headerValue);
        }
    }

    private void addRequestCookies(HttpMethodBase method, Policy policy, String cookieString) {
        String filteredCookieString;
        if (policy.getCookies().size() == 0) {
            method.getParams().setCookiePolicy("ignoreCookies");
        }
        if (cookieString != null && (filteredCookieString = policy.getFilteredCookieString(cookieString)).length() != 0) {
            method.addRequestHeader(HDR_COOKIE, filteredCookieString);
        }
    }

    private void addRequestHeaders(RequestInformation request, HttpMethodBase method, Policy policy) {
        Map headers = request.getHeaders();
        List<Pattern> validHeaders = policy.getHeaders();
        if (validHeaders != null && validHeaders.size() > 0) {
            block0: for (String headerName : headers.keySet()) {
                for (Pattern pattern : validHeaders) {
                    Matcher m = pattern.matcher(headerName);
                    if (!m.matches()) continue;
                    this.addHeader(method, headerName, (String)headers.get(headerName));
                    continue block0;
                }
            }
        } else {
            int requestType = request.getType();
            for (String headerName : headers.keySet()) {
                if (this.isExcludedHeader(headerName, requestType)) continue;
                this.addHeader(method, headerName, (String)headers.get(headerName));
            }
        }
        String cookies = (String)headers.get(HDR_COOKIE);
        if (cookies != null) {
            this.addRequestCookies(method, policy, cookies);
        }
    }

    private boolean isExcludedHeader(String headerName, int requestType) {
        return requestType == 0 && GET_REQUEST_EXCLUDE_HEADERS_SET.contains(headerName.toLowerCase());
    }

    private void addResponseHeaders(HttpMethodBase method, Policy policy, ResponseInformation response, String proxiedCookiePath) {
        Header[] headers = method.getResponseHeaders();
        StringBuilder debugMsg = null;
        if (traceLogger.isDebugEnabled()) {
            debugMsg = new StringBuilder(256);
        }
        Header[] headerArray = headers;
        int n = headers.length;
        int n2 = 0;
        while (n2 < n) {
            Header header = headerArray[n2];
            String headerName = header.getName();
            String headerValue = header.getValue();
            if (traceLogger.isDebugEnabled() && debugMsg != null && headerName != null && headerValue != null) {
                debugMsg.append("Reading response header, Header: ").append(headerName).append(" Value: ").append(headerValue).append("\n");
            }
            if (!HDR_CONTENT_TYPE.equals(headerName) && !HDR_TRANSFER_ENCODING.equals(headerName)) {
                if (HDR_SET_COOKIE.equals(headerName)) {
                    RequestCookie cookie;
                    String[] cookieParts = headerValue.split(";");
                    if (policy.isCookieAllowed(cookieParts) && (cookie = RequestCookie.createOutboundCookie((String[])cookieParts, (String)proxiedCookiePath)) != null) {
                        response.addCookie(cookie);
                    }
                } else {
                    response.addHeader(headerName, headerValue);
                }
            }
            ++n2;
        }
        if (traceLogger.isDebugEnabled() && debugMsg != null && debugMsg.length() > 0) {
            traceLogger.debug(ProxyHandler.class.getName(), debugMsg.toString(), null);
        }
    }

    private void checkUnsignedSSLCertificate() {
        String unsigned_ssl_certificate_support = this.metaParams.get("unsigned_ssl_certificate_support");
        if (unsigned_ssl_certificate_support != null && unsigned_ssl_certificate_support.toLowerCase(Locale.ENGLISH).equals("true")) {
            Protocol.registerProtocol((String)"https", (Protocol)new Protocol("https", (ProtocolSocketFactory)new EasySSLProtocolSocketFactory(), 443));
            Object[] ssl_args = null;
            traceLogger.info(ProxyHandler.class.getName(), MessageFormat.format(Messages.PROXY_UI_SSL_UNSIGNED_SUPPORT, ssl_args), null);
        }
    }

    private String constructURL(String targetPath, String pathInfo, String queryString) throws MalformedURLException {
        RequestBean requestBean;
        if (targetPath.length() == 0) {
            requestBean = new RequestBean(pathInfo, queryString);
        } else {
            String fixedPath = this.fixupPathInfo(pathInfo);
            StringBuilder urlBuf = new StringBuilder(targetPath);
            if ('/' == urlBuf.charAt(urlBuf.length() - 1) && fixedPath.length() > 1 && '/' == fixedPath.charAt(0)) {
                urlBuf.append(fixedPath.substring(1));
            } else {
                urlBuf.append(fixedPath);
            }
            URL url = new URL(urlBuf.toString());
            requestBean = new RequestBean(url, url.getPath(), queryString);
        }
        return requestBean.toString();
    }

    private ResponseInformation createResponse(HttpMethodBase method, Policy policy, int statusCode, String normalizedURL) {
        String contentType;
        Header header;
        ResponseInformation response = statusCode == 401 && !policy.isBasicAuthSupport() ? new ResponseInformation(403, MessageFormat.format(Messages.PROXY_UI_URL_NOT_ALLOWED, normalizedURL)) : ((header = method.getResponseHeader(HDR_CONTENT_TYPE)) != null ? (policy.isValidMimeType(contentType = header.getValue()) ? new ResponseInformation(statusCode, "", contentType) : new ResponseInformation(403, Messages.PROXY_UI_MIME_TYPE_NOT_ALLOWED)) : new ResponseInformation(statusCode, "", null));
        return response;
    }

    private String fixupPathInfo(String pathInfo) {
        int last = 0;
        while (last < pathInfo.length()) {
            String testPath;
            int pos = pathInfo.indexOf(47, last + 1);
            if (-1 == pos) {
                pos = pathInfo.length();
            }
            if (!this.mappingMatcher.exists(testPath = pathInfo.substring(0, pos))) break;
            last = pos;
        }
        return pathInfo.substring(last);
    }

    private HttpClient getHttpClient(String url) throws MalformedURLException {
        HttpClient client = this.httpClient;
        if (url.startsWith("https://")) {
            if (traceLogger.isDebugEnabled()) {
                traceLogger.debug(ProxyHandler.class.getName(), "Using CAM Http Client", null);
            }
            client = this.httpClientFactory.createHttpClient(new URL(url));
        }
        return client;
    }

    private boolean isSafeDomainUrl(String url) {
        BiBusConfiguration config = BiBusConfigurationManager.getInstance();
        if (config != null) {
            return !config.isCAFEnabled() || config.isSafeDomainUrl(url);
        }
        return false;
    }

    private InputStream openConfigurationStream() {
        InputStream is = null;
        try {
            URL entry;
            File configFilePath;
            String path;
            BiBusConfiguration configMgr = BiBusConfigurationManager.getInstance();
            if (configMgr != null && (path = configMgr.getPlatformBasePath()) != null && path.length() > 0 && (configFilePath = new File(path, "configuration/icd/proxy/proxy-config.xml")).exists() && configFilePath.isFile()) {
                is = configFilePath.toURI().toURL().openStream();
            }
            if (is == null && (entry = Activator.getInstance().getBundleContext().getBundle().getEntry(CONFIG_PATH)) != null) {
                is = entry.openStream();
            }
        }
        catch (IOException e) {
            traceLogger.error(ProxyHandler.class.getName(), e.getLocalizedMessage(), (Throwable)e, null);
        }
        return is;
    }

    private boolean readBooleanValue(String key, boolean defaultValue) {
        boolean result = defaultValue;
        String value = this.metaParams.get(key);
        if (value != null) {
            result = Boolean.valueOf(value);
        }
        return result;
    }

    private int readIntValue(String key, int defaultValue, String errmsg) {
        int result = defaultValue;
        String value = this.metaParams.get(key);
        if (value != null) {
            try {
                result = Integer.parseInt(value.trim());
            }
            catch (NumberFormatException numberFormatException) {
                traceLogger.error(ProxyHandler.class.getName(), MessageFormat.format(errmsg, defaultValue), null);
            }
        }
        return result;
    }

    private void setupProxy(HttpClient httpClient) {
        block8: {
            String passthru_proxyhost = this.metaParams.get("passthru_host");
            String passthru_proxyport = this.metaParams.get("passthru_port");
            String passthru_realm = this.metaParams.get("passthru_realm");
            String passthru_username = this.metaParams.get("passthru_username");
            String passthru_password = this.metaParams.get("passthru_password");
            if (passthru_proxyhost != null || passthru_username != null || passthru_password != null || passthru_proxyport != null || passthru_realm != null) {
                if (passthru_proxyhost != null) {
                    passthru_proxyport = passthru_proxyport != null ? passthru_proxyport : PROXY_PORT;
                    passthru_realm = passthru_realm != null ? passthru_realm : ANY;
                    UsernamePasswordCredentials credential = null;
                    if (passthru_username != null) {
                        String string = passthru_password = passthru_password != null ? passthru_password : "";
                        if (passthru_realm.toUpperCase(Locale.ENGLISH).equals(ANY)) {
                            passthru_realm = AuthScope.ANY_REALM;
                        }
                        credential = new UsernamePasswordCredentials(passthru_username, passthru_password);
                    }
                    try {
                        if (credential != null) {
                            httpClient.getHostConfiguration().setProxy(passthru_proxyhost, Integer.valueOf(passthru_proxyport).intValue());
                            httpClient.getState().setProxyCredentials(new AuthScope(passthru_proxyhost, Integer.valueOf(passthru_proxyport).intValue(), passthru_realm), (Credentials)credential);
                            break block8;
                        }
                        httpClient.getHostConfiguration().setProxy(passthru_proxyhost, Integer.valueOf(passthru_proxyport).intValue());
                    }
                    catch (NumberFormatException numberFormatException) {
                        traceLogger.error(ProxyHandler.class.getName(), Messages.PROXY_UI_PASSTHRU_PROXY_NONNUMERICPORT, null);
                    }
                } else {
                    traceLogger.error(ProxyHandler.class.getName(), Messages.PROXY_UI_PASSTHRU_PROXY_MISSINGPARAMETERS, null);
                }
            }
        }
    }

    private void updateProxyRules() throws TransformerException {
        ProxyConfigParser parser = new ProxyConfigParser(this.mappingMatcher, this.policyMatcher, this.metaParams);
        parser.addProxyRules(this.proxyConfig, true);
        this.updateHttpClient();
    }
}

