/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.bux.proxy;

import com.ibm.cognos.bux.BUXControllerBaseImpl;
import com.ibm.cognos.bux.http.RequestInformation;
import com.ibm.cognos.bux.http.ResponseInformation;
import com.ibm.cognos.bux.http.ResponsePayload;
import com.ibm.cognos.bux.http.URLInformation;
import com.ibm.cognos.bux.proxy.ProxyHandler;
import com.ibm.cognos.bux.proxy.io.ProxyConfigPayload;
import java.util.Map;
import javax.xml.stream.XMLStreamException;
import org.w3c.dom.Node;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ServiceController
extends BUXControllerBaseImpl {
    public static final String LOCAL_SERVICE_NAME = "BUX.Proxy";
    public static final String LOCAL_SERVICE_PATH = "/proxy";
    private final ProxyHandler proxy = new ProxyHandler();

    public void init(Map<String, Object> config) {
        super.init(config);
        this.proxy.loadDefaultProxyRules();
    }

    public String getServiceName() {
        return LOCAL_SERVICE_NAME;
    }

    public String getUrlPath() {
        return LOCAL_SERVICE_PATH;
    }

    public ResponseInformation handleRequest(RequestInformation request) {
        URLInformation urlInfo = request.getUrlInfo();
        String pathInfo = urlInfo.getPathInfo().substring(LOCAL_SERVICE_PATH.length());
        if ("/info".equals(pathInfo)) {
            return this.writeProxyRules();
        }
        return this.proxy.performRequest(request, pathInfo);
    }

    public void addProxyRules(Node proxyRules) {
        this.proxy.addProxyRules(proxyRules);
    }

    public void modifyProxyRules(Node proxyRules) {
        this.proxy.modifyProxyRules(proxyRules);
    }

    public void removeProxyRules(Node proxyRules) {
        this.proxy.removeProxyRules(proxyRules);
    }

    private ResponseInformation writeProxyRules() {
        try {
            ProxyConfigPayload payload = new ProxyConfigPayload();
            payload.writeStartDocument();
            payload.writeMappings(this.proxy.getMappingMatcher());
            payload.writePolicies(this.proxy.getPolicyMatcher());
            payload.writeParams(this.proxy.getMetaParams());
            payload.writeEndDocument();
            return new ResponseInformation(200, (ResponsePayload)payload, "text/xml");
        }
        catch (XMLStreamException e) {
            return new ResponseInformation(500, e.getLocalizedMessage());
        }
    }
}

