/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.bux.proxy.parser;

import com.ibm.cognos.bux.logging.BUXLoggerFactory;
import com.ibm.cognos.bux.logging.BUXTraceLogger;
import com.ibm.cognos.bux.proxy.Messages;
import com.ibm.cognos.bux.proxy.parser.AddMappingHandler;
import com.ibm.cognos.bux.proxy.parser.AddPolicyHandler;
import com.ibm.cognos.bux.proxy.parser.RemoveMappingHandler;
import com.ibm.cognos.bux.proxy.parser.RemovePolicyHandler;
import com.ibm.ws.ajaxproxy.util.URIMatcher;
import java.util.Hashtable;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.TransformerFactoryConfigurationError;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.sax.SAXResult;
import org.w3c.dom.Node;
import org.xml.sax.helpers.XMLFilterImpl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ProxyConfigParser {
    private final URIMatcher mappingMatcher;
    private final URIMatcher policyMatcher;
    private final Hashtable<String, String> metaParams;
    private static BUXTraceLogger traceLogger = BUXLoggerFactory.getLogger((String)ProxyConfigParser.class.getName());

    public ProxyConfigParser(URIMatcher mappingMatcher, URIMatcher policyMatcher, Hashtable<String, String> metaParams) {
        this.mappingMatcher = mappingMatcher;
        this.policyMatcher = policyMatcher;
        this.metaParams = metaParams;
    }

    public void addProxyRules(Node node, boolean override) throws TransformerException {
        this.transformProxyRules(node, new AddMappingHandler(this.mappingMatcher, override), new AddPolicyHandler(this.policyMatcher, this.metaParams, override));
    }

    public void removeProxyRules(Node node) throws TransformerException {
        this.transformProxyRules(node, new RemoveMappingHandler(this.mappingMatcher), new RemovePolicyHandler(this.policyMatcher, this.metaParams));
    }

    private void transformProxyRules(Node node, XMLFilterImpl mappingHandler, XMLFilterImpl policyHandler) throws TransformerConfigurationException, TransformerFactoryConfigurationError, TransformerException {
        if (node == null) {
            traceLogger.warn(ProxyConfigParser.class.getName(), Messages.PROXY_UI_MISSING_PROXYCONFIG, null);
        } else {
            Transformer t = TransformerFactory.newInstance().newTransformer();
            mappingHandler.setContentHandler(policyHandler);
            t.transform(new DOMSource(node), new SAXResult(mappingHandler));
        }
    }
}

