/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.ajaxproxy.parser;

import com.ibm.ws.ajaxproxy.parser.Constants;
import com.ibm.ws.ajaxproxy.parser.ProxyConfigOptions;
import com.ibm.ws.ajaxproxy.proxy.Policy;
import com.ibm.ws.ajaxproxy.util.URIMatcher;
import com.ibm.ws.ajaxproxy.util.URINormalizer;
import com.ibm.ws.ajaxproxy.util.URLHelper;
import java.util.Hashtable;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.XMLFilterImpl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PolicyHandler
extends XMLFilterImpl
implements Constants {
    private final InternalPolicyHandler policyHandler = new InternalPolicyHandler();
    private ContentHandler defaultHandler;
    private final URIMatcher uriMatcher;
    private final Hashtable<String, String> optional_params_;

    public PolicyHandler(URIMatcher aURIMatcher, Hashtable<String, String> optional_params) {
        this.uriMatcher = aURIMatcher;
        this.optional_params_ = optional_params;
    }

    @Override
    public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
        if ("policy".equals(localName)) {
            Policy policy;
            this.defaultHandler = this.getContentHandler();
            try {
                String basicAuthSupport;
                String url = attributes.getValue("url");
                String acf = attributes.getValue("acf");
                String normalizedURL = URINormalizer.normalize(url);
                policy = new Policy(url);
                if (acf != null) {
                    policy.setAcf(acf);
                }
                if ((basicAuthSupport = attributes.getValue("basic-auth-support")) != null && basicAuthSupport.equalsIgnoreCase("true")) {
                    policy.setBasicAuthSupport(true);
                }
                this.uriMatcher.put(URLHelper.URLAsPath(normalizedURL), policy);
            }
            catch (Exception e) {
                throw new SAXException(e);
            }
            this.policyHandler.reset(policy);
            this.setContentHandler(this.policyHandler);
            this.policyHandler.startDocument();
        }
        if ("meta-data".equals(localName)) {
            this.defaultHandler = this.getContentHandler();
            this.setContentHandler(new ProxyConfigOptions(this.optional_params_));
            this.policyHandler.setContentHandler(this.defaultHandler);
            this.policyHandler.startDocument();
        }
        super.startElement(uri, localName, qName, attributes);
    }

    @Override
    public void endElement(String uri, String localName, String qName) throws SAXException {
        super.endElement(uri, localName, qName);
        if ("policy".equals(localName)) {
            this.policyHandler.endDocument();
            this.policyHandler.dispose();
        }
    }

    protected class InternalPolicyHandler
    extends XMLFilterImpl {
        private Policy policy;
        private StringBuffer buffer;

        protected InternalPolicyHandler() {
        }

        public void startDocument() throws SAXException {
            assert (this.policy != null);
        }

        public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
            this.buffer = new StringBuffer();
            super.startElement(uri, localName, qName, attributes);
        }

        public void characters(char[] ch, int start, int length) throws SAXException {
            if (this.buffer != null) {
                this.buffer.append(ch, start, length);
            }
            super.characters(ch, start, length);
        }

        public void endElement(String uri, String localName, String qName) throws SAXException {
            String value;
            String string = value = this.buffer != null ? this.buffer.toString() : "";
            if ("method".equals(localName)) {
                this.policy.getActions().add(value);
            } else if ("cookie".equals(localName)) {
                this.policy.getCookies().add(String.valueOf(value) + "=");
            } else if ("header".equals(localName)) {
                this.policy.addHeader(value);
            } else if ("mime-type".equals(localName)) {
                this.policy.addMimeType(value);
            } else if ("user".equals(localName)) {
                this.policy.getUsers().add(value);
            }
            this.buffer = null;
            super.endElement(uri, localName, qName);
        }

        public void endDocument() throws SAXException {
        }

        public void reset(Policy aPolicy) {
            this.policy = aPolicy;
        }

        public void dispose() {
            this.policy = null;
        }
    }
}

