/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.ajaxproxy.proxy;

import java.util.ArrayList;
import java.util.List;
import java.util.regex.Pattern;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Policy {
    public static final String PAF_POL_ACF_NONE = "none";
    public static final String PAF_POL_ACF_INBOUND = "inbound";
    public static final String PAF_POL_ACF_OUTBOUND = "outbound";
    public static final String PAF_POL_ACF_BOTH = "both";
    private String url;
    private String acf = "none";
    private final List<String> actions;
    private final List<String> cookies;
    private final List<Pattern> headers;
    private final List<Pattern> mimeTypes;
    private final List<String> users;
    private boolean basicAuthSupport;

    public Policy() {
        this("");
    }

    public Policy(String url) {
        this.url = url;
        this.actions = new ArrayList<String>(1);
        this.cookies = new ArrayList<String>(10);
        this.headers = new ArrayList<Pattern>(1);
        this.mimeTypes = new ArrayList<Pattern>(1);
        this.users = new ArrayList<String>(10);
        this.basicAuthSupport = false;
    }

    public String getAcf() {
        return this.acf;
    }

    public void setAcf(String acf) {
        this.acf = acf;
    }

    public List<String> getActions() {
        return this.actions;
    }

    public List<String> getCookies() {
        return this.cookies;
    }

    public List<Pattern> getHeaders() {
        return this.headers;
    }

    public List<Pattern> getMimeTypes() {
        return this.mimeTypes;
    }

    public void addHeader(String patternString) {
        Pattern headerPattern = Pattern.compile(patternString, 2);
        this.headers.add(headerPattern);
    }

    public void addMimeType(String patternString) {
        Pattern mimeTypePattern = Pattern.compile(patternString, 2);
        this.mimeTypes.add(mimeTypePattern);
    }

    public String getURL() {
        return this.url;
    }

    public void setURL(String url) {
        this.url = url;
    }

    public List<String> getUsers() {
        return this.users;
    }

    public boolean isMethodAllowed(String method) {
        return this.actions.contains(method);
    }

    public boolean isValidMimeType(String mimeType) {
        String theMimeType = mimeType;
        if (theMimeType.indexOf(";") != -1) {
            theMimeType = theMimeType.trim().substring(0, theMimeType.indexOf(";"));
        }
        if (this.mimeTypes.size() == 0) {
            return true;
        }
        for (Pattern mimeTypePattern : this.mimeTypes) {
            if (!mimeTypePattern.matcher(theMimeType).matches()) continue;
            return true;
        }
        return false;
    }

    public String getFilteredCookieString(String rawCookieString) {
        if (rawCookieString == null || rawCookieString.length() == 0) {
            return "";
        }
        if (this.cookies.size() == 0) {
            return "";
        }
        StringBuffer cookieBuffer = new StringBuffer();
        String[] cookieParts = rawCookieString.split(";");
        int i = 0;
        while (i < cookieParts.length) {
            String cookie = cookieParts[i].trim();
            int j = 0;
            while (j < this.cookies.size()) {
                if (cookie.startsWith(this.cookies.get(j))) {
                    if (cookieBuffer.length() != 0) {
                        cookieBuffer.append(";");
                    }
                    cookieBuffer.append(cookie);
                    break;
                }
                ++j;
            }
            ++i;
        }
        return cookieBuffer.toString();
    }

    public boolean isCookieAllowed(String[] rawCookieStringParts) {
        if (rawCookieStringParts == null || rawCookieStringParts.length == 0) {
            return false;
        }
        if (this.cookies.size() == 0) {
            return false;
        }
        boolean matchFound = false;
        int i = 0;
        while (i < rawCookieStringParts.length) {
            String cookie = rawCookieStringParts[i].trim();
            int j = 0;
            while (j < this.cookies.size()) {
                if (cookie.startsWith(this.cookies.get(j))) {
                    matchFound = true;
                    break;
                }
                ++j;
            }
            if (matchFound) break;
            ++i;
        }
        return matchFound;
    }

    public boolean isBasicAuthSupport() {
        return this.basicAuthSupport;
    }

    public void setBasicAuthSupport(boolean basicAuthSupport) {
        this.basicAuthSupport = basicAuthSupport;
    }
}

