/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.ajaxproxy.util;

import com.ibm.ws.ajaxproxy.util.ClauseTable;
import com.ibm.ws.ajaxproxy.util.URIMatcher;
import java.util.ArrayList;
import java.util.List;

public class ClauseNode {
    int hashCode = -1;
    Object target = null;
    ClauseTable children;
    int length = -1;
    private static final int star = URIMatcher.computeHash("*");
    String cl;

    public ClauseNode(String clause, Object target, boolean scalable) {
        this.hashCode = URIMatcher.computeHash(clause) & Integer.MAX_VALUE;
        this.target = target;
        this.length = clause.length();
        this.cl = clause;
        this.children = new ClauseTable(scalable);
    }

    public boolean isStar() {
        return this.hashCode == star;
    }

    public ClauseNode add(ClauseNode node) throws Exception {
        Object targetNode = node.getTarget();
        ClauseNode n = null;
        n = (ClauseNode)this.children.get(node);
        if (n != null) {
            Object nTargetNode = n.getTarget();
            if (targetNode != null) {
                if (nTargetNode != null) {
                    throw new Exception("Mapping clash for " + targetNode + ": Target " + nTargetNode + " already exists at node " + this.cl);
                }
                n.setTarget(targetNode);
            }
            return n;
        }
        this.children.add(node);
        return (ClauseNode)this.children.get(node);
    }

    public synchronized void setTarget(Object target) {
        this.target = target;
    }

    public synchronized Object getTarget() {
        return this.target;
    }

    public String getClause() {
        return this.cl;
    }

    public ClauseTable getChildren() {
        return this.children;
    }

    public ClauseNode traverse(String clause) {
        return (ClauseNode)this.children.get(URIMatcher.computeHash(clause) & Integer.MAX_VALUE);
    }

    public ClauseNode traverse(int hash) {
        return (ClauseNode)this.children.get(hash & Integer.MAX_VALUE);
    }

    public synchronized Object getTarget(String clause) {
        Object theTarget = null;
        if (URIMatcher.computeHash(clause) == this.hashCode && clause.length() == this.length) {
            theTarget = this.target;
        }
        return theTarget;
    }

    public List targets() {
        ArrayList<Object> targets = new ArrayList<Object>();
        List l = this.children.getList();
        for (Object obj : l) {
            ClauseNode node = (ClauseNode)obj;
            targets.addAll(node.targets());
        }
        if (this.target != null) {
            targets.add(this.target);
        }
        return targets;
    }

    public int hashCode() {
        return this.hashCode;
    }

    public boolean remove(String mapping) {
        int index = mapping.substring(1).indexOf(47);
        if (index == -1) {
            String nodeName = mapping.substring(1);
            ClauseNode node = this.traverse(nodeName);
            if (node != null) {
                this.children.remove(node);
            }
        } else {
            boolean delete;
            String nodeName = mapping.substring(1, index + 1);
            ClauseNode node = this.traverse(nodeName);
            if (node != null && (delete = node.remove(mapping.substring(index + 1)))) {
                this.children.remove(node);
            }
        }
        return this.children.size() == 0;
    }
}

