/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.ajaxproxy.util;

import com.ibm.ws.ajaxproxy.util.ClauseNode;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class URIMatcher {
    private static final String SLASH_PREFIX = "/";
    private ClauseNode root;
    private final Map extensions = new HashMap();
    private final int star = URIMatcher.computeHash("*");
    private ClauseNode defaultNode;
    private final boolean scalable;
    private static int range = 91;

    public static int computeHash(String key) {
        int hash = 0;
        int i = 0;
        while (i < key.length()) {
            hash = hash * range + key.charAt(i);
            ++i;
        }
        return hash;
    }

    public URIMatcher() {
        this(false);
    }

    public URIMatcher(boolean scalable) {
        this.scalable = scalable;
        this.init();
    }

    public URIMatcher(boolean scalable, int r) {
        this.scalable = scalable;
        range = r;
        this.init();
    }

    private void init() {
        if (this.root == null) {
            this.root = new ClauseNode(SLASH_PREFIX, null, this.scalable);
        }
    }

    public void put(String uriInput, Object target) throws Exception {
        String uri = uriInput;
        if (uri.startsWith("*.")) {
            this.extensions.put(uri.substring(2), target);
            return;
        }
        if (!uri.startsWith(SLASH_PREFIX)) {
            uri = SLASH_PREFIX + uri;
        }
        StringBuffer clause = new StringBuffer();
        ClauseNode currentNode = this.root;
        int len = uri.length();
        int i = 1;
        while (i < len) {
            if (uri.charAt(i) == '/') {
                currentNode = currentNode.add(new ClauseNode(clause.toString(), null, this.scalable));
                clause.delete(0, clause.length());
            } else if (i == len - 1) {
                clause.append(uri.charAt(i));
                currentNode = currentNode.add(new ClauseNode(clause.toString(), target, this.scalable));
            } else {
                clause.append(uri.charAt(i));
            }
            ++i;
        }
        this.defaultNode = this.root.traverse(this.star);
    }

    public Iterator iterator() {
        List l = this.root.targets();
        l.addAll(this.extensions.values());
        return l.iterator();
    }

    public Object match(String uri) {
        ClauseNode currentNode = this.root;
        ClauseNode prevNode = this.root;
        ClauseNode starNode = null;
        ClauseNode temp = null;
        boolean exact = true;
        int len = uri.length();
        int hash = 0;
        int i = 1;
        while (i < len) {
            char c = uri.charAt(i);
            if (c == '/') {
                if ((currentNode = currentNode.traverse(hash)) == null) {
                    exact = false;
                    break;
                }
                temp = prevNode.traverse(this.star);
                if (temp != null) {
                    starNode = temp;
                }
                prevNode = currentNode;
                hash = 0;
            } else if (i == len - 1) {
                if ((currentNode = currentNode.traverse(hash = range * hash + c)) == null) {
                    exact = false;
                }
            } else {
                hash = range * hash + c;
            }
            ++i;
        }
        Object target = null;
        if (exact) {
            target = currentNode.getTarget();
            if (target != null) {
                return target;
            }
            temp = currentNode.traverse(this.star);
            if (temp != null && (target = temp.getTarget()) != null) {
                return target;
            }
        }
        if ((temp = prevNode.traverse(this.star)) != null) {
            starNode = temp;
        }
        if (starNode != null && starNode != this.defaultNode) {
            return starNode.getTarget();
        }
        int dot = uri.lastIndexOf(".");
        if (dot != -1 && (target = this.extensions.get(uri.substring(dot + 1))) != null) {
            return target;
        }
        if (starNode != null) {
            return starNode.getTarget();
        }
        return null;
    }

    public List matchAll(String uri) {
        Object tempTarget;
        Object tar;
        ClauseNode currentNode = this.root;
        ClauseNode prevNode = this.root;
        ClauseNode temp = null;
        ArrayList<Object> returnList = new ArrayList<Object>();
        int dot = uri.lastIndexOf(".");
        if (dot != -1 && (tar = this.extensions.get(uri.substring(dot + 1))) != null) {
            returnList.add(tar);
        }
        boolean exact = true;
        int len = uri.length();
        int hash = 0;
        int i = 1;
        while (i < len) {
            char c = uri.charAt(i);
            if (c == '/') {
                Object target;
                if ((currentNode = currentNode.traverse(hash)) == null) {
                    exact = false;
                    break;
                }
                temp = prevNode.traverse(this.star);
                if (temp != null && (target = temp.getTarget()) != null) {
                    returnList.add(target);
                }
                prevNode = currentNode;
                hash = 0;
            } else if (i == len - 1) {
                if ((currentNode = currentNode.traverse(hash = range * hash + c)) == null) {
                    exact = false;
                }
            } else {
                hash = range * hash + c;
            }
            ++i;
        }
        Object target = null;
        if (exact) {
            target = currentNode.getTarget();
            if (target != null) {
                returnList.add(target);
                return returnList;
            }
            temp = currentNode.traverse(this.star);
            if (temp != null && (target = temp.getTarget()) != null) {
                returnList.add(target);
                return returnList;
            }
        }
        if ((tempTarget = (temp = prevNode.traverse(this.star)).getTarget()) != null) {
            returnList.add(tempTarget);
        }
        return returnList;
    }

    public void remove(String path) {
        if (path.startsWith("*") && path.indexOf(46) != -1) {
            this.extensions.remove(path);
        }
        this.root.remove(path);
    }

    public Object replace(String uri, String newTarget) throws Exception {
        ClauseNode currentNode = this.root;
        boolean exact = true;
        int len = uri.length();
        int hash = 0;
        int i = 1;
        while (i < len) {
            char c = uri.charAt(i);
            if (c == '/') {
                if ((currentNode = currentNode.traverse(hash)) == null) {
                    exact = false;
                    break;
                }
                hash = 0;
            } else if (i == len - 1) {
                if ((currentNode = currentNode.traverse(hash = range * hash + c)) == null) {
                    exact = false;
                }
            } else {
                hash = range * hash + c;
            }
            ++i;
        }
        Object target = null;
        if (exact) {
            target = currentNode.getTarget();
            if (target != null) {
                currentNode.setTarget(newTarget);
                return target;
            }
            throw new Exception("No target to replace at given node");
        }
        int dot = uri.lastIndexOf(".");
        if (dot != -1 && (target = this.extensions.get(uri.substring(dot + 1))) != null) {
            this.extensions.put(uri.substring(dot + 1), newTarget);
            return target;
        }
        throw new Exception("No exact matching path found to replace");
    }

    public boolean exists(String uri) {
        ClauseNode currentNode = this.root;
        boolean exact = true;
        int len = uri.length();
        int hash = 0;
        int i = 1;
        while (i < len) {
            char c = uri.charAt(i);
            if (c == '/') {
                if ((currentNode = currentNode.traverse(hash)) == null) {
                    exact = false;
                    break;
                }
                hash = 0;
            } else if (i == len - 1) {
                if ((currentNode = currentNode.traverse(hash = range * hash + c)) == null) {
                    exact = false;
                }
            } else {
                hash = range * hash + c;
            }
            ++i;
        }
        if (exact) {
            return true;
        }
        return this.extensions.get(uri) != null;
    }

    public ClauseNode getRoot() {
        return this.root;
    }
}

