/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.ajaxproxy.util;

import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public abstract class URINormalizer {
    private static final Pattern collapse = Pattern.compile("([^/]+/\\.\\./|^\\.\\./|^/\\.\\./|/\\./|//|/\\.$|[^/]+/\\.\\.$)");
    private static final Map<String, String> defaultPorts = new HashMap<String, String>(10);
    private static final List<String> relativeSchemes = new ArrayList<String>(10);
    private static final String DEFAULT_ENCODING = "UTF-8";
    private static final String EMPTY_STRING = "";

    static {
        defaultPorts.put("http", "80");
        defaultPorts.put("https", "443");
        defaultPorts.put("ftp", "21");
        defaultPorts.put("nntp", "119");
        defaultPorts.put("snntp", "536");
        defaultPorts.put("telnet", "23");
        relativeSchemes.add("http");
        relativeSchemes.add("https");
        relativeSchemes.add("ftp");
        relativeSchemes.add("nntp");
        relativeSchemes.add("snntp");
    }

    public static String normalize(String uri) throws URISyntaxException {
        return URINormalizer.normalize(new URI(uri));
    }

    public static String normalize(URI uri) {
        StringBuffer normalizedURI = new StringBuffer();
        try {
            int i;
            String path;
            String[] paramArray;
            String scheme = uri.getScheme();
            if (scheme != null) {
                scheme = scheme.toLowerCase();
                normalizedURI.append(scheme).append(":");
            }
            if (uri.getAuthority() != null) {
                String host;
                normalizedURI.append("//");
                if (uri.getRawUserInfo() != null && (paramArray = uri.getRawUserInfo().split(":")).length > 0 && !EMPTY_STRING.equals(paramArray[0])) {
                    normalizedURI.append(URLEncoder.encode(URLDecoder.decode(paramArray[0], DEFAULT_ENCODING), DEFAULT_ENCODING));
                    if (paramArray.length == 2) {
                        normalizedURI.append(":").append(URLEncoder.encode(URLDecoder.decode(paramArray[1], DEFAULT_ENCODING), DEFAULT_ENCODING));
                    }
                    normalizedURI.append("@");
                }
                if ((host = uri.getHost()) == null && uri.getRawUserInfo() == null) {
                    int colon = uri.getRawAuthority().indexOf(":");
                    host = uri.getRawAuthority().substring(0, colon);
                }
                if (host != null) {
                    if (host.endsWith(".")) {
                        host = host.substring(0, host.length() - 1);
                    }
                    normalizedURI.append(host.toLowerCase());
                }
                if (!(uri.getPort() <= -1 || defaultPorts.containsKey(scheme) && uri.getPort() == Integer.valueOf(defaultPorts.get(scheme)).intValue())) {
                    normalizedURI.append(":").append(uri.getPort());
                }
            }
            if ((path = uri.getRawPath()) != null) {
                Matcher collapseMatcher;
                String lastPath = null;
                do {
                    lastPath = path;
                } while (!(path = (collapseMatcher = collapse.matcher(path)).replaceFirst("/")).equals(lastPath));
                if (path.indexOf("/") > -1) {
                    paramArray = path.split("/");
                    i = 0;
                    while (i < paramArray.length) {
                        normalizedURI.append(URLEncoder.encode(URLDecoder.decode(paramArray[i], DEFAULT_ENCODING), DEFAULT_ENCODING));
                        if (i < paramArray.length - 1) {
                            normalizedURI.append("/");
                        }
                        ++i;
                    }
                    if (path.endsWith("/")) {
                        normalizedURI.append("/");
                    }
                } else if (EMPTY_STRING.equals(path)) {
                    normalizedURI.append("/");
                } else {
                    normalizedURI.append(path);
                }
            }
            if (uri.getRawQuery() != null) {
                paramArray = uri.getRawQuery().split("&");
                StringBuffer paramBuffer = new StringBuffer();
                i = 0;
                while (i < paramArray.length) {
                    String param = paramArray[i];
                    if (param != null && !EMPTY_STRING.equals(param)) {
                        String[] nameValue = param.split("=");
                        if (paramBuffer.length() > 0) {
                            paramBuffer.append("&");
                        }
                        paramBuffer.append(URLEncoder.encode(URLDecoder.decode(nameValue[0], DEFAULT_ENCODING), DEFAULT_ENCODING));
                        if (nameValue.length == 2) {
                            paramBuffer.append(URLEncoder.encode(URLDecoder.decode(nameValue[1], DEFAULT_ENCODING), DEFAULT_ENCODING));
                            paramBuffer.append("=");
                        }
                    }
                    ++i;
                }
                if (paramBuffer.length() > 0) {
                    normalizedURI.append("?").append(paramBuffer.toString());
                }
            }
            if (uri.getFragment() != null) {
                normalizedURI.append("#").append(URLEncoder.encode(uri.getRawFragment(), DEFAULT_ENCODING));
            }
            if (normalizedURI.length() == (scheme != null ? scheme.length() + 1 : 0) && uri.getRawSchemeSpecificPart() != null) {
                normalizedURI.append(uri.getRawSchemeSpecificPart());
            }
            return normalizedURI.toString();
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            return null;
        }
    }
}

