/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.bux.service.atom.ext.impl;

import com.ibm.cognos.bux.logging.BUXLoggerFactory;
import com.ibm.cognos.bux.logging.IClassLogger;
import com.ibm.cognos.bux.service.atom.ext.intf.EntryClassMapper;
import com.ibm.cognos.bux.service.atom.ext.intf.EntryClassMapping;
import java.util.HashMap;
import java.util.Map;
import java.util.StringTokenizer;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.osgi.util.tracker.ServiceTracker;
import org.osgi.util.tracker.ServiceTrackerCustomizer;

public class EntryClassMapperImpl
implements EntryClassMapper,
ServiceTrackerCustomizer {
    private final BundleContext bundleContext;
    private ServiceTracker tracker = null;
    public static final IClassLogger logger = BUXLoggerFactory.getClassLogger(EntryClassMapperImpl.class);
    private final HashMap<String, HashMap<String, String>> mappings = new HashMap();

    public EntryClassMapperImpl(BundleContext bundleContext) {
        this.bundleContext = bundleContext;
    }

    public String getEntryClassFor(String objectClass, String userInterfaces) {
        String entryClass;
        boolean isDebug = logger.isDebugEnabled();
        if (isDebug) {
            logger.debug("getEntryClassFor( \"" + objectClass + "\", \"" + userInterfaces + "\")", null);
        }
        if ((entryClass = this.lookupEntryClass(objectClass, userInterfaces)) == null) {
            String defaultEntryClass = this.getDefaultEntryClass(objectClass);
            if (isDebug) {
                logger.debug("getEntryClassFor(), not matched. entryClass=" + defaultEntryClass, null);
            }
            return defaultEntryClass;
        }
        String mappedEntryClass = this.getDefaultEntryClass(entryClass);
        if (isDebug) {
            logger.debug("getEntryClassFor(), matched. entryClass=" + mappedEntryClass, null);
        }
        return mappedEntryClass;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String lookupEntryClass(String objectClass, String userInterfaces) {
        HashMap<String, HashMap<String, String>> hashMap = this.mappings;
        synchronized (hashMap) {
            Map mapUItoEC;
            block7: {
                block6: {
                    mapUItoEC = this.mappings.get(objectClass);
                    if (mapUItoEC != null) break block6;
                    return null;
                }
                if (userInterfaces != null) break block7;
                return null;
            }
            StringTokenizer st = new StringTokenizer(userInterfaces, ",");
            while (st.hasMoreTokens()) {
                String entryClass = (String)mapUItoEC.get(st.nextToken());
                if (entryClass == null) continue;
                return entryClass;
            }
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addMapping(EntryClassMapping mapping) {
        if (logger.isDebugEnabled()) {
            logger.debug("addMapping() " + mapping, null);
        }
        HashMap<String, HashMap<String, String>> hashMap = this.mappings;
        synchronized (hashMap) {
            HashMap<String, String> mapUItoEC = this.mappings.get(mapping.getObjectClass());
            if (mapUItoEC == null) {
                mapUItoEC = new HashMap();
                this.mappings.put(mapping.getObjectClass(), mapUItoEC);
            }
            mapUItoEC.put(mapping.getUserInterface(), mapping.getEntryClass());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeMapping(EntryClassMapping mapping) {
        HashMap<String, HashMap<String, String>> hashMap = this.mappings;
        synchronized (hashMap) {
            HashMap<String, String> mapUItoEC = this.mappings.get(mapping.getObjectClass());
            if (mapUItoEC == null) {
                return;
            }
            mapUItoEC.remove(mapping.getUserInterface());
        }
    }

    private String getDefaultEntryClass(String objectClass) {
        return "com.ibm.cognos.om85/" + objectClass + "/1";
    }

    public void open() {
        this.tracker = new ServiceTracker(this.bundleContext, EntryClassMapping.class.getName(), (ServiceTrackerCustomizer)this);
        this.tracker.open();
    }

    public void close() {
        if (this.tracker != null) {
            this.tracker.close();
            this.tracker = null;
        }
    }

    public Object addingService(ServiceReference reference) {
        Object o = this.bundleContext.getService(reference);
        if (o instanceof EntryClassMapping) {
            this.addMapping((EntryClassMapping)o);
        }
        return o;
    }

    public void modifiedService(ServiceReference reference, Object service) {
    }

    public void removedService(ServiceReference reference, Object entryClassMapping) {
        this.removeMapping((EntryClassMapping)entryClassMapping);
        this.bundleContext.ungetService(reference);
    }
}

