/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.bux.service.atom.ext.impl;

import com.ibm.cognos.bux.config.BiBusConfiguration;
import com.ibm.cognos.bux.config.BiBusConfigurationManager;
import com.ibm.cognos.bux.http.RequestInformation;
import com.ibm.cognos.bux.http.ResponseInformation;
import com.ibm.cognos.bux.http.ResponsePayload;
import com.ibm.cognos.bux.i18n.LocaleUtils;
import com.ibm.cognos.bux.logging.BUXLoggerFactory;
import com.ibm.cognos.bux.logging.BUXTraceLogger;
import com.ibm.cognos.bux.schemas.atom.CategoryType;
import com.ibm.cognos.bux.schemas.atom.EntryType;
import com.ibm.cognos.bux.service.atom.ext.intf.WidgetFeedProcessor;
import com.ibm.cognos.bux.service.atom.util.ATOMHelper;
import com.ibm.cognos.bux.service.atom.widget.processor.intf.AtomWidgetProcessor;
import com.ibm.cognos.bux.service.atom.widget.processor.intf.DashboardEntryHelper;
import com.ibm.cognos.bux.service.atom.widget.processor.intf.FrameworkContext;
import com.ibm.cognos.bux.service.atom.widget.processor.util.LocalPlatformServices;
import com.ibm.cognos.bux.service.atom.widget.processor.util.PlatformServicesTrackerCustomizer;
import com.ibm.cognos.bux.utils.EncodingUtils;
import com.ibm.cognos.bux.utils.xml.dom.DomUtils;
import java.util.List;
import java.util.Map;
import org.osgi.framework.BundleContext;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceReference;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class WidgetFeedProcessorImpl
extends WidgetFeedProcessor {
    private static final String _0 = "0";
    private static final String WKPHT = "wkpht";
    private static final String WKPWD = "wkpwd";
    private static final String FIRSTTABHT = "firsttabht";
    private static final String FIRSTTABWD = "firsttabwd";
    private static final int GLOBAL_CANVAS = 0;
    private static final int PAGE1 = 1;
    private final BundleContext bundleContext;
    private static BUXTraceLogger traceLogger = BUXLoggerFactory.getLogger((String)WidgetFeedProcessorImpl.class.getName());
    private static final String BUX1_NS = "http://www.ibm.com/xmlns/prod/cognos/bux/1/";

    private static Element getWidgetLayoutInfo(Element widget) {
        Element layoutProps;
        if (widget != null && (layoutProps = (Element)DomUtils.selectSingleNode((Element)widget, (String)"layoutProperties")) != null) {
            return (Element)DomUtils.selectSingleNode((Element)layoutProps, (String)"contentLayout");
        }
        return null;
    }

    private static int getLayoutValue(Element contentLayout, String name) {
        Element el = (Element)DomUtils.selectSingleNode((Element)contentLayout, (String)name);
        return el != null ? Math.round(Float.parseFloat(el.getTextContent())) : 0;
    }

    public WidgetFeedProcessorImpl(BundleContext bundleContext1) {
        this.bundleContext = bundleContext1;
    }

    public void processFeed(String stage, String purpose, RequestInformation request, ResponseInformation response) throws Exception {
        DashboardHelper dashboardHelper = DashboardHelper.create(request, response);
        if (dashboardHelper != null) {
            dashboardHelper.extractDimensions(response);
        } else {
            this.addDefaultDimensionValues(response);
        }
        if (request != null && response != null && dashboardHelper != null && this.isExpeditedWidgetLoadingEnabled()) {
            this._processFeed(stage, purpose, request, response, dashboardHelper);
            this.cleanupInternalParams(request);
        }
    }

    private void addDefaultDimensionValues(ResponseInformation response) {
        Map extraInfoMap;
        if (response != null && (extraInfoMap = response.getExtraInfoMap()) != null) {
            extraInfoMap.put(FIRSTTABWD, _0);
            extraInfoMap.put(FIRSTTABHT, _0);
            extraInfoMap.put(WKPWD, _0);
            extraInfoMap.put(WKPHT, _0);
        }
    }

    private void cleanupInternalParams(RequestInformation request) {
        Map params;
        if (request != null && (params = request.getParameters()) != null) {
            params.remove("exp");
        }
    }

    protected boolean isExpeditedWidgetLoadingEnabled() {
        BiBusConfiguration bibusConfig = BiBusConfigurationManager.getInstance();
        String enabled = bibusConfig.getServiceValue("com.ibm.cognos.bux.service.main", "expeditedWidgetLoad");
        return Boolean.parseBoolean(enabled);
    }

    private void _processFeed(String stage, String purpose, RequestInformation origRequest, ResponseInformation response, DashboardHelper dashboardHelper) throws Exception {
        ServiceReference[] processors = this.findProcessors(stage, purpose);
        if (processors != null) {
            this._processFeed(origRequest, response, processors, dashboardHelper);
        }
    }

    private void _processFeed(RequestInformation origRequest, ResponseInformation response, ServiceReference[] processors, DashboardHelper dashboardHelper) throws Exception {
        NodeList widgets1 = dashboardHelper.getWidgetInstances(0);
        NodeList widgets2 = dashboardHelper.getWidgetInstances(1);
        ServiceReference[] serviceReferenceArray = processors;
        int n = processors.length;
        int n2 = 0;
        while (n2 < n) {
            ServiceReference ref = serviceReferenceArray[n2];
            AtomWidgetProcessor processor = null;
            AtomWidgetProcessor instance = null;
            try {
                try {
                    processor = (AtomWidgetProcessor)this.bundleContext.getService(ref);
                    instance = processor.create();
                    instance.preProcessDashboardAction(origRequest.getBiBusRequestHandle(), origRequest.getCurrentUserRole().value(), (DashboardEntryHelper)dashboardHelper, origRequest.getParameters(), LocaleUtils.toNormalizedString((String)origRequest.getContentLocale().toString()));
                    this.applyWidgetProcessor(instance, widgets1, dashboardHelper);
                    this.applyWidgetProcessor(instance, widgets2, dashboardHelper);
                    instance.postProcessDashboardAction();
                }
                catch (Exception e) {
                    traceLogger.error(WidgetFeedProcessorImpl.class.getName(), e.getLocalizedMessage(), (Throwable)e, null);
                    throw new RuntimeException(e);
                }
            }
            finally {
                if (instance != null) {
                    instance.release();
                }
                this.bundleContext.ungetService(ref);
            }
            ++n2;
        }
    }

    private ServiceReference[] findProcessors(String stage, String purpose) throws InvalidSyntaxException {
        String filter = this.buildFilter(stage, purpose);
        ServiceReference[] processors = this.bundleContext.getAllServiceReferences(AtomWidgetProcessor.class.getName(), filter.toString());
        return processors;
    }

    private void applyWidgetProcessor(AtomWidgetProcessor processor, NodeList widgetInstances, DashboardHelper dashboardHelper) throws Exception {
        if (widgetInstances != null) {
            int j = 0;
            while (j < widgetInstances.getLength()) {
                processor.processWidgetInstance((Element)widgetInstances.item(j), (DashboardEntryHelper)dashboardHelper, (FrameworkContext)dashboardHelper);
                ++j;
            }
        }
    }

    private String buildFilter(String stage, String purpose) {
        StringBuilder sb = new StringBuilder();
        sb.append("(&(stage=").append(stage).append(")(purpose=").append(purpose).append("))");
        return sb.toString();
    }

    private static class DashboardHelper
    implements DashboardEntryHelper,
    FrameworkContext {
        private EntryType dashboardEntry;
        private Element dashboardElement;
        private NodeList pages;
        private String nodeID;
        private String DBRTStateInfo;

        private DashboardHelper(EntryType dbEntry, Element dbElem, RequestInformation request) {
            this.dashboardEntry = dbEntry;
            this.dashboardElement = dbElem;
            this.pages = DomUtils.selectNodes((Element)this.dashboardElement, (String)"page");
            this.nodeID = this.readNodeID(request);
            this.DBRTStateInfo = this.getDBRTStateInfo();
        }

        public static DashboardHelper create(RequestInformation request, ResponseInformation response) {
            Map params;
            String[] action;
            String pathInfo;
            if (request != null & response != null && request.getType() == 0 && (pathInfo = request.getUrlInfo().getPathInfo()).startsWith("/cm/") && (action = (String[])(params = request.getParameters()).get("action")) != null && action[0].equalsIgnoreCase("run")) {
                return DashboardHelper.createInstance(request, response);
            }
            return null;
        }

        private static DashboardHelper createInstance(RequestInformation request, ResponseInformation response) {
            EntryType entryType;
            Element dbElement;
            ResponsePayload en = response.getOutput();
            if (en != null && en instanceof EntryType && (dbElement = DashboardHelper.getDashboardElement(response, entryType = (EntryType)en)) != null) {
                return new DashboardHelper(entryType, dbElement, request);
            }
            return null;
        }

        public NodeList getContentItemSets(Element widgetInstance) {
            return DomUtils.selectNodes((Element)widgetInstance, (String)"contentItemSet");
        }

        public String getCustomTitle(Element widgetIntance, String localeStr) {
            NodeList titleNodes;
            String customTitle = null;
            String defaultTitle = null;
            String defaultLanguage = null;
            boolean isPassedInLocaleChecked = false;
            boolean isDefaultLocaleChecked = false;
            Node titlesRootNode = DomUtils.selectSingleNode((Element)widgetIntance, (String)"customTitles");
            Node defaultLanguageNode = DomUtils.selectSingleNode((Element)((Element)titlesRootNode), (String)"defaultTitleLanguage");
            if (defaultLanguageNode != null) {
                defaultLanguage = DomUtils.getTextContent((Node)defaultLanguageNode);
            }
            if (titlesRootNode != null && (titleNodes = DomUtils.selectNodes((Element)((Element)titlesRootNode), (String)"title")) != null) {
                Node localeNode = null;
                int i = 0;
                while (i < titleNodes.getLength()) {
                    localeNode = DomUtils.selectSingleNode((Element)((Element)titleNodes.item(i)), (String)"locale");
                    if (localeNode != null) {
                        String curLocale = localeNode.getTextContent();
                        if (localeStr.equalsIgnoreCase(curLocale)) {
                            customTitle = DomUtils.getTextContent((Node)DomUtils.selectSingleNode((Element)((Element)titleNodes.item(i)), (String)"value"));
                            isPassedInLocaleChecked = true;
                        } else if (defaultLanguage != null && !defaultLanguage.equalsIgnoreCase(localeStr) && defaultLanguage.equalsIgnoreCase(curLocale)) {
                            defaultTitle = DomUtils.getTextContent((Node)DomUtils.selectSingleNode((Element)((Element)titleNodes.item(i)), (String)"value"));
                            isDefaultLocaleChecked = true;
                        }
                    }
                    if (isPassedInLocaleChecked && isDefaultLocaleChecked) break;
                    ++i;
                }
            }
            return customTitle == null ? defaultTitle : customTitle;
        }

        public String getDashboardID() {
            if (this.dashboardEntry != null) {
                List categories = this.dashboardEntry.getCategoryList();
                for (CategoryType cat : categories) {
                    if ("http://www.ibm.com/xmlns/prod/cognos/icd/contribution#storeid".compareToIgnoreCase(cat.getScheme()) != 0) continue;
                    return cat.getTerm();
                }
            }
            return null;
        }

        private String getDBRTStateInfo() {
            StringBuilder result = new StringBuilder("");
            if (this.dashboardEntry != null) {
                String searchPath = ATOMHelper.getCMSearchPath((EntryType)this.dashboardEntry);
                String title = this.dashboardEntry.getTitle().getContent();
                if (searchPath != null && searchPath.length() > 0) {
                    result.append("<dbSearchPath>");
                    EncodingUtils.xmlencode((String)searchPath, (StringBuilder)result);
                    result.append("</dbSearchPath>");
                }
                if (title != null && title.length() > 0) {
                    result.append("<dbTitle>");
                    EncodingUtils.xmlencode((String)title, (StringBuilder)result);
                    result.append("</dbTitle>");
                }
            }
            return result.toString();
        }

        public String getWidgetRTStateInfo(String widgetTitle) {
            StringBuilder sb = new StringBuilder("<RTStateInfo>");
            if (widgetTitle != null && widgetTitle.length() > 0) {
                sb.append("<widgetTitle>");
                EncodingUtils.xmlencode((String)widgetTitle, (StringBuilder)sb);
                sb.append("</widgetTitle>");
            }
            sb.append(this.DBRTStateInfo);
            return sb.append("</RTStateInfo>").toString();
        }

        public String getNodeID() {
            return this.nodeID;
        }

        public NodeList getWidgetInstances(int pageIdx) {
            if (this.pages != null && pageIdx >= 0 && pageIdx < this.pages.getLength()) {
                Element page = (Element)this.pages.item(pageIdx);
                return DomUtils.selectNodes((Element)page, (String)"widgetInstance");
            }
            return null;
        }

        public NodeList getLayoutWidgetInstances(int pageIdx) {
            Element page;
            Element layout;
            if (this.pages != null && pageIdx >= 0 && pageIdx < this.pages.getLength() && (layout = (Element)DomUtils.selectSingleNode((Element)(page = (Element)this.pages.item(pageIdx)), (String)"layout")) != null) {
                return DomUtils.selectNodes((Element)layout, (String)"widgetInstance");
            }
            return null;
        }

        public Node createContentItemSetItem(Element contentItemSet, String id, String value) {
            Element newItem = contentItemSet.getOwnerDocument().createElementNS(WidgetFeedProcessorImpl.BUX1_NS, "item");
            newItem.setAttributeNS(WidgetFeedProcessorImpl.BUX1_NS, "id", id);
            newItem.setAttributeNS(WidgetFeedProcessorImpl.BUX1_NS, "value", value);
            return newItem;
        }

        public String getAttrNodeValue(Element entry, String name) {
            Attr idAttr = entry.getAttributeNode(name);
            return idAttr != null ? idAttr.getNodeValue() : "";
        }

        private static Element getDashboardElement(ResponseInformation response, EntryType entryType) {
            for (Element element : entryType.getDomOtherList()) {
                if (!"dashboard".equals(element.getLocalName())) continue;
                return element;
            }
            return null;
        }

        private String readNodeID(RequestInformation request) {
            String nodeId = null;
            LocalPlatformServices platform = PlatformServicesTrackerCustomizer.getPlatformServices();
            if (platform != null) {
                nodeId = platform.getNodeId();
            }
            return nodeId;
        }

        public String getWidgetID(Element entry) {
            if (entry != null) {
                return this.getAttrNodeValue(entry, "id");
            }
            return null;
        }

        public void extractDimensions(ResponseInformation response) {
            List domOtherList = this.dashboardEntry.getDomOtherList();
            Document doc = DomUtils.createDocument();
            Element dimData = doc.createElementNS(WidgetFeedProcessorImpl.BUX1_NS, "bux:wkdim");
            int t = 0;
            int l = 0;
            int b = 0;
            int r = 0;
            if (this.pages != null) {
                Map extraInfoMap = response.getExtraInfoMap();
                int firstPage = 0;
                int lastPage = 1;
                if (this.pages.getLength() > 1) {
                    firstPage = 1;
                    lastPage = this.pages.getLength();
                }
                int pageIdx = 0;
                while (pageIdx < lastPage) {
                    NodeList widgets = this.getLayoutWidgetInstances(pageIdx);
                    int pt = 0;
                    int pl = 0;
                    int pb = 0;
                    int pr = 0;
                    if (widgets != null) {
                        int i = 0;
                        while (i < widgets.getLength()) {
                            Element position;
                            Element widget = (Element)widgets.item(i);
                            Element contentLayout = WidgetFeedProcessorImpl.getWidgetLayoutInfo(widget);
                            if (contentLayout != null && (position = (Element)DomUtils.selectSingleNode((Element)contentLayout, (String)"position")) != null && "absolute".compareTo(position.getTextContent()) == 0) {
                                int left = WidgetFeedProcessorImpl.getLayoutValue(contentLayout, "left");
                                int top = WidgetFeedProcessorImpl.getLayoutValue(contentLayout, "top");
                                int width = WidgetFeedProcessorImpl.getLayoutValue(contentLayout, "width");
                                int height = WidgetFeedProcessorImpl.getLayoutValue(contentLayout, "height");
                                if (pageIdx >= firstPage) {
                                    l = left < l ? left : l;
                                    t = top < t ? top : t;
                                    b = top + height > b ? top + height : b;
                                    r = left + width > r ? left + width : r;
                                }
                                pl = left < l ? left : pl;
                                pt = top < pt ? top : pt;
                                pb = top + height > pb ? top + height : pb;
                                pr = left + width > pr ? left + width : pr;
                            }
                            ++i;
                        }
                    }
                    int pagewd = pr - pl;
                    int pageht = pb - pt;
                    if (firstPage == pageIdx && extraInfoMap != null) {
                        extraInfoMap.put(WidgetFeedProcessorImpl.FIRSTTABWD, String.valueOf(pagewd));
                        extraInfoMap.put(WidgetFeedProcessorImpl.FIRSTTABHT, String.valueOf(pageht));
                    }
                    Element pageDim = doc.createElementNS(WidgetFeedProcessorImpl.BUX1_NS, "bux:pgdim");
                    Element e = DomUtils.createElementNSWithTextContent((Document)doc, (String)WidgetFeedProcessorImpl.BUX1_NS, (String)"bux:pgw", (String)String.valueOf(pagewd));
                    pageDim.appendChild(e);
                    e = DomUtils.createElementNSWithTextContent((Document)doc, (String)WidgetFeedProcessorImpl.BUX1_NS, (String)"bux:pgh", (String)String.valueOf(pageht));
                    pageDim.appendChild(e);
                    Element page = (Element)this.pages.item(pageIdx);
                    String id = this.getAttrNodeValue(page, "id");
                    e = DomUtils.createElementNSWithTextContent((Document)doc, (String)WidgetFeedProcessorImpl.BUX1_NS, (String)"bux:pgid", (String)id);
                    pageDim.appendChild(e);
                    dimData.appendChild(pageDim);
                    ++pageIdx;
                }
                int wd = r - l;
                int ht = b - t;
                Element e = DomUtils.createElementNSWithTextContent((Document)doc, (String)WidgetFeedProcessorImpl.BUX1_NS, (String)"bux:wkw", (String)String.valueOf(wd));
                dimData.appendChild(e);
                e = DomUtils.createElementNSWithTextContent((Document)doc, (String)WidgetFeedProcessorImpl.BUX1_NS, (String)"bux:wkh", (String)String.valueOf(ht));
                dimData.appendChild(e);
                domOtherList.add(dimData);
                if (extraInfoMap != null) {
                    extraInfoMap.put(WidgetFeedProcessorImpl.WKPWD, String.valueOf(wd));
                    extraInfoMap.put(WidgetFeedProcessorImpl.WKPHT, String.valueOf(ht));
                }
            }
        }
    }
}

