/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.bux.service.atom.ext.impl.link;

import com.ibm.cognos.bux.http.RequestInformation;
import com.ibm.cognos.bux.http.ResponseInformation;
import com.ibm.cognos.bux.schemas.atom.AtomBase;
import com.ibm.cognos.bux.schemas.atom.CategoryType;
import com.ibm.cognos.bux.schemas.atom.EntryType;
import com.ibm.cognos.bux.schemas.atom.FeedType;
import com.ibm.cognos.bux.schemas.atom.LinkType;
import com.ibm.cognos.bux.service.atom.ext.impl.link.LinkContributorRegistry;
import com.ibm.cognos.bux.service.atom.ext.intf.AtomProcessor;
import com.ibm.cognos.bux.service.atom.ext.intf.EntryClass;
import com.ibm.cognos.bux.service.atom.ext.intf.EntryClassImpl;
import com.ibm.cognos.bux.service.atom.ext.intf.LinkContributor;
import com.ibm.cognos.bux.service.atom.util.ATOMHelper;
import com.ibm.cognos.bux.service.atom.util.ResponseHelper;
import com.ibm.cognos.bux.utils.ChainedMap;
import com.ibm.cognos.bux.utils.EncodingUtils;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LinkAddingFeedProcessor
implements AtomProcessor {
    private LinkContributorRegistry linkContributorRegistry;

    public ResponseInformation processFeed(RequestInformation request, ResponseInformation response) throws Exception {
        AtomBase atom = ResponseHelper.convertResponseToAtom((ResponseInformation)response);
        if (atom instanceof FeedType) {
            FeedType feed = (FeedType)atom;
            for (EntryType entry : feed.getEntryList()) {
                this.processEntry(request, entry);
            }
        } else if (atom instanceof EntryType) {
            this.processEntry(request, (EntryType)atom);
        }
        return response;
    }

    private void processEntry(RequestInformation request, EntryType entry) {
        EntryClass entryClass = this.determineEntryClass(entry);
        List<LinkContributor> linkContributors = this.linkContributorRegistry.getLinkContributors(entryClass);
        if (linkContributors != null) {
            Map config = (Map)request.getRequestContext().get("config");
            ChainedMap tokens = new ChainedMap(config);
            this.addTokens(request, (Map<String, Object>)tokens);
            tokens.remove((Object)"storeid");
            for (CategoryType cat : entry.getCategoryList()) {
                if (!"http://www.ibm.com/xmlns/prod/cognos/icd/contribution#storeid".equals(cat.getScheme())) continue;
                tokens.put((Object)"storeid", (Object)cat.getTerm());
                break;
            }
            this.addLinks((Map<String, Object>)tokens, request.getParameters(), entry, linkContributors);
        }
    }

    private void addTokens(RequestInformation request, Map<String, Object> tokens) {
        tokens.put("web", EncodingUtils.xmlencode((String)((String)request.getHeaders().get("original-web-url")), (StringBuilder)new StringBuilder()).toString());
        tokens.put("cgi", EncodingUtils.xmlencode((String)((String)request.getHeaders().get("script-name")), (StringBuilder)new StringBuilder()).toString());
    }

    private void addLinks(Map<String, Object> config, Map<String, String[]> params, EntryType entry, List<LinkContributor> linkContributors) {
        for (LinkContributor linkContributor : linkContributors) {
            List listLinkDetails = linkContributor.getLinkDetailsList();
            for (LinkContributor.LinkDetails linkDetails : listLinkDetails) {
                LinkType newLink = (LinkType)linkDetails.getLinkType().clone(null);
                newLink.setHref(linkDetails.getUrlTemplate().generateURL(config, params));
                entry.getLinkList().add(newLink);
            }
        }
        ATOMHelper.removeDuplicateLinks((List)entry.getLinkList());
    }

    private EntryClass determineEntryClass(EntryType entry) {
        for (CategoryType cat : entry.getCategoryList()) {
            if (!"http://www.ibm.com/xmlns/prod/cognos/icd/contribution#entryclass".equals(cat.getScheme())) continue;
            return new EntryClassImpl(cat.getTerm());
        }
        return null;
    }

    public void setLinkContributorRegistry(LinkContributorRegistry registry) {
        this.linkContributorRegistry = registry;
    }

    public void unsetLinkContributorRegistry(LinkContributorRegistry registry) {
        this.linkContributorRegistry = null;
    }
}

