/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.bux.service.atom.ext.impl.link;

import com.ibm.cognos.bux.service.atom.ext.intf.EntryClass;
import com.ibm.cognos.bux.service.atom.ext.intf.LinkContributor;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.osgi.util.tracker.ServiceTracker;
import org.osgi.util.tracker.ServiceTrackerCustomizer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LinkContributorRegistry
implements ServiceTrackerCustomizer {
    private final Map<EntryClass, List<LinkContributor>> mapByEntryClass = new HashMap<EntryClass, List<LinkContributor>>();
    private ServiceTracker tracker;
    private BundleContext bundleContext;

    public void init(BundleContext context) {
        this.bundleContext = context;
        this.tracker = new ServiceTracker(context, LinkContributor.class.getName(), (ServiceTrackerCustomizer)this);
        this.tracker.open();
    }

    public void terminate(BundleContext context) {
        if (this.tracker != null) {
            this.tracker.close();
            this.tracker = null;
        }
    }

    private List<LinkContributor> getGeneratorList(EntryClass entryClass) {
        List<LinkContributor> list = this.mapByEntryClass.get(entryClass);
        if (list == null) {
            list = new ArrayList<LinkContributor>();
            this.mapByEntryClass.put(entryClass, list);
        }
        return list;
    }

    public void addLinkContributor(LinkContributor linkContributor) {
        this.getGeneratorList(linkContributor.getEntryClass()).add(linkContributor);
    }

    public void removeLinkContributor(LinkContributor linkContributor) {
        List<LinkContributor> list = this.getGeneratorList(linkContributor.getEntryClass());
        if (list != null) {
            list.remove(linkContributor);
        }
    }

    public List<LinkContributor> getLinkContributors(EntryClass entryClass) {
        return this.mapByEntryClass.get(entryClass);
    }

    public Object addingService(ServiceReference reference) {
        Object o = this.bundleContext.getService(reference);
        if (o instanceof LinkContributor) {
            this.addLinkContributor((LinkContributor)o);
        }
        return o;
    }

    public void modifiedService(ServiceReference reference, Object service) {
    }

    public void removedService(ServiceReference reference, Object service) {
        if (service instanceof LinkContributor) {
            this.removeLinkContributor((LinkContributor)service);
        }
        this.bundleContext.ungetService(reference);
    }
}

