/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.bux.service.atom.provider.proxydelegate;

import com.ibm.cognos.bux.BUXService;
import com.ibm.cognos.bux.http.RequestInformation;
import com.ibm.cognos.bux.http.ResponseInformation;
import com.ibm.cognos.bux.logging.BUXAuditLogger;
import com.ibm.cognos.bux.logging.BUXAuditLoggerFactory;
import com.ibm.cognos.bux.logging.BUXLogAuditLevel;
import com.ibm.cognos.bux.logging.BUXLogBaseDetails;
import com.ibm.cognos.bux.logging.BUXLogDetails;
import com.ibm.cognos.bux.service.atom.AbstractAtomProvider;
import com.ibm.cognos.bux.service.atom.Messages;
import com.ibm.cognos.bux.service.atom.provider.proxydelegate.Activator;
import com.ibm.cognos.bux.utils.http.ErrorResponse;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.osgi.framework.BundleContext;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceReference;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ProxyDelegateAtomProvider
extends AbstractAtomProvider {
    private static final String LOCAL_SERVICE_NAME = "BUX.Atom.Provider.ProxyDelegate";
    private static final String PROVIDER_URL_PATH = "/cm/proxy";
    private static final String CM_PROVIDER_URL_PATH = "/cm";
    private static final String BUX_PROXY_FILTER = "(Name=BUX.Proxy)";
    private final Set<String> urlHosts = new HashSet<String>();

    public String getServiceName() {
        return LOCAL_SERVICE_NAME;
    }

    public String getUrlPath() {
        return PROVIDER_URL_PATH;
    }

    public Set<String> getUrlPaths() {
        return this.urlHosts;
    }

    public ResponseInformation handleRequest(RequestInformation request) {
        ResponseInformation response;
        block11: {
            BUXService buxService = null;
            response = null;
            try {
                try {
                    String pathInfo;
                    buxService = this.getBUXProxyService(BUX_PROXY_FILTER);
                    if (buxService != null && (pathInfo = request.getUrlInfo().getPathInfo()).startsWith(PROVIDER_URL_PATH)) {
                        pathInfo = pathInfo.substring(CM_PROVIDER_URL_PATH.length(), pathInfo.length());
                        request.getUrlInfo().setPathInfo(pathInfo);
                        response = buxService.handleRequest(request);
                    }
                }
                catch (InvalidSyntaxException e) {
                    BUXAuditLogger logger = BUXAuditLoggerFactory.getAuditLogger();
                    if (logger.isAuditLoggingEnabled(BUXLogAuditLevel.AUDIT_LOG_LEVEL_DETAILED)) {
                        BUXLogDetails logDetails = new BUXLogDetails();
                        logDetails.setOperation(BUXLogBaseDetails.Operation.BUX_RESPONSE);
                        HashMap<String, String> logParameters = new HashMap<String, String>(1);
                        logParameters.put("OSGI Service Filter", BUX_PROXY_FILTER);
                        logDetails.setLogDataParameters(logParameters);
                        logDetails.addErrorMessage(e.getLocalizedMessage());
                        logger.auditLogSystemEvent(logDetails, logParameters);
                    }
                    if (buxService != null) {
                        Activator.getContext().ungetService(buxService.getServiceReference());
                    }
                    break block11;
                }
            }
            catch (Throwable throwable) {
                if (buxService != null) {
                    Activator.getContext().ungetService(buxService.getServiceReference());
                }
                throw throwable;
            }
            if (buxService != null) {
                Activator.getContext().ungetService(buxService.getServiceReference());
            }
        }
        if (response != null) {
            return response;
        }
        return new ErrorResponse(500, Messages.ERROR_BAD_URL_PATHINFO.toString(request.getProductLocale()));
    }

    public BUXService getBUXProxyService(String filter) throws InvalidSyntaxException {
        BUXService buxService = null;
        BundleContext bc = Activator.getContext();
        ServiceReference[] serviceRefArray = bc.getServiceReferences(BUXService.class.getName(), filter);
        if (serviceRefArray != null && serviceRefArray.length >= 1) {
            buxService = (BUXService)bc.getService(serviceRefArray[0]);
        }
        return buxService;
    }

    public void init(Map<String, Object> config) {
        super.init(config);
        this.urlHosts.add(PROVIDER_URL_PATH);
    }
}

