/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.bux.ui;

import com.ibm.cognos.bux.BUXException;
import com.ibm.cognos.bux.logging.BUXLoggerFactory;
import com.ibm.cognos.bux.logging.BUXTraceLogger;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import org.osgi.framework.Bundle;

public class ResourceLoader {
    private static BUXTraceLogger traceLogger = BUXLoggerFactory.getLogger((String)ResourceLoader.class.getName());

    public static String getTextResource(Bundle resourceBundle, String filePath) {
        return ResourceLoader.getTextResource(resourceBundle, filePath, false);
    }

    public static String getTextResource(Bundle resourceBundle, String filePath, boolean throwExceptionOnNotFound) {
        StringBuilder sb;
        block17: {
            sb = null;
            URL entry = resourceBundle.getEntry(filePath);
            if (entry == null && throwExceptionOnNotFound) {
                throw new BUXException(filePath);
            }
            if (entry != null) {
                sb = new StringBuilder();
                BufferedReader bs = null;
                try {
                    try {
                        InputStream is = entry.openStream();
                        bs = new BufferedReader(new InputStreamReader(is, "UTF8"));
                        String s = bs.readLine();
                        while (s != null) {
                            sb.append(s).append("\n");
                            s = bs.readLine();
                        }
                    }
                    catch (Exception e1) {
                        ResourceLoader.logException(resourceBundle, filePath, e1);
                        sb = null;
                        if (bs != null) {
                            try {
                                bs.close();
                            }
                            catch (IOException e) {
                                e.printStackTrace();
                            }
                        }
                        break block17;
                    }
                }
                catch (Throwable throwable) {
                    if (bs != null) {
                        try {
                            bs.close();
                        }
                        catch (IOException e) {
                            e.printStackTrace();
                        }
                    }
                    throw throwable;
                }
                if (bs != null) {
                    try {
                        bs.close();
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
            }
        }
        return sb == null ? null : sb.toString();
    }

    public static InputStream getTextResourceAsInputStream(Bundle resourceBundle, String filePath) {
        return ResourceLoader.getTextResourceAsInputStream(resourceBundle, filePath, false);
    }

    public static InputStream getTextResourceAsInputStream(Bundle resourceBundle, String filePath, boolean throwExceptionOnNotFound) {
        InputStream is = null;
        URL entry = resourceBundle.getEntry(filePath);
        if (entry == null && throwExceptionOnNotFound) {
            throw new BUXException(filePath);
        }
        if (entry != null) {
            try {
                is = entry.openStream();
            }
            catch (Exception e1) {
                ResourceLoader.logException(resourceBundle, filePath, e1);
            }
        }
        return is;
    }

    private static void logException(Bundle resourceBundle, String filePath, Exception e1) {
        String msg = String.valueOf(e1.toString()) + "\n...." + resourceBundle.getSymbolicName() + ":" + filePath;
        traceLogger.error(ResourceLoader.class.getName(), msg, null);
    }
}

