/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.bux.utils;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ChainedMap<K, V>
extends HashMap<K, V> {
    private static final long serialVersionUID = 1L;
    private final Map<K, V> nextMap;

    public ChainedMap(Map<K, V> nextMap) {
        this.nextMap = Collections.unmodifiableMap(nextMap);
    }

    @Override
    public boolean containsKey(Object key) {
        return super.containsKey(key) || this.nextMap.containsKey(key);
    }

    @Override
    public boolean containsValue(Object value) {
        return super.containsValue(value) || this.nextMap.containsValue(value);
    }

    @Override
    public Set<Map.Entry<K, V>> entrySet() {
        HashSet<Map.Entry<K, V>> set = new HashSet<Map.Entry<K, V>>();
        for (K key : this.keySet()) {
            set.add(new EntryImpl<K, V>(key, this.get(key)));
        }
        return set;
    }

    @Override
    public V get(Object key) {
        Object value = super.get(key);
        if (value == null) {
            value = this.nextMap.get(key);
        }
        return value;
    }

    @Override
    public boolean isEmpty() {
        return super.isEmpty() && this.nextMap.isEmpty();
    }

    @Override
    public Set<K> keySet() {
        HashSet<K> set = new HashSet<K>();
        set.addAll(super.keySet());
        set.addAll(this.nextMap.keySet());
        return set;
    }

    @Override
    public int size() {
        return this.keySet().size();
    }

    @Override
    public Collection<V> values() {
        HashSet<V> values = new HashSet<V>();
        for (K key : this.keySet()) {
            values.add(this.get(key));
        }
        return values;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class EntryImpl<K, V>
    implements Map.Entry<K, V> {
        private final K key;
        private final V value;

        EntryImpl(K key, V value) {
            this.key = key;
            this.value = value;
        }

        @Override
        public K getKey() {
            return this.key;
        }

        @Override
        public V getValue() {
            return this.value;
        }

        @Override
        public V setValue(V value) {
            throw new UnsupportedOperationException();
        }
    }
}

