/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.bux.utils;

import com.ibm.cognos.bux.utils.Messages;
import com.ibm.cognos.bux.utils.io.SharedByteArrayOutputStream;
import com.ibm.cognos.bux.utils.io.StringBuilderWriter;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.util.StringTokenizer;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Pattern;
import java.util.zip.DeflaterOutputStream;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.w3c.dom.Element;

public final class EncodingUtils {
    private static final String PATH_FOWARDSLASH = "-fslash-";
    private static final String PATH_TILDE = "-tilde-";
    private static final String FOWARDSLASH = "/";
    private static final String TILDE = "~";
    public static final String UTF8 = "UTF8";
    private static final String[] hex = new String[]{"%00", "%01", "%02", "%03", "%04", "%05", "%06", "%07", "%08", "%09", "%0A", "%0B", "%0C", "%0D", "%0E", "%0F", "%10", "%11", "%12", "%13", "%14", "%15", "%16", "%17", "%18", "%19", "%1A", "%1B", "%1C", "%1D", "%1E", "%1F", "%20", "%21", "%22", "%23", "%24", "%25", "%26", "%27", "%28", "%29", "%2A", "%2B", "%2C", "%2D", "%2E", "%2F", "%30", "%31", "%32", "%33", "%34", "%35", "%36", "%37", "%38", "%39", "%3A", "%3B", "%3C", "%3D", "%3E", "%3F", "%40", "%41", "%42", "%43", "%44", "%45", "%46", "%47", "%48", "%49", "%4A", "%4B", "%4C", "%4D", "%4E", "%4F", "%50", "%51", "%52", "%53", "%54", "%55", "%56", "%57", "%58", "%59", "%5A", "%5B", "%5C", "%5D", "%5E", "%5F", "%60", "%61", "%62", "%63", "%64", "%65", "%66", "%67", "%68", "%69", "%6A", "%6B", "%6C", "%6D", "%6E", "%6F", "%70", "%71", "%72", "%73", "%74", "%75", "%76", "%77", "%78", "%79", "%7A", "%7B", "%7C", "%7D", "%7E", "%7F", "%80", "%81", "%82", "%83", "%84", "%85", "%86", "%87", "%88", "%89", "%8A", "%8B", "%8C", "%8D", "%8E", "%8F", "%90", "%91", "%92", "%93", "%94", "%95", "%96", "%97", "%98", "%99", "%9A", "%9B", "%9C", "%9D", "%9E", "%9F", "%A0", "%A1", "%A2", "%A3", "%A4", "%A5", "%A6", "%A7", "%A8", "%A9", "%AA", "%AB", "%AC", "%AD", "%AE", "%AF", "%B0", "%B1", "%B2", "%B3", "%B4", "%B5", "%B6", "%B7", "%B8", "%B9", "%BA", "%BB", "%BC", "%BD", "%BE", "%BF", "%C0", "%C1", "%C2", "%C3", "%C4", "%C5", "%C6", "%C7", "%C8", "%C9", "%CA", "%CB", "%CC", "%CD", "%CE", "%CF", "%D0", "%D1", "%D2", "%D3", "%D4", "%D5", "%D6", "%D7", "%D8", "%D9", "%DA", "%DB", "%DC", "%DD", "%DE", "%DF", "%E0", "%E1", "%E2", "%E3", "%E4", "%E5", "%E6", "%E7", "%E8", "%E9", "%EA", "%EB", "%EC", "%ED", "%EE", "%EF", "%F0", "%F1", "%F2", "%F3", "%F4", "%F5", "%F6", "%F7", "%F8", "%F9", "%FA", "%FB", "%FC", "%FD", "%FE", "%FF"};
    private static final char[] digits = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};
    private static boolean[] dontNeedEncoding = new boolean[256];
    private static Logger logger = Logger.getLogger(EncodingUtils.class.getCanonicalName());
    private static Pattern closingScript;
    private static final int BASE64 = 0;
    private static final int WEB64 = 1;
    private static final String[] encTable;
    private static final char[] padchar;
    private static final byte[] base64DecodeTable;
    private static final byte[] web64DecodeTable;

    static {
        int index = 0;
        while (index < 256) {
            EncodingUtils.dontNeedEncoding[index] = false;
            ++index;
        }
        index = 97;
        while (index <= 122) {
            EncodingUtils.dontNeedEncoding[index] = true;
            ++index;
        }
        index = 65;
        while (index <= 90) {
            EncodingUtils.dontNeedEncoding[index] = true;
            ++index;
        }
        index = 48;
        while (index <= 57) {
            EncodingUtils.dontNeedEncoding[index] = true;
            ++index;
        }
        EncodingUtils.dontNeedEncoding[45] = true;
        EncodingUtils.dontNeedEncoding[95] = true;
        EncodingUtils.dontNeedEncoding[46] = true;
        EncodingUtils.dontNeedEncoding[33] = true;
        EncodingUtils.dontNeedEncoding[126] = true;
        EncodingUtils.dontNeedEncoding[42] = true;
        EncodingUtils.dontNeedEncoding[40] = true;
        EncodingUtils.dontNeedEncoding[41] = true;
        closingScript = Pattern.compile("<\\/[sS][cC][rR][iI][pP][tT]");
        encTable = new String[]{"ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789+/", "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789*-"};
        padchar = new char[]{'=', '_'};
        byte[] byArray = new byte[128];
        byArray[43] = 62;
        byArray[47] = 63;
        byArray[48] = 52;
        byArray[49] = 53;
        byArray[50] = 54;
        byArray[51] = 55;
        byArray[52] = 56;
        byArray[53] = 57;
        byArray[54] = 58;
        byArray[55] = 59;
        byArray[56] = 60;
        byArray[57] = 61;
        byArray[66] = 1;
        byArray[67] = 2;
        byArray[68] = 3;
        byArray[69] = 4;
        byArray[70] = 5;
        byArray[71] = 6;
        byArray[72] = 7;
        byArray[73] = 8;
        byArray[74] = 9;
        byArray[75] = 10;
        byArray[76] = 11;
        byArray[77] = 12;
        byArray[78] = 13;
        byArray[79] = 14;
        byArray[80] = 15;
        byArray[81] = 16;
        byArray[82] = 17;
        byArray[83] = 18;
        byArray[84] = 19;
        byArray[85] = 20;
        byArray[86] = 21;
        byArray[87] = 22;
        byArray[88] = 23;
        byArray[89] = 24;
        byArray[90] = 25;
        byArray[97] = 26;
        byArray[98] = 27;
        byArray[99] = 28;
        byArray[100] = 29;
        byArray[101] = 30;
        byArray[102] = 31;
        byArray[103] = 32;
        byArray[104] = 33;
        byArray[105] = 34;
        byArray[106] = 35;
        byArray[107] = 36;
        byArray[108] = 37;
        byArray[109] = 38;
        byArray[110] = 39;
        byArray[111] = 40;
        byArray[112] = 41;
        byArray[113] = 42;
        byArray[114] = 43;
        byArray[115] = 44;
        byArray[116] = 45;
        byArray[117] = 46;
        byArray[118] = 47;
        byArray[119] = 48;
        byArray[120] = 49;
        byArray[121] = 50;
        byArray[122] = 51;
        base64DecodeTable = byArray;
        byte[] byArray2 = new byte[128];
        byArray2[42] = 62;
        byArray2[45] = 63;
        byArray2[47] = 63;
        byArray2[48] = 52;
        byArray2[49] = 53;
        byArray2[50] = 54;
        byArray2[51] = 55;
        byArray2[52] = 56;
        byArray2[53] = 57;
        byArray2[54] = 58;
        byArray2[55] = 59;
        byArray2[56] = 60;
        byArray2[57] = 61;
        byArray2[66] = 1;
        byArray2[67] = 2;
        byArray2[68] = 3;
        byArray2[69] = 4;
        byArray2[70] = 5;
        byArray2[71] = 6;
        byArray2[72] = 7;
        byArray2[73] = 8;
        byArray2[74] = 9;
        byArray2[75] = 10;
        byArray2[76] = 11;
        byArray2[77] = 12;
        byArray2[78] = 13;
        byArray2[79] = 14;
        byArray2[80] = 15;
        byArray2[81] = 16;
        byArray2[82] = 17;
        byArray2[83] = 18;
        byArray2[84] = 19;
        byArray2[85] = 20;
        byArray2[86] = 21;
        byArray2[87] = 22;
        byArray2[88] = 23;
        byArray2[89] = 24;
        byArray2[90] = 25;
        byArray2[97] = 26;
        byArray2[98] = 27;
        byArray2[99] = 28;
        byArray2[100] = 29;
        byArray2[101] = 30;
        byArray2[102] = 31;
        byArray2[103] = 32;
        byArray2[104] = 33;
        byArray2[105] = 34;
        byArray2[106] = 35;
        byArray2[107] = 36;
        byArray2[108] = 37;
        byArray2[109] = 38;
        byArray2[110] = 39;
        byArray2[111] = 40;
        byArray2[112] = 41;
        byArray2[113] = 42;
        byArray2[114] = 43;
        byArray2[115] = 44;
        byArray2[116] = 45;
        byArray2[117] = 46;
        byArray2[118] = 47;
        byArray2[119] = 48;
        byArray2[120] = 49;
        byArray2[121] = 50;
        byArray2[122] = 51;
        web64DecodeTable = byArray2;
    }

    private EncodingUtils() {
    }

    public static String pathencode(String str) {
        if (str == null) {
            throw new NullPointerException();
        }
        String strResult = str.replaceAll(FOWARDSLASH, PATH_FOWARDSLASH);
        strResult = strResult.replaceAll(TILDE, PATH_TILDE);
        return strResult;
    }

    public static String pathdecode(String str) {
        if (str == null) {
            return null;
        }
        String strResult = str.replaceAll(PATH_FOWARDSLASH, FOWARDSLASH);
        strResult = strResult.replaceAll(PATH_TILDE, TILDE);
        return strResult;
    }

    public static StringBuilder urlencode(String str, String enc, boolean form, StringBuilder sbuf) {
        byte[] sbytes;
        if (str == null || enc == null || sbuf == null) {
            throw new NullPointerException();
        }
        try {
            sbytes = str.getBytes(enc);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            sbytes = str.getBytes();
        }
        if (form) {
            byte[] byArray = sbytes;
            int n = sbytes.length;
            int n2 = 0;
            while (n2 < n) {
                int chr;
                int sbyte = byArray[n2];
                if (sbyte >= 0 && sbyte <= 127) {
                    chr = sbyte;
                    if (dontNeedEncoding[chr]) {
                        sbuf.append((char)chr);
                    } else if (chr == 32) {
                        sbuf.append('+');
                    } else {
                        sbuf.append(hex[chr]);
                    }
                } else {
                    chr = 128 + (sbyte & 0x7F);
                    sbuf.append(hex[chr]);
                }
                ++n2;
            }
        } else {
            byte[] byArray = sbytes;
            int n = sbytes.length;
            int n3 = 0;
            while (n3 < n) {
                int chr;
                int sbyte = byArray[n3];
                if (sbyte >= 0 && sbyte <= 127) {
                    chr = sbyte;
                    if (dontNeedEncoding[chr]) {
                        sbuf.append((char)chr);
                    } else {
                        sbuf.append(hex[chr]);
                    }
                } else {
                    chr = 128 + (sbyte & 0x7F);
                    sbuf.append(hex[chr]);
                }
                ++n3;
            }
        }
        return sbuf;
    }

    public static String urldecode(String str, String enc) {
        if (str == null) {
            return null;
        }
        if (enc == null) {
            throw new NullPointerException();
        }
        ByteArrayOutputStream bos = new ByteArrayOutputStream(str.length());
        int i = 0;
        while (i < str.length()) {
            char ch = str.charAt(i);
            switch (ch) {
                case '%': {
                    ch = str.charAt(++i);
                    int hb = (Character.isDigit(ch) ? ch - 48 : 10 + Character.toUpperCase(ch) - 65) & 0xF;
                    ch = str.charAt(++i);
                    int lb = (Character.isDigit(ch) ? ch - 48 : 10 + Character.toUpperCase(ch) - 65) & 0xF;
                    int b = hb << 4 | lb;
                    bos.write((byte)b);
                    break;
                }
                case '+': {
                    bos.write(32);
                    break;
                }
                default: {
                    if (ch < '\u0080') {
                        bos.write((byte)ch);
                        break;
                    }
                    return str;
                }
            }
            ++i;
        }
        try {
            return bos.toString(enc);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            return bos.toString();
        }
    }

    public static StringBuilder xmlencode(String str, StringBuilder sbuf) {
        int i = 0;
        while (i < str.length()) {
            char x = str.charAt(i);
            switch (x) {
                case '\'': {
                    sbuf.append("&apos;");
                    break;
                }
                case '<': {
                    sbuf.append("&lt;");
                    break;
                }
                case '>': {
                    sbuf.append("&gt;");
                    break;
                }
                case '&': {
                    sbuf.append("&amp;");
                    break;
                }
                case '\"': {
                    sbuf.append("&quot;");
                    break;
                }
                default: {
                    sbuf.append(x);
                }
            }
            ++i;
        }
        return sbuf;
    }

    public static StringBuilder xmldecode(String str, StringBuilder sbuf) {
        int i = 0;
        while (i < str.length()) {
            char x = str.charAt(i);
            if (x == '&') {
                if (str.startsWith("&apos;", i)) {
                    sbuf.append('\'');
                    i += 6;
                    continue;
                }
                if (str.startsWith("&lt;", i)) {
                    sbuf.append('<');
                    i += 4;
                    continue;
                }
                if (str.startsWith("&gt;", i)) {
                    sbuf.append('>');
                    i += 4;
                    continue;
                }
                if (str.startsWith("&amp;", i)) {
                    sbuf.append('&');
                    i += 5;
                    continue;
                }
                if (str.startsWith("&quot;", i)) {
                    sbuf.append('\"');
                    i += 6;
                    continue;
                }
                sbuf.append('&');
                ++i;
                continue;
            }
            sbuf.append(x);
            ++i;
        }
        return sbuf;
    }

    public static StringBuilder htmlencode(String str, StringBuilder sbuf) {
        int i = 0;
        while (i < str.length()) {
            char x = str.charAt(i);
            switch (x) {
                case '<': {
                    sbuf.append("&lt;");
                    break;
                }
                case '>': {
                    sbuf.append("&gt;");
                    break;
                }
                case '&': {
                    sbuf.append("&amp;");
                    break;
                }
                case '\"': {
                    sbuf.append("&quot;");
                    break;
                }
                default: {
                    sbuf.append(x);
                }
            }
            ++i;
        }
        return sbuf;
    }

    public static StringBuilder javascriptencode(String str, StringBuilder sbuf) {
        if (str != null) {
            String prev;
            String strLocal = str;
            do {
                prev = strLocal;
            } while (!(strLocal = closingScript.matcher(strLocal).replaceAll("")).equals(prev));
            int i = 0;
            while (i < strLocal.length()) {
                char x = strLocal.charAt(i);
                switch (x) {
                    case '\b': {
                        sbuf.append("\\b");
                        break;
                    }
                    case '\t': {
                        sbuf.append("\\t");
                        break;
                    }
                    case '\n': {
                        sbuf.append("\\n");
                        break;
                    }
                    case '\u000b': {
                        sbuf.append("\\v");
                        break;
                    }
                    case '\f': {
                        sbuf.append("\\f");
                        break;
                    }
                    case '\r': {
                        sbuf.append("\\r");
                        break;
                    }
                    case '\"': {
                        sbuf.append("\\\"");
                        break;
                    }
                    case '\'': {
                        sbuf.append("\\'");
                        break;
                    }
                    case '\\': {
                        sbuf.append("\\\\");
                        break;
                    }
                    case '<': {
                        sbuf.append("\\x3C");
                        break;
                    }
                    case '>': {
                        sbuf.append("\\x3E");
                        break;
                    }
                    default: {
                        sbuf.append(x);
                    }
                }
                ++i;
            }
        }
        return sbuf;
    }

    public static StringBuilder base64encode(byte[] buf, boolean compress, StringBuilder sbuf) {
        return EncodingUtils.base64encode(0, buf, compress, sbuf);
    }

    public static StringBuilder web64encode(byte[] buf, boolean compress, StringBuilder sbuf) {
        return EncodingUtils.base64encode(1, buf, compress, sbuf);
    }

    public static StringBuilder hexencode(byte[] buf, boolean compress, StringBuilder sbuf) {
        byte[] _buf;
        byte[] byArray = _buf = compress ? EncodingUtils.compress(buf) : buf;
        int n = _buf.length;
        int n2 = 0;
        while (n2 < n) {
            byte b = byArray[n2];
            sbuf.append(digits[(b & 0xF0) >> 4]);
            sbuf.append(digits[b & 0xF]);
            ++n2;
        }
        return sbuf;
    }

    public static byte[] base64decode(String str, boolean decompress) {
        return EncodingUtils.base64decode(0, str, decompress);
    }

    public static byte[] web64decode(String str, boolean decompress) {
        return EncodingUtils.base64decode(1, str, decompress);
    }

    public static byte[] hexdecode(String str, boolean decompress) {
        SharedByteArrayOutputStream ret = new SharedByteArrayOutputStream(str.length() / 2);
        int i = 0;
        while (i < str.length()) {
            byte b;
            char d1 = str.charAt(i++);
            char d2 = str.charAt(i++);
            if (d1 >= '0' && d1 <= '9') {
                b = (byte)(d1 - 48 << 4);
            } else if (d1 >= 'A' && d1 <= 'F') {
                b = (byte)(d1 - 65 + 10 << 4);
            } else if (d1 >= 'a' && d1 <= 'f') {
                b = (byte)(d1 - 97 + 10 << 4);
            } else {
                throw new IllegalArgumentException(Messages.INVALID_HEX_DIGIT_ERROR.format(new Object[]{new Character(d1)}));
            }
            if (d2 >= '0' && d2 <= '9') {
                b = (byte)(b + (byte)(d2 - 48));
            } else if (d2 >= 'A' && d2 <= 'F') {
                b = (byte)(b + (byte)(d2 - 65 + 10));
            } else if (d2 >= 'a' && d2 <= 'f') {
                b = (byte)(b + (byte)(d2 - 97 + 10));
            } else {
                throw new IllegalArgumentException(Messages.INVALID_HEX_DIGIT_ERROR.format(new Object[]{new Character(d2)}));
            }
            ret.write(b);
        }
        if (decompress) {
            return EncodingUtils.decompress(ret.toStream());
        }
        return ret.toByteArray();
    }

    private static StringBuilder base64encode(int mode, byte[] buf, boolean compress, StringBuilder ret) {
        byte[] _buf = compress ? EncodingUtils.compress(buf) : buf;
        int c = 0;
        int size = _buf.length;
        int i = 0;
        while (i < size) {
            c = _buf[i] >> 2 & 0x3F;
            ret.append(encTable[mode].charAt(c));
            c = _buf[i] << 4 & 0x30;
            if (++i < size) {
                c |= _buf[i] >> 4 & 0xF;
            }
            ret.append(encTable[mode].charAt(c));
            if (i < size) {
                c = _buf[i] << 2 & 0x3C;
                if (++i < size) {
                    c |= _buf[i] >> 6 & 3;
                }
                ret.append(encTable[mode].charAt(c));
            } else {
                ++i;
                ret.append(padchar[mode]);
            }
            if (i < size) {
                c = _buf[i] & 0x3F;
                ret.append(encTable[mode].charAt(c));
            } else {
                ret.append(padchar[mode]);
            }
            ++i;
        }
        return ret;
    }

    private static byte[] base64decode(int mode, String str, boolean decompress) {
        if (str == null) {
            return null;
        }
        byte[] decodeTable = mode == 0 ? base64DecodeTable : web64DecodeTable;
        int len = str.length();
        if (len % 4 != 0) {
            return str.getBytes();
        }
        int rsize = (len / 4 + 1) * 3;
        SharedByteArrayOutputStream ret = new SharedByteArrayOutputStream(rsize);
        try {
            int i = 0;
            while (i < len) {
                int c = decodeTable[(byte)str.charAt(i++)];
                int c1 = decodeTable[(byte)str.charAt(i++)];
                c = c << 2 & 0xFC | c1 >> 4 & 3;
                ret.write((byte)c);
                if (str.charAt(i) == padchar[mode]) break;
                c = decodeTable[(byte)str.charAt(i++)];
                c1 = c1 << 4 & 0xF0 | c >> 2 & 0xF;
                ret.write((byte)c1);
                if (str.charAt(i) == padchar[mode]) break;
                c1 = decodeTable[(byte)str.charAt(i)];
                c = c << 6 & 0xC0 | c1 & 0x3F;
                ret.write((byte)c);
                ++i;
            }
            if (decompress) {
                return EncodingUtils.decompress(ret.toStream());
            }
            return ret.toByteArray();
        }
        catch (Exception exception) {
            return str.getBytes();
        }
    }

    /*
     * Loose catch block
     */
    public static byte[] compress(byte[] buf) {
        DeflaterOutputStream gzos = null;
        ByteArrayOutputStream bos = null;
        bos = new ByteArrayOutputStream(buf.length);
        gzos = new GZIPOutputStream(bos);
        gzos.write(buf);
        gzos.flush();
        gzos.close();
        gzos = null;
        byte[] byArray = bos.toByteArray();
        try {
            if (gzos != null) {
                gzos.close();
            }
        }
        catch (IOException iOException) {}
        try {
            if (bos != null) {
                bos.close();
            }
        }
        catch (IOException iOException) {}
        return byArray;
        catch (IOException iOException) {
            try {}
            catch (Throwable throwable) {
                try {
                    if (gzos != null) {
                        gzos.close();
                    }
                }
                catch (IOException iOException2) {}
                try {
                    if (bos != null) {
                        bos.close();
                    }
                }
                catch (IOException iOException3) {}
                throw throwable;
            }
            try {
                if (gzos != null) {
                    gzos.close();
                }
            }
            catch (IOException iOException4) {}
            try {
                if (bos != null) {
                    bos.close();
                }
            }
            catch (IOException iOException5) {}
            return null;
        }
    }

    /*
     * Loose catch block
     */
    public static byte[] decompress(InputStream bis) {
        byte[] byArray;
        ByteArrayOutputStream bos;
        GZIPInputStream gzis;
        block21: {
            int nByteRead;
            gzis = null;
            bos = null;
            gzis = new GZIPInputStream(bis);
            bos = new ByteArrayOutputStream();
            byte[] buf = new byte[256];
            while ((nByteRead = gzis.read(buf, 0, 256)) != -1) {
                bos.write(buf, 0, nByteRead);
            }
            bos.flush();
            byArray = bos.toByteArray();
            if (bos == null) break block21;
            try {
                bos.close();
            }
            catch (IOException iOException) {}
        }
        if (gzis != null) {
            try {
                gzis.close();
            }
            catch (IOException iOException) {}
        }
        return byArray;
        catch (IOException iOException) {
            block22: {
                try {
                    if (bos == null) break block22;
                }
                catch (Throwable throwable) {
                    if (bos != null) {
                        try {
                            bos.close();
                        }
                        catch (IOException iOException2) {}
                    }
                    if (gzis != null) {
                        try {
                            gzis.close();
                        }
                        catch (IOException iOException3) {}
                    }
                    throw throwable;
                }
                try {
                    bos.close();
                }
                catch (IOException iOException4) {}
            }
            if (gzis != null) {
                try {
                    gzis.close();
                }
                catch (IOException iOException5) {}
            }
            return null;
        }
    }

    /*
     * Loose catch block
     */
    public static String convertXMLToHTML(Element element) {
        StringBuilderWriter out = new StringBuilderWriter(new StringBuilder());
        TransformerFactory factory = TransformerFactory.newInstance();
        Transformer transformer = factory.newTransformer();
        transformer.setOutputProperty("indent", "no");
        transformer.setOutputProperty("method", "html");
        transformer.setOutputProperty("omit-xml-declaration", "yes");
        DOMSource source = new DOMSource(element);
        StreamResult result = new StreamResult(out);
        transformer.transform(source, result);
        String startTag = "<" + element.getNodeName() + ">";
        String endTag = "</" + element.getNodeName() + ">";
        StringBuilder buf = out.getBuilder();
        int start = 0;
        int end = buf.length();
        if (buf.length() >= startTag.length() + endTag.length()) {
            if (startTag.equals(buf.subSequence(0, startTag.length()))) {
                start += startTag.length();
            }
            if (endTag.equals(buf.subSequence(buf.length() - endTag.length(), buf.length()))) {
                end -= endTag.length();
            }
        }
        String string = buf.substring(start, end);
        try {
            out.close();
        }
        catch (IOException iOException) {}
        return string;
        catch (TransformerException e) {
            try {
                logger.log(Level.INFO, Messages.DOM_TOSTRING_XSLT_ERROR.toString(), e);
            }
            catch (Throwable throwable) {
                try {
                    out.close();
                }
                catch (IOException iOException) {}
                throw throwable;
            }
            try {
                out.close();
            }
            catch (IOException iOException) {}
        }
        return "";
    }

    public static StringBuilder escapeString(String s, String unsafeChars, char escapeChar, StringBuilder sbuf) {
        int i = 0;
        while (i < s.length()) {
            char x = s.charAt(i);
            if (x == escapeChar || unsafeChars.indexOf(x) >= 0) {
                sbuf.append(escapeChar);
            }
            sbuf.append(x);
            ++i;
        }
        return sbuf;
    }

    public static StringBuilder unescapeString(String s, char escapeChar, StringBuilder sbuf) {
        boolean lastWasEscape = false;
        int i = 0;
        while (i < s.length()) {
            char x = s.charAt(i);
            if (x == escapeChar && !lastWasEscape) {
                lastWasEscape = true;
            } else {
                sbuf.append(x);
                lastWasEscape = false;
            }
            ++i;
        }
        return sbuf;
    }

    public static String urlPathEncode(String urlPath, String enc) {
        if (urlPath != null && urlPath.length() > 0) {
            StringBuilder sb = new StringBuilder();
            StringTokenizer st = new StringTokenizer(urlPath, FOWARDSLASH, true);
            while (st.hasMoreTokens()) {
                String token = st.nextToken();
                if (token.compareTo(FOWARDSLASH) == 0) {
                    sb.append('/');
                    continue;
                }
                EncodingUtils.urlencode(token, enc, false, sb);
            }
            return sb.toString();
        }
        return urlPath;
    }
}

