/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.bux.utils;

import com.ibm.cognos.bux.BUXURIResolver;
import com.ibm.cognos.bux.utils.Activator;
import com.ibm.cognos.bux.utils.io.SharedByteArrayResponsePayload;
import java.io.IOException;
import java.io.InputStream;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.Map;
import javax.xml.transform.Templates;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.URIResolver;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import org.osgi.framework.Bundle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public enum ResponseConverters {
    None{

        protected String path() {
            return null;
        }

        public String getContentType() {
            return null;
        }
    }
    ,
    Json{

        protected String path() {
            return "data/asJSON.xslt";
        }

        public String getContentType() {
            return "application/javascript";
        }
    }
    ,
    JsonCompact{

        protected String path() {
            return "data/asJSON_compact.xslt";
        }

        public String getContentType() {
            return "application/javascript";
        }
    }
    ,
    Dojo{

        protected String path() {
            return "data/asDOJO.xslt";
        }

        public String getContentType() {
            return "application/javascript";
        }

        protected void setResponseTypeSpecificParameters(Transformer transformer) {
            transformer.setParameter(ResponseConverters.TAGS_PARAM_NAME, ResponseConverters.TAGS_LIST);
        }
    }
    ,
    DojoCompact{

        protected String path() {
            return "data/asDOJO_compact.xslt";
        }

        public String getContentType() {
            return "application/javascript";
        }

        protected void setResponseTypeSpecificParameters(Transformer transformer) {
            transformer.setParameter(ResponseConverters.TAGS_PARAM_NAME, ResponseConverters.TAGS_LIST);
        }
    }
    ,
    Atom{

        protected String path() {
            return "data/asJSON.xslt";
        }

        public String getContentType() {
            return "application/javascript";
        }

        protected void setResponseTypeSpecificParameters(Transformer transformer) {
            transformer.setParameter(ResponseConverters.TAGS_PARAM_NAME, ResponseConverters.TAGS_LIST);
        }
    }
    ,
    AtomCompact{

        protected String path() {
            return "data/asJSON_compact.xslt";
        }

        public String getContentType() {
            return "application/javascript";
        }

        protected void setResponseTypeSpecificParameters(Transformer transformer) {
            transformer.setParameter(ResponseConverters.TAGS_PARAM_NAME, ResponseConverters.TAGS_LIST);
        }
    };

    private static final String TAGS_PARAM_NAME = "tagsAsStrings";
    private static final String TAGS_LIST = ",term,scheme,label,rel,type,href,title,";
    private static TransformerFactory factory;
    private Templates templates;

    static {
        factory = TransformerFactory.newInstance();
    }

    private ResponseConverters() {
    }

    public abstract String getContentType();

    public void transform(InputStream in, SharedByteArrayResponsePayload out, Map<String, String[]> parameters) {
        try {
            Transformer transformer = this.getTemplates().newTransformer();
            if (parameters != null) {
                for (Map.Entry<String, String[]> param : parameters.entrySet()) {
                    String[] values = param.getValue();
                    transformer.setParameter(param.getKey(), values[0]);
                }
                this.setResponseTypeSpecificParameters(transformer);
                transformer.transform(new StreamSource(in), new StreamResult(out));
            }
        }
        catch (TransformerException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (URISyntaxException e) {
            e.printStackTrace();
        }
    }

    protected abstract String path();

    private Templates getTemplates() throws TransformerConfigurationException, IOException, URISyntaxException {
        Bundle bundle = Activator.getContext().getBundle();
        if (this.templates == null && this.path() != null) {
            URL name = bundle.getEntry(this.path());
            factory.setURIResolver((URIResolver)new BUXURIResolver(bundle));
            this.templates = factory.newTemplates(new StreamSource(name.openStream(), name.toURI().toString()));
        }
        return this.templates;
    }

    protected void setResponseTypeSpecificParameters(Transformer transformer) {
    }

    /* synthetic */ ResponseConverters(String string, int n, ResponseConverters responseConverters) {
        this();
    }
}

