/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.bux.utils;

import com.ibm.cognos.bux.utils.EncodingUtils;
import java.util.ArrayList;

public final class StringUtils {
    private StringUtils() {
    }

    public static String join(String[] strings, char sepChar) {
        if (strings != null) {
            if (strings.length > 0) {
                StringBuilder sbuf = new StringBuilder(strings[0]);
                int i = 1;
                while (i < strings.length) {
                    sbuf.append(sepChar).append(strings[i]);
                    ++i;
                }
                return sbuf.toString();
            }
            return "";
        }
        return null;
    }

    public static String join(String[] strings, String sepChar) {
        if (strings != null) {
            if (strings.length > 0) {
                StringBuilder sbuf = new StringBuilder(strings[0]);
                int i = 1;
                while (i < strings.length) {
                    sbuf.append(sepChar).append(strings[i]);
                    ++i;
                }
                return sbuf.toString();
            }
            return "";
        }
        return null;
    }

    public static String join(String ... strings) {
        StringBuilder result = new StringBuilder();
        String[] stringArray = strings;
        int n = strings.length;
        int n2 = 0;
        while (n2 < n) {
            String string = stringArray[n2];
            result.append(string);
            ++n2;
        }
        return result.toString();
    }

    public static String[] split(String src, char sep, char escapeChar, boolean unescape) {
        if (src == null) {
            return null;
        }
        String temp = src;
        StringBuilder sbuf = null;
        if (unescape) {
            sbuf = new StringBuilder();
        }
        ArrayList<String> arr = new ArrayList<String>();
        int i = temp.indexOf(sep);
        while (i >= 0) {
            if (i > 0 && temp.charAt(i - 1) == escapeChar) {
                i = temp.indexOf(sep, i + 1);
                continue;
            }
            if (sbuf != null) {
                sbuf.setLength(0);
                EncodingUtils.unescapeString(temp.substring(0, i), escapeChar, sbuf);
                arr.add(sbuf.toString());
            } else {
                arr.add(temp.substring(0, i));
            }
            temp = temp.substring(i + 1);
            i = temp.indexOf(sep);
        }
        if (sbuf != null) {
            sbuf.setLength(0);
            EncodingUtils.unescapeString(temp, escapeChar, sbuf);
            arr.add(sbuf.toString());
        } else {
            arr.add(temp);
        }
        return arr.toArray(new String[arr.size()]);
    }
}

