/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.bux.utils.http;

import com.ibm.cognos.bux.BUXException;
import com.ibm.cognos.bux.http.ResponseInformation;
import com.ibm.cognos.bux.utils.XMLErrorResponseHelper;
import com.ibm.cognos.bux.utils.io.StringBuilderWriter;
import java.io.PrintWriter;

public class ErrorResponse
extends ResponseInformation {
    private final String code;
    private final String message;
    private final String detail;
    private final Exception ex;

    protected ErrorResponse(int status, String code, String message, String detail, Exception ex) {
        super(status, XMLErrorResponseHelper.buildErrorXml(code, message, detail), "text/xml");
        this.code = code;
        this.message = message;
        this.detail = detail;
        this.ex = ex;
    }

    public ErrorResponse(int status, String code, String message, String detail) {
        this(status, code, message, detail, null);
    }

    public ErrorResponse(int status, String code, String message) {
        this(status, code, message, ErrorResponse.generateStackTrace(new Exception()));
    }

    public ErrorResponse(int status, String message) {
        this(status, String.valueOf(status), message, ErrorResponse.generateStackTrace(new Exception()));
    }

    public ErrorResponse(int status, String message, Exception ex) {
        this(status, String.valueOf(status), message, ErrorResponse.generateStackTrace(ex), ex);
    }

    public ErrorResponse(int status, Exception ex) {
        this(status, ex.getClass().getName(), ex.getLocalizedMessage(), ErrorResponse.generateStackTrace(ex), ex);
    }

    public String getCode() {
        return this.code;
    }

    public String getMessage() {
        return this.message;
    }

    public String getDetail() {
        return this.detail;
    }

    public Exception getException() {
        return this.ex;
    }

    public BUXException toFault() {
        return new BUXException(this.getMessage(), (Throwable)this.getException(), this.getDetail());
    }

    private static String generateStackTrace(Throwable ex) {
        StringBuilder sbuf = new StringBuilder();
        PrintWriter printWriter = new PrintWriter(new StringBuilderWriter(sbuf));
        try {
            ex.printStackTrace(printWriter);
            printWriter.flush();
        }
        finally {
            printWriter.close();
        }
        return sbuf.toString();
    }
}

