/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.bux.utils.http;

import com.ibm.cognos.bux.http.HttpClientFactory;
import com.ibm.cognos.bux.http.HttpClientManager;
import com.ibm.cognos.bux.logging.BUXLoggerFactory;
import com.ibm.cognos.bux.logging.BUXTraceLogger;
import java.net.URL;
import java.util.HashMap;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpConnectionManager;
import org.apache.commons.httpclient.MultiThreadedHttpConnectionManager;

public class PooledHttpClientFactory {
    private static final String DELIM = ":";
    private static BUXTraceLogger traceLogger = BUXLoggerFactory.getLogger((String)PooledHttpClientFactory.class.getName());
    private int maxConnectionsPerHost = -1;
    private int totalMaxConnections = -1;
    private int connectionTimeout = -1;
    private final ReentrantReadWriteLock readWriteLock = new ReentrantReadWriteLock();
    private final Lock readLock = this.readWriteLock.readLock();
    private final Lock writeLock = this.readWriteLock.writeLock();
    private final HashMap<String, HttpClient> httpClientMap = new HashMap();

    public PooledHttpClientFactory() {
    }

    public PooledHttpClientFactory(int maxConnPerHost, int totalMaxConns, int timeout) {
        this.maxConnectionsPerHost = maxConnPerHost;
        this.totalMaxConnections = totalMaxConns;
        this.connectionTimeout = timeout;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public HttpClient createHttpClient(URL url) {
        HttpClient httpclnt = null;
        String key = this.getKey(url);
        HttpClientFactory theFactory = HttpClientManager.getInstance();
        if (theFactory == null) return httpclnt;
        this.readLock.lock();
        httpclnt = this.httpClientMap.get(key);
        if (httpclnt == null) {
            this.readLock.unlock();
            this.writeLock.lock();
            try {
                httpclnt = this.httpClientMap.get(key);
                if (httpclnt == null) {
                    httpclnt = theFactory.createHttpClient(url);
                    if (httpclnt == null) return httpclnt;
                    this.httpClientMap.put(key, httpclnt);
                    if (traceLogger != null && traceLogger.isDebugEnabled()) {
                        String msg = "Created new HttpClient for " + key + "\n";
                        traceLogger.debug(PooledHttpClientFactory.class.getName(), msg, null);
                    }
                    this.initializeParams(httpclnt);
                    return httpclnt;
                }
                httpclnt = this.httpClientMap.get(key);
                if (httpclnt != null) return httpclnt;
                traceLogger.error(PooledHttpClientFactory.class.getName(), "Failed to get HttpClient for " + key, null);
                return httpclnt;
            }
            finally {
                this.writeLock.unlock();
            }
        } else {
            this.readLock.unlock();
        }
        return httpclnt;
    }

    public void reconfigureHttpClients() {
        try {
            this.writeLock.lock();
            for (HttpClient httpClient : this.httpClientMap.values()) {
                this.initializeParams(httpClient);
            }
        }
        finally {
            this.writeLock.unlock();
        }
    }

    protected void initializeParams(HttpClient httpclnt) {
        MultiThreadedHttpConnectionManager connectionManager = new MultiThreadedHttpConnectionManager();
        if (-1 != this.maxConnectionsPerHost) {
            connectionManager.setMaxConnectionsPerHost(this.maxConnectionsPerHost);
        }
        if (-1 != this.totalMaxConnections) {
            connectionManager.setMaxTotalConnections(this.totalMaxConnections);
        }
        httpclnt.setHttpConnectionManager((HttpConnectionManager)connectionManager);
        if (-1 != this.connectionTimeout) {
            httpclnt.setConnectionTimeout(1000 * this.connectionTimeout);
        }
    }

    private String getKey(URL url) {
        String key = "";
        if (url != null) {
            StringBuilder keyBuilder = new StringBuilder(32);
            keyBuilder.append(url.getHost()).append(DELIM).append(url.getPort());
            key = keyBuilder.toString();
        }
        return key;
    }

    public int getMaxConnectionsPerHost() {
        return this.maxConnectionsPerHost;
    }

    public void setMaxConnectionsPerHost(int maxConnectionsPerHost) {
        this.maxConnectionsPerHost = maxConnectionsPerHost;
    }

    public int getTotalMaxConnections() {
        return this.totalMaxConnections;
    }

    public void setTotalMaxConnections(int totalMaxConnections) {
        this.totalMaxConnections = totalMaxConnections;
    }

    public int getConnectionTimeout() {
        return this.connectionTimeout;
    }

    public void setConnectionTimeout(int connectionTimeout) {
        this.connectionTimeout = connectionTimeout;
    }
}

