/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.bux.utils.io;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PushbackInputStream;
import java.util.Iterator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MultiPartParser
implements Iterable<InputStream> {
    private Iterator<InputStream> it;

    public MultiPartParser(InputStream is, String boundary) {
        this.it = new MultiPartIterator(is, boundary);
    }

    @Override
    public Iterator<InputStream> iterator() {
        try {
            Iterator<InputStream> iterator = this.it;
            return iterator;
        }
        finally {
            this.it = null;
        }
    }

    class MultiPartInputStream
    extends InputStream {
        private final PushbackInputStream is;
        private final byte[] boundary;

        MultiPartInputStream(PushbackInputStream is, byte[] boundary) {
            this.is = is;
            this.boundary = boundary;
        }

        public int read() throws IOException {
            int c = this.is.read();
            if (c == 45) {
                int i = 1;
                while (i < this.boundary.length) {
                    c = this.is.read();
                    if (c != this.boundary[i]) {
                        this.is.unread(c);
                        this.is.unread(this.boundary, 1, i - 1);
                        return 45;
                    }
                    ++i;
                }
                this.is.unread(this.boundary);
                c = -1;
            }
            return c;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class MultiPartIterator
    implements Iterator<InputStream> {
        private final PushbackInputStream is;
        private final byte[] boundary;

        MultiPartIterator(InputStream is, String boundary) {
            this.boundary = new StringBuilder(boundary.length() + 2).append('-').append('-').append(boundary.trim()).toString().getBytes();
            this.is = new PushbackInputStream(new BufferedInputStream(is), this.boundary.length);
        }

        @Override
        public boolean hasNext() {
            try {
                return this.readMarker();
            }
            catch (IOException iOException) {
                return false;
            }
        }

        @Override
        public InputStream next() {
            return new MultiPartInputStream(this.is, this.boundary);
        }

        /*
         * Unable to fully structure code
         */
        private boolean readMarker() throws IOException {
            block7: {
                block8: {
                    block6: {
                        c = this.is.read();
                        ** GOTO lbl15
                        {
                            c = this.is.read();
                            block1: while (true) {
                                if (c != 45 && c != -1) continue block0;
                                var5_5 = this.boundary;
                                var4_4 = this.boundary.length;
                                var3_3 = 0;
                                while (var3_3 < var4_4) {
                                    b = var5_5[var3_3];
                                    if (c != b) continue block1;
                                    c = this.is.read();
                                    ++var3_3;
                                    continue;
lbl15:
                                    // 2 sources

                                    if (c != -1) continue block1;
                                }
                                break block0;
                                break;
                            }
                        }
                        if (c == -1) {
                            return false;
                        }
                        if (c != 13) break block6;
                        c = this.is.read();
                        if (c != 10) {
                            this.is.unread(c);
                        }
                        break block7;
                    }
                    if (c != 45) break block8;
                    c = this.is.read();
                    if (c == 45) ** GOTO lbl30
                    this.is.unread(c);
                    break block7;
lbl-1000:
                    // 1 sources

                    {
                        c = this.is.read();
lbl30:
                        // 2 sources

                        ** while (c != -1)
                    }
lbl31:
                    // 1 sources

                    return false;
                }
                this.is.unread(c);
            }
            return true;
        }

        @Override
        public void remove() {
        }
    }
}

