/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.bux.utils.io;

import com.ibm.cognos.bux.utils.io.ParameterizedInputStreamResolver;
import com.ibm.cognos.bux.utils.io.SharedByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.SequenceInputStream;

public final class ParameterizedInputStream
extends InputStream {
    private static final int PARAMETER_PREFIX_ASCII = 36;
    private static final String UTF8_ENCODING = "UTF-8";
    private final ParameterizedInputStreamResolver resolver;
    private final SharedByteArrayOutputStream parameterName = new SharedByteArrayOutputStream(32);
    private final InputStream stream;
    private InputStream substitutionStream = null;

    public ParameterizedInputStream(ParameterizedInputStreamResolver resolver, InputStream stream) {
        this.resolver = resolver;
        this.stream = stream;
    }

    public int read() throws IOException {
        int nextByte;
        if (this.substitutionStream != null) {
            nextByte = this.substitutionStream.read();
            if (nextByte == -1) {
                this.substitutionStream = null;
            } else {
                return nextByte;
            }
        }
        if ((nextByte = this.stream.read()) == -1) {
            return -1;
        }
        if (nextByte != 36) {
            return nextByte;
        }
        SharedByteArrayOutputStream paramName = this.parameterName;
        paramName.reset();
        paramName.write(nextByte);
        nextByte = this.stream.read();
        while (ParameterizedInputStream.isAllowableParameterNameChar(nextByte)) {
            paramName.write(nextByte);
            nextByte = this.stream.read();
        }
        InputStream subStream = null;
        if (paramName.size() > 1) {
            subStream = this.resolver.getSubstitutionStream(new String(paramName.getInternalBuffer(), 0, paramName.getInternalBufferSize(), UTF8_ENCODING));
        }
        if (subStream == null) {
            subStream = paramName.toStream();
        }
        this.substitutionStream = new SequenceInputStream(subStream, new SingleByteInputStream(nextByte));
        return this.substitutionStream.read();
    }

    public int read(byte[] b) throws IOException {
        return this.read(b, 0, b.length);
    }

    public int read(byte[] b, int off, int len) throws IOException {
        if (this.substitutionStream == null) {
            return super.read(b, off, len);
        }
        int read = this.substitutionStream.read(b, off, len);
        if (read < 0) {
            this.substitutionStream = null;
            return super.read(b, off, len);
        }
        if (read < len) {
            int additionalRead = super.read(b, off + read, len - read);
            return additionalRead == -1 ? read : read + additionalRead;
        }
        return read;
    }

    private static boolean isAllowableParameterNameChar(int nameChar) {
        return nameChar >= 48 && nameChar <= 57 || nameChar >= 65 && nameChar <= 90 || nameChar >= 97 && nameChar <= 122 || nameChar == 45 || nameChar == 95;
    }

    private static final class SingleByteInputStream
    extends InputStream {
        private int singleByte;

        SingleByteInputStream(int singleByte) {
            this.singleByte = singleByte;
        }

        public int read() throws IOException {
            int result = this.singleByte;
            this.singleByte = -1;
            return result;
        }
    }
}

