/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.bux.utils.io;

import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.OutputStream;

public class RewriterOutputStream
extends FilterOutputStream {
    private final byte[] matchKey;
    private final byte[] replaceKey;
    private int keypos;

    public RewriterOutputStream(OutputStream outputStream, String matchKey, String replaceKey) {
        super(outputStream);
        this.matchKey = matchKey.getBytes();
        this.replaceKey = replaceKey.getBytes();
        this.keypos = 0;
    }

    public void write(int b) throws IOException {
        if (b == this.matchKey[this.keypos]) {
            if (this.matchKey.length == ++this.keypos) {
                byte[] byArray = this.replaceKey;
                int n = this.replaceKey.length;
                int n2 = 0;
                while (n2 < n) {
                    byte element = byArray[n2];
                    super.write(element);
                    ++n2;
                }
                this.keypos = 0;
            }
            return;
        }
        if (this.keypos > 0) {
            this.writePartialKey();
        }
        super.write(b);
    }

    public void flush() throws IOException {
        this.writePartialKey();
        super.flush();
    }

    public void close() throws IOException {
        this.writePartialKey();
        super.close();
    }

    private void writePartialKey() throws IOException {
        int i = 0;
        while (i < this.keypos) {
            super.write(this.matchKey[i]);
            ++i;
        }
        this.keypos = 0;
    }
}

