/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.bux.utils.xml.dom;

import com.ibm.cognos.bux.utils.Messages;
import com.ibm.cognos.bux.utils.io.StringBuilderWriter;
import com.ibm.cognos.bux.utils.xml.dom.TraverseCallback;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Stack;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public final class DomUtils {
    private static final Logger logger = Logger.getLogger(DomUtils.class.getCanonicalName());
    private static DocumentBuilderFactory docBuilderFactory;
    private static Stack<DocumentBuilder> docBuilderPool;
    private static final int docBuilderPoolLimit = 20;

    static {
        docBuilderPool = new Stack();
        docBuilderFactory = DocumentBuilderFactory.newInstance();
        docBuilderFactory.setNamespaceAware(true);
        docBuilderFactory.setValidating(false);
    }

    private DomUtils() {
    }

    private static synchronized DocumentBuilder getDocBuilderFromPool() {
        if (docBuilderPool.empty()) {
            try {
                DocumentBuilder docBuilder = docBuilderFactory.newDocumentBuilder();
                docBuilderPool.push(docBuilder);
            }
            catch (ParserConfigurationException e) {
                logger.log(Level.SEVERE, Messages.DOM_DOCUMENT_BUILDER_ERROR.toString(), e);
                return null;
            }
        }
        return docBuilderPool.pop();
    }

    private static synchronized void returnDocBuilderToPool(DocumentBuilder docBuilder) {
        if (docBuilderPool.size() < 20) {
            docBuilderPool.push(docBuilder);
        }
    }

    public static Document createDocument() {
        DocumentBuilder docBuilder = null;
        Document doc = null;
        try {
            docBuilder = DomUtils.getDocBuilderFromPool();
            doc = docBuilder.newDocument();
        }
        finally {
            DomUtils.returnDocBuilderToPool(docBuilder);
        }
        return doc;
    }

    public static Document parseDocument(String xml) throws SAXException, IOException {
        DocumentBuilder docBuilder = null;
        Document doc = null;
        try {
            docBuilder = DomUtils.getDocBuilderFromPool();
            doc = docBuilder.parse(new InputSource(new StringReader(xml)));
        }
        finally {
            DomUtils.returnDocBuilderToPool(docBuilder);
        }
        return doc;
    }

    public static Document parseDocument(InputStream xml) throws SAXException, IOException {
        DocumentBuilder docBuilder = null;
        Document doc = null;
        try {
            docBuilder = DomUtils.getDocBuilderFromPool();
            doc = docBuilder.parse(new InputSource(xml));
        }
        finally {
            DomUtils.returnDocBuilderToPool(docBuilder);
        }
        return doc;
    }

    public static Element createElementNSWithTextContent(Document doc, String namespace, String localName, String textContent) {
        Element ele = doc.createElementNS(namespace, localName);
        DomUtils.setTextContent(ele, textContent);
        return ele;
    }

    public static TraverseCallback.TraverseState traverse(Node node, TraverseCallback callback) {
        Node next;
        TraverseCallback.TraverseState result = TraverseCallback.TraverseState.continueNormal;
        Node scan = node;
        Node last = scan.getNextSibling();
        block0: do {
            result = callback.handle(scan);
            next = null;
            if (TraverseCallback.TraverseState.continueNormal == result) {
                NamedNodeMap attributes = scan.getAttributes();
                if (attributes != null) {
                    int length = attributes.getLength();
                    int i = 0;
                    while (i < length) {
                        if (TraverseCallback.TraverseState.stop == callback.handle(attributes.item(i))) {
                            return TraverseCallback.TraverseState.stop;
                        }
                        ++i;
                    }
                }
                next = scan.getFirstChild();
            }
            if (next == null) {
                next = scan.getNextSibling();
            }
            while (next == null) {
                if ((scan = scan.getParentNode()) == null) continue block0;
                next = scan.getNextSibling();
            }
        } while (last != (scan = next) && TraverseCallback.TraverseState.stop != result);
        return result;
    }

    public static int hashCode(Element element) {
        HashCodeCallback result = new HashCodeCallback();
        DomUtils.traverse(element, result);
        return result.getHashCodeResult();
    }

    public static boolean equals(Element element1, Element element2) {
        return true;
    }

    public static String getTextContent(Node node) {
        Node firstChild;
        String text = null;
        if (node != null && (firstChild = node.getFirstChild()) != null) {
            text = firstChild.getNodeValue();
        }
        return text;
    }

    public static void setTextContent(Node node, String value) {
        if (node != null) {
            Node child = null;
            while ((child = node.getFirstChild()) != null) {
                node.removeChild(child);
            }
            if (value != null && value.length() > 0) {
                node.appendChild(node.getOwnerDocument().createTextNode(value));
            }
        }
    }

    public static String getLocalName(Element element) {
        int index;
        String name = element.getLocalName();
        if (name == null && (index = (name = element.getNodeName()).indexOf(58)) > 0) {
            name = name.substring(index + 1);
        }
        return name;
    }

    public static Node selectSingleNode(Element element, String localName) {
        if (element != null) {
            NodeList nodes = element.getChildNodes();
            int length = nodes.getLength();
            int i = 0;
            while (i < length) {
                Node node = nodes.item(i);
                if (1 == node.getNodeType() && localName.equals(DomUtils.getLocalName((Element)node))) {
                    return node;
                }
                ++i;
            }
        }
        return null;
    }

    public static NodeList selectNodes(Element element, String localName) {
        final ArrayList<Node> results = new ArrayList<Node>();
        if (element != null) {
            NodeList nodes = element.getChildNodes();
            int length = nodes.getLength();
            int i = 0;
            while (i < length) {
                Node node = nodes.item(i);
                if (1 == node.getNodeType() && localName.equals(DomUtils.getLocalName((Element)node))) {
                    results.add(node);
                }
                ++i;
            }
        }
        return new NodeList(){

            public Node item(int index) {
                return (Node)results.get(index);
            }

            public int getLength() {
                return results.size();
            }
        };
    }

    public static String toString(Node node) {
        StringBuilderWriter out;
        block11: {
            out = new StringBuilderWriter(new StringBuilder());
            try {
                try {
                    TransformerFactory factory = TransformerFactory.newInstance();
                    Transformer transformer = factory.newTransformer();
                    transformer.setOutputProperty("indent", "no");
                    transformer.setOutputProperty("method", "xml");
                    transformer.setOutputProperty("omit-xml-declaration", "yes");
                    DOMSource source = new DOMSource(node);
                    StreamResult result = new StreamResult(out);
                    transformer.transform(source, result);
                }
                catch (TransformerException e) {
                    logger.log(Level.INFO, Messages.DOM_TOSTRING_XSLT_ERROR.toString(), e);
                    try {
                        out.close();
                    }
                    catch (IOException iOException) {}
                    break block11;
                }
            }
            catch (Throwable throwable) {
                try {
                    out.close();
                }
                catch (IOException iOException) {}
                throw throwable;
            }
            try {
                out.close();
            }
            catch (IOException iOException) {}
        }
        return out.toString();
    }

    static class HashCodeCallback
    implements TraverseCallback {
        private transient int hashCode = 0;

        HashCodeCallback() {
        }

        public TraverseCallback.TraverseState handle(Node node) {
            switch (node.getNodeType()) {
                case 1: {
                    Element element = (Element)node;
                    this.hashCode += 17 * this.hashCode + element.getLocalName().hashCode();
                    if (element.getNamespaceURI() == null) break;
                    this.hashCode += 17 * this.hashCode + element.getNamespaceURI().hashCode();
                    break;
                }
                case 2: {
                    Attr attr = (Attr)node;
                    this.hashCode += 17 * this.hashCode + attr.getLocalName().hashCode();
                    this.hashCode += 17 * this.hashCode + (attr.getNamespaceURI() == null ? 0 : attr.getNamespaceURI().hashCode());
                    this.hashCode += 17 * this.hashCode + attr.getValue().hashCode();
                    break;
                }
                case 3: {
                    this.hashCode += 17 * this.hashCode + ((Text)node).getData().hashCode();
                }
            }
            return TraverseCallback.TraverseState.continueNormal;
        }

        public int getHashCodeResult() {
            return this.hashCode;
        }
    }
}

