/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.bux.utils.xml.i18n;

import com.ibm.cognos.bux.i18n.LocaleUtils;
import com.ibm.cognos.bux.utils.xml.i18n.Messages;
import java.util.HashMap;
import java.util.Map;
import java.util.ResourceBundle;

public final class LocalizationManager {
    private final transient Map<String, Messages> msgs = new HashMap<String, Messages>();

    public Messages getMessages(String messageFile, String locale, ClassLoader classLoader) {
        String _locale = LocaleUtils.toNormalizedString((String)locale);
        String key = LocalizationManager.buildKey(messageFile, _locale);
        Messages messages = this.msgs.get(key);
        if (messages == null) {
            ResourceBundle resourceBundle = ResourceBundle.getBundle(messageFile, LocaleUtils.toLocale((String)_locale), classLoader);
            messages = new Messages(resourceBundle);
            this.msgs.put(key, messages);
        }
        return messages;
    }

    private static String buildKey(String messageFile, String locale) {
        return messageFile + '_' + locale;
    }
}

