/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.bux.utils.xml.i18n;

import com.ibm.cognos.bux.utils.EncodingUtils;
import com.ibm.cognos.bux.utils.xml.i18n.Marker;
import com.ibm.cognos.bux.utils.xml.stream.XMLStreamFactory;
import java.util.ArrayList;
import java.util.List;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.events.Attribute;
import javax.xml.stream.events.StartElement;
import javax.xml.stream.events.XMLEvent;
import javax.xml.stream.util.EventReaderDelegate;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class MessagesEventReader
extends EventReaderDelegate {
    private static final QName QN_STRING = new QName("http://developer.cognos.com/schemas/xts/", "string");
    private static final QName QN_PARAM = new QName("http://developer.cognos.com/schemas/xts/", "param");
    private static final QName QN_ID = new QName("", "id");
    private static final QName QN_NAME = new QName("", "name");
    private static final QName QN_INDEX = new QName("", "index");
    private static final QName QN_ENCODE = new QName("", "encode");
    private final List<XMLEvent> pendingEvents = new ArrayList<XMLEvent>();
    private final ResourceBundle resourceBundle;

    MessagesEventReader(XMLEventReader reader, ResourceBundle resourceBundle) {
        super(reader);
        this.resourceBundle = resourceBundle;
    }

    @Override
    public boolean hasNext() {
        if (!this.pendingEvents.isEmpty()) {
            return true;
        }
        return super.hasNext();
    }

    @Override
    public XMLEvent nextEvent() throws XMLStreamException {
        XMLEvent peek;
        if (this.pendingEvents.size() > 0) {
            return this.pendingEvents.remove(this.pendingEvents.size() - 1);
        }
        XMLEvent event = super.nextEvent();
        if (event.isCharacters() && event.asCharacters().isWhiteSpace() && (peek = super.peek()).isStartElement() && QN_STRING.equals(peek.asStartElement().getName())) {
            event = super.nextEvent();
        }
        return this.processEvent(event);
    }

    @Override
    public XMLEvent peek() throws XMLStreamException {
        if (!this.pendingEvents.isEmpty()) {
            return this.pendingEvents.get(this.pendingEvents.size() - 1);
        }
        return super.peek();
    }

    private String buildKey(StartElement element) {
        Attribute name;
        Attribute id = element.getAttributeByName(QN_ID);
        String key = id != null ? id.getValue() : ((name = element.getAttributeByName(QN_NAME)) != null ? name.getValue() : "MSGERR_NOTFOUND;");
        return key;
    }

    private void captureParamEvents(String text) throws XMLStreamException {
        ArrayList<XMLEvent> list = new ArrayList<XMLEvent>();
        this.captureParamEventsInList(list, true);
        int index = this.pendingEvents.indexOf(new Marker(text));
        if (index != -1) {
            this.pendingEvents.remove(index);
            this.pendingEvents.addAll(index, list);
        }
    }

    private void captureParamEventsInList(List<XMLEvent> paramList, boolean removeWhitespace) throws XMLStreamException {
        int level = 0;
        while (super.hasNext()) {
            XMLEvent evt = super.nextEvent();
            if (evt.isStartElement()) {
                ++level;
            } else if (evt.isEndElement()) {
                if (--level < 0) {
                    return;
                }
            } else if (removeWhitespace && evt.isCharacters() && evt.asCharacters().isWhiteSpace()) continue;
            paramList.add(evt);
        }
    }

    private void checkParameters(StartElement element) {
        String text;
        String key = this.buildKey(element);
        try {
            text = this.resourceBundle.getString(key);
        }
        catch (MissingResourceException missingResourceException) {
            text = null;
        }
        if (text == null) {
            this.pendingEvents.add(XMLStreamFactory.getEventFactory().createCharacters(key));
        } else {
            Attribute encode = element.getAttributeByName(QN_ENCODE);
            Encoding encoding = encode == null ? Encoding.None : this.getEncodingType(encode.getValue());
            int startParam = text.indexOf(123);
            int endParam = text.indexOf(125, startParam + 1);
            while (startParam != -1 && endParam != -1) {
                String beforeText = this.encodeText(text.substring(0, startParam), encoding);
                this.pendingEvents.add(XMLStreamFactory.getEventFactory().createCharacters(beforeText));
                String name = text.substring(startParam + 1, endParam);
                this.pendingEvents.add(new Marker(name));
                text = text.substring(endParam + 1);
                startParam = text.indexOf(123);
                endParam = text.indexOf(125, startParam + 1);
            }
            this.pendingEvents.add(XMLStreamFactory.getEventFactory().createCharacters(this.encodeText(text, encoding)));
        }
    }

    private String encodeText(String text, Encoding encoding) {
        String result;
        switch (encoding) {
            case Javascript: {
                result = EncodingUtils.javascriptencode(text, new StringBuilder(text.length())).toString();
                break;
            }
            case Xml: {
                result = EncodingUtils.xmlencode(text, new StringBuilder(text.length())).toString();
                break;
            }
            default: {
                result = text;
            }
        }
        return result;
    }

    private Encoding getEncodingType(String encoding) {
        if ("javascript".equals(encoding)) {
            return Encoding.Javascript;
        }
        if ("xml".equals(encoding)) {
            return Encoding.Xml;
        }
        return Encoding.None;
    }

    private XMLEvent processEvent(XMLEvent event) throws XMLStreamException {
        StartElement startElement;
        if (event.isStartElement() && QN_STRING.equals((startElement = event.asStartElement()).getName())) {
            this.checkParameters(startElement);
            this.processParameters();
            XMLEvent peek = super.peek();
            if (peek.isCharacters() && peek.asCharacters().isWhiteSpace()) {
                super.nextEvent();
            }
            MessagesEventReader.reverse(this.pendingEvents);
            return this.pendingEvents.remove(this.pendingEvents.size() - 1);
        }
        return event;
    }

    private void processParameters() throws XMLStreamException {
        int level = 0;
        while (super.hasNext() && level >= 0) {
            XMLEvent evt = super.nextEvent();
            if (evt.isStartElement()) {
                StartElement startElement = evt.asStartElement();
                if (QN_PARAM.equals(startElement.getName())) {
                    Attribute name = startElement.getAttributeByName(QN_NAME);
                    if (name != null) {
                        this.captureParamEvents(name.getValue());
                        continue;
                    }
                    Attribute indexAttr = startElement.getAttributeByName(QN_INDEX);
                    if (indexAttr != null) {
                        this.captureParamEvents(indexAttr.getValue());
                        continue;
                    }
                    ++level;
                    continue;
                }
                ++level;
                continue;
            }
            if (!evt.isEndElement()) continue;
            --level;
        }
    }

    private static void reverse(List<XMLEvent> list) {
        int loops = list.size() / 2;
        int first = 0;
        int last = list.size() - 1;
        while (first < loops) {
            list.set(last, list.set(first, list.get(last)));
            ++first;
            --last;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum Encoding {
        None,
        Javascript,
        Xml;

    }
}

