/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.bux.utils.xml.stream;

import com.ibm.cognos.bux.utils.xml.stream.BaseStreamReaderDelegate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Stack;
import java.util.StringTokenizer;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;

public class PathIterator
extends BaseStreamReaderDelegate {
    protected static final String ANY_ELEMENT = "*";
    private PathSpec pathSpec;
    private Node currentNode;
    private boolean bStopMatching;
    private int outOfScopeLevel;
    private boolean isFinished;
    private boolean isReportEndElement = false;
    private Stack<IntegerHolder> scopes;
    private int level;

    public static PathSpec compileSpec(Path[] pathArray) {
        return new PathSpec(pathArray);
    }

    public static PathSpec compileSpec(String[] pathArray) {
        int length = pathArray.length;
        Path[] paths = new Path[length];
        int i = 0;
        while (i < paths.length) {
            paths[i] = new Path(i, pathArray[i]);
            ++i;
        }
        return PathIterator.compileSpec(paths);
    }

    public PathIterator() {
        super(null);
    }

    public PathIterator(XMLStreamReader reader, PathSpec pathSpec) {
        this();
        this.setup(reader, pathSpec);
    }

    public void setup(XMLStreamReader reader, PathSpec pathSpec) {
        this.setParent(reader);
        this.pathSpec = pathSpec;
        this.bStopMatching = false;
        this.isFinished = false;
        this.outOfScopeLevel = 0;
        if (reader.isStartElement()) {
            this.currentNode = pathSpec.getMatch(this.getLocalName());
            this.level = 1;
        } else {
            this.level = 0;
        }
        this.scopes = new Stack();
    }

    public String getAttributeValue(String nsURI, String name) {
        return super.getAttributeValue(nsURI, name);
    }

    public String getLocalName() {
        return super.getLocalName();
    }

    private void increaseLevel() {
        ++this.level;
        if (this.scopes != null && this.scopes.size() > 0) {
            ++this.scopes.peek().value;
        }
    }

    private void decreaseLevel() {
        --this.level;
        if (this.scopes != null && this.scopes.size() > 0) {
            --this.scopes.peek().value;
        }
    }

    private int getCurrentScopeLevel() {
        int aLevel = this.scopes != null && this.scopes.size() > 0 ? this.scopes.peek().value : this.level;
        return aLevel;
    }

    public void setReportEndElement(boolean isEnabled) {
        this.isReportEndElement = isEnabled;
    }

    public int moveToNextPath() throws XMLStreamException {
        block4: while (this.hasNext()) {
            int _event = this.next();
            switch (_event) {
                case 1: {
                    if (this.outOfScopeLevel != 0 || this.currentNode == null || !this.currentNode.isMatch()) continue block4;
                    return this.currentNode.getId();
                }
                case 2: {
                    if (this.isReportEndElement && this.outOfScopeLevel == 0 && this.currentNode != null && this.currentNode.isMatch()) {
                        return this.currentNode.getId();
                    }
                    if (this.getCurrentScopeLevel() >= 0) break;
                    return -1;
                }
            }
        }
        return -1;
    }

    public void markScope() {
        this.scopes.push(new IntegerHolder(0));
    }

    public void resetScope() {
        if (this.scopes.size() > 0) {
            IntegerHolder scope = this.scopes.pop();
            if (this.scopes.size() > 0) {
                this.scopes.peek().value += scope.value;
            }
        }
    }

    public boolean moveToPath(int id) throws XMLStreamException {
        block4: while (this.hasNext()) {
            int _event = this.next();
            switch (_event) {
                case 1: {
                    if (this.outOfScopeLevel != 0 || this.currentNode == null || !this.currentNode.isMatch() || this.currentNode.getId() != id) continue block4;
                    return true;
                }
                case 2: {
                    if (this.isReportEndElement && this.outOfScopeLevel == 0 && this.currentNode != null && this.currentNode.isMatch() && this.currentNode.getId() == id) {
                        return true;
                    }
                    if (this.getCurrentScopeLevel() >= 0) break;
                    return false;
                }
            }
        }
        return false;
    }

    public boolean hasNext() throws XMLStreamException {
        return !this.isFinished && super.hasNext();
    }

    public int next() throws XMLStreamException {
        if (!this.bStopMatching && this.isEndElement()) {
            if (this.outOfScopeLevel > 0) {
                --this.outOfScopeLevel;
            } else if (this.currentNode != null) {
                this.currentNode = this.currentNode.getParentNode();
            }
        }
        return this.handleEvent(super.next());
    }

    private int handleEvent(int event) {
        if (event == 1) {
            if (!this.bStopMatching) {
                if (this.currentNode == null) {
                    this.currentNode = this.pathSpec.getMatch(this.getLocalName());
                    if (this.currentNode == null) {
                        this.bStopMatching = true;
                    }
                } else if (this.outOfScopeLevel > 0) {
                    ++this.outOfScopeLevel;
                } else {
                    Node node = this.currentNode.getNode(this.getLocalName());
                    if (node != null) {
                        this.currentNode = node;
                    } else {
                        ++this.outOfScopeLevel;
                    }
                }
            }
            this.increaseLevel();
        } else if (event == 2) {
            this.decreaseLevel();
            if (this.level <= 0) {
                this.isFinished = true;
            }
        }
        return event;
    }

    private static class IntegerHolder {
        protected int value;

        IntegerHolder(int value) {
            this.value = value;
        }
    }

    private static class Node {
        protected String name;
        private int id;
        private List<Node> nodes;
        private Node parentNode;
        private boolean isMatch = false;
        private Node anyNode;

        protected Node(String name) {
            this.name = name;
            this.parentNode = null;
        }

        void setIsMatch(boolean isMatch) {
            this.isMatch = isMatch;
        }

        void setMatchId(int id) {
            this.id = id;
        }

        Node getParentNode() {
            return this.parentNode;
        }

        void addNode(Node node) {
            if (this.nodes == null) {
                this.nodes = new ArrayList<Node>();
            }
            this.nodes.add(node);
            node.parentNode = this;
        }

        Node getNode(String theName) {
            return this.getNode(theName, true);
        }

        Node getNode(String theName, boolean searchAnyNode) {
            Node node = null;
            Node starNode = null;
            if (this.nodes != null) {
                for (Node aNode : this.nodes) {
                    if (theName.equals(aNode.name)) {
                        node = aNode;
                        break;
                    }
                    if (!PathIterator.ANY_ELEMENT.equals(aNode.name)) continue;
                    starNode = aNode;
                }
            }
            if (searchAnyNode && node == null && (node = starNode) == null && this.anyNode != null) {
                node = this.anyNode.getNode(theName);
            }
            return node;
        }

        void setAnyNode(Node anyNode) {
            this.anyNode = anyNode;
        }

        public String toString() {
            return this.name;
        }

        boolean isMatch() {
            return this.isMatch || this.anyNode != null && this.anyNode.isMatch;
        }

        int getId() {
            int anId = !this.isMatch && this.anyNode != null && this.anyNode.isMatch ? this.anyNode.id : this.id;
            return anId;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Path
    implements Comparable<Path> {
        protected int id;
        protected String value;

        public Path(int id, String value) {
            this.id = id;
            this.value = value;
        }

        @Override
        public int compareTo(Path o) {
            return this.value.compareTo(o.value);
        }
    }

    public static class PathSpec {
        private List<Node> nodes;

        protected PathSpec(Path[] pathArray) {
            this.compile(pathArray);
        }

        private void compile(Path[] pathArray) {
            this.nodes = new ArrayList<Node>();
            int length = pathArray.length;
            Arrays.sort(pathArray, 0, pathArray.length);
            int i = 0;
            while (i < length) {
                Path path = pathArray[i];
                StringTokenizer tokens = new StringTokenizer(path.value, "/");
                String token = tokens.nextToken();
                Node node = this.getMatch(token);
                if (node == null) {
                    node = new Node(token);
                    this.nodes.add(node);
                }
                while (tokens.hasMoreTokens()) {
                    token = tokens.nextToken();
                    Node newNode = node.getNode(token, false);
                    if (newNode == null) {
                        Node anyNode = node.getNode(token, true);
                        newNode = new Node(token);
                        node.addNode(newNode);
                        newNode.setAnyNode(anyNode);
                    }
                    node = newNode;
                }
                node.setIsMatch(true);
                node.setMatchId(path.id);
                ++i;
            }
        }

        protected Node getMatch(String name) {
            Node node = null;
            for (Node aNode : this.nodes) {
                if (!name.equals(aNode.name)) continue;
                node = aNode;
                break;
            }
            return node;
        }
    }
}

