/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.bux.utils.xml.stream;

import com.ibm.cognos.bux.utils.Messages;
import com.ibm.cognos.bux.utils.xml.stream.XMLStreamFactory;
import java.io.StringWriter;
import javax.xml.namespace.NamespaceContext;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamConstants;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;
import org.w3c.dom.Attr;
import org.w3c.dom.CDATASection;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;

public final class StaxUtils
implements XMLStreamConstants {
    private StaxUtils() {
    }

    public static boolean moveToElement(XMLStreamReader reader, String localName) throws XMLStreamException {
        int event = reader.next();
        while (event != 8) {
            if (event == 1 && reader.getLocalName().equals(localName)) {
                return true;
            }
            event = reader.next();
        }
        return false;
    }

    public static void moveToNextSibling(XMLStreamReader xsr) throws XMLStreamException {
        int level = 1;
        while (true) {
            int type;
            if ((type = xsr.next()) == 1) {
                ++level;
                continue;
            }
            if (type == 2 && --level == 0) break;
        }
    }

    public static void writeTextElement(XMLStreamWriter xsw, String localName, String text) throws XMLStreamException {
        if (text == null) {
            xsw.writeEmptyElement(localName);
        } else {
            xsw.writeStartElement(localName);
            xsw.writeCharacters(text);
            xsw.writeEndElement();
        }
    }

    public static void writeTextElement(XMLStreamWriter xsw, String namespaceURI, String localName, String prefix, String text) throws XMLStreamException {
        if (text == null) {
            StaxUtils.writeStartElementNS(xsw, namespaceURI, localName, prefix);
            xsw.writeEndElement();
        } else {
            StaxUtils.writeStartElementNS(xsw, namespaceURI, localName, prefix);
            xsw.writeCharacters(text);
            xsw.writeEndElement();
        }
    }

    public static void copyElement(XMLStreamReader xsr, XMLStreamWriter xsw) throws XMLStreamException {
        int level = 0;
        int event = xsr.getEventType();
        while (true) {
            switch (event) {
                case 1: {
                    StaxUtils.writeStartElementNS(xsw, xsr.getNamespaceURI(), xsr.getLocalName(), xsr.getPrefix());
                    int namspaceCount = xsr.getNamespaceCount();
                    int i = 0;
                    while (i < namspaceCount) {
                        StaxUtils.writeNamespaceNS(xsw, xsr.getNamespaceURI(i), xsr.getNamespacePrefix(i));
                        ++i;
                    }
                    int attrCount = xsr.getAttributeCount();
                    int i2 = 0;
                    while (i2 < attrCount) {
                        StaxUtils.writeAttributeNS(xsw, xsr.getAttributeNamespace(i2), xsr.getAttributeLocalName(i2), xsr.getAttributePrefix(i2), xsr.getAttributeValue(i2));
                        ++i2;
                    }
                    ++level;
                    break;
                }
                case 2: {
                    xsw.writeEndElement();
                    if (--level != 0) break;
                    xsw.flush();
                    return;
                }
                case 4: {
                    xsw.writeCharacters(xsr.getText());
                    break;
                }
                case 12: {
                    xsw.writeCData(xsr.getText());
                }
            }
            if (!xsr.hasNext()) break;
            event = xsr.next();
        }
        xsw.flush();
    }

    public static void copyElementNS(XMLStreamReader xsr, XMLStreamWriter xsw) throws XMLStreamException {
        int level = 0;
        int event = xsr.getEventType();
        while (true) {
            switch (event) {
                case 1: {
                    StaxUtils.writeStartElementNS(xsw, xsr.getNamespaceURI(), xsr.getLocalName(), xsr.getPrefix());
                    int namspaceCount = xsr.getNamespaceCount();
                    int i = 0;
                    while (i < namspaceCount) {
                        StaxUtils.writeNamespaceNS(xsw, xsr.getNamespaceURI(i), xsr.getNamespacePrefix(i));
                        ++i;
                    }
                    int attrCount = xsr.getAttributeCount();
                    int i2 = 0;
                    while (i2 < attrCount) {
                        String prefix;
                        String nsURI;
                        String attributeValue = xsr.getAttributeValue(i2);
                        int prefixSep = attributeValue.indexOf(58);
                        if (prefixSep > 1 && (nsURI = xsr.getNamespaceURI(prefix = attributeValue.substring(0, prefixSep))) != null) {
                            StaxUtils.writeNamespaceNS(xsw, nsURI, prefix);
                        }
                        StaxUtils.writeAttributeNS(xsw, xsr.getAttributeNamespace(i2), xsr.getAttributeLocalName(i2), xsr.getAttributePrefix(i2), attributeValue);
                        ++i2;
                    }
                    ++level;
                    break;
                }
                case 2: {
                    xsw.writeEndElement();
                    if (--level != 0) break;
                    xsw.flush();
                    return;
                }
                case 4: {
                    xsw.writeCharacters(xsr.getText());
                    break;
                }
                case 12: {
                    xsw.writeCData(xsr.getText());
                }
            }
            if (!xsr.hasNext()) break;
            event = xsr.next();
        }
        xsw.flush();
    }

    public static void copyElement(Element element, XMLStreamWriter xsw) throws XMLStreamException {
        int index;
        String localName = element.getLocalName();
        if (localName == null && (index = (localName = element.getNodeName()).indexOf(58)) != -1) {
            localName = localName.substring(index + 1);
        }
        StaxUtils.writeStartElementNS(xsw, element.getNamespaceURI(), localName, element.getPrefix());
        NamedNodeMap attribs = element.getAttributes();
        int length = attribs.getLength();
        int i = 0;
        while (i < length) {
            Attr attr;
            Node node = attribs.item(i);
            if (node.getNodeType() == 2 && (attr = (Attr)node).getName().indexOf("xmlns") != 0) {
                StaxUtils.writeAttributeNS(xsw, attr.getNamespaceURI(), attr.getLocalName(), attr.getPrefix(), attr.getNodeValue());
            }
            ++i;
        }
        NodeList nodes = element.getChildNodes();
        length = nodes.getLength();
        int i2 = 0;
        while (i2 < length) {
            Node node = nodes.item(i2);
            switch (node.getNodeType()) {
                case 1: {
                    StaxUtils.copyElement((Element)node, xsw);
                    break;
                }
                case 3: {
                    xsw.writeCharacters(((Text)node).getData());
                    break;
                }
                case 4: {
                    xsw.writeCData(((CDATASection)node).getData());
                }
            }
            ++i2;
        }
        xsw.writeEndElement();
    }

    public static void copyChildren(XMLStreamReader xsr, XMLStreamWriter xsw) throws XMLStreamException {
        while (xsr.hasNext()) {
            int event = xsr.next();
            switch (event) {
                case 1: {
                    StaxUtils.copyElement(xsr, xsw);
                    break;
                }
                case 2: {
                    return;
                }
            }
        }
    }

    public static void toString(XMLStreamReader xsr, StringBuilder buffer) throws XMLStreamException {
        XMLStreamWriter xsw = null;
        try {
            StringWriter writer = new StringWriter();
            xsw = XMLStreamFactory.createXMLStreamWriter(writer);
            StaxUtils.copyElement(xsr, xsw);
            xsw.flush();
            buffer.append(writer.getBuffer());
        }
        finally {
            if (xsw != null) {
                xsw.close();
            }
        }
    }

    public static Element toElement(XMLStreamReader xsr, Document doc) throws XMLStreamException {
        Node parentNode = null;
        Element result = null;
        int level = 0;
        int event = xsr.getEventType();
        if (event == 7) {
            event = xsr.nextTag();
        }
        if (event != 1) {
            throw new XMLStreamException(Messages.INVALID_START_ELEMENT_ERROR.format(new Object[]{event}));
        }
        do {
            block18: {
                block19: {
                    block17: {
                        if (1 != event) break block17;
                        ++level;
                        String nsURI = xsr.getNamespaceURI();
                        if (nsURI == null) {
                            nsURI = "";
                        }
                        QName qName = xsr.getName();
                        String localName = qName.getLocalPart();
                        String prefix = qName.getPrefix();
                        if (prefix != null && prefix.length() > 0) {
                            localName = String.valueOf(prefix) + ":" + localName;
                        }
                        Element element = doc.createElementNS(nsURI, localName);
                        if (parentNode != null) {
                            parentNode.appendChild(element);
                        } else {
                            result = element;
                        }
                        int count = xsr.getAttributeCount();
                        int i = 0;
                        while (i < count) {
                            nsURI = xsr.getAttributeNamespace(i);
                            if (nsURI == null) {
                                nsURI = "";
                            }
                            localName = xsr.getAttributeLocalName(i);
                            prefix = xsr.getAttributePrefix(i);
                            if (prefix != null && prefix.length() > 0) {
                                localName = String.valueOf(prefix) + ":" + localName;
                            }
                            element.setAttributeNS(xsr.getAttributeNamespace(i), localName, xsr.getAttributeValue(i));
                            ++i;
                        }
                        parentNode = element;
                        break block18;
                    }
                    if (parentNode == null) break block19;
                    switch (event) {
                        case 2: {
                            parentNode = parentNode.getParentNode();
                            --level;
                            break block18;
                        }
                        case 4: {
                            if (!StaxUtils.isWhiteSpace(xsr)) {
                                Text text = doc.createTextNode(xsr.getText());
                                parentNode.appendChild(text);
                            }
                            break block18;
                        }
                        case 12: {
                            parentNode.appendChild(doc.createCDATASection(xsr.getText()));
                            break block18;
                        }
                        case 5: {
                            parentNode.appendChild(doc.createComment(xsr.getText()));
                            break block18;
                        }
                        default: {
                            throw new XMLStreamException(Messages.STAX_EVENT_PROCESSING_ERROR.format(new Object[]{event}));
                        }
                    }
                }
                throw new XMLStreamException(Messages.STAX_EVENT_MISSING_START_ERROR.toString());
            }
            if (level == 0) continue;
            event = xsr.next();
        } while (level != 0);
        return result;
    }

    public static String tokenTypeDesc(int type) {
        switch (type) {
            case 1: {
                return "START_ELEMENT";
            }
            case 2: {
                return "END_ELEMENT";
            }
            case 7: {
                return "START_DOCUMENT";
            }
            case 8: {
                return "END_DOCUMENT";
            }
            case 4: {
                return "CHARACTERS";
            }
            case 12: {
                return "CDATA";
            }
            case 6: {
                return "SPACE";
            }
            case 5: {
                return "COMMENT";
            }
            case 3: {
                return "PROCESSING_INSTRUCTION";
            }
            case 11: {
                return "DTD";
            }
            case 9: {
                return "ENTITY_REFERENCE";
            }
        }
        return "[" + type + "]";
    }

    public static void writeStartElementNS(XMLStreamWriter xsw, String nsURI, String localName, String prefix) throws XMLStreamException {
        StaxUtils.writeStartElementNS(xsw, nsURI, localName, prefix, false);
    }

    public static void writeStartElementNS(XMLStreamWriter xsw, String nsURI, String localName, String prefix, boolean isEmpty) throws XMLStreamException {
        NamespaceContext namespaceContext = xsw.getNamespaceContext();
        if (prefix == null) {
            if (isEmpty) {
                xsw.writeEmptyElement(localName);
            } else {
                xsw.writeStartElement(localName);
            }
            String namespace = nsURI == null ? "" : nsURI;
            String defaultNS = namespaceContext.getNamespaceURI("");
            if (!defaultNS.equals(namespace) && !namespace.equals("")) {
                xsw.writeDefaultNamespace(namespace);
            }
        } else {
            String foundNS = namespaceContext.getNamespaceURI(prefix);
            if (foundNS == null || !foundNS.equals(nsURI)) {
                if (isEmpty) {
                    xsw.writeEmptyElement(prefix, localName, nsURI);
                } else {
                    xsw.writeStartElement(prefix, localName, nsURI);
                }
                if (!nsURI.equals("")) {
                    xsw.writeNamespace(prefix, nsURI);
                }
            } else if (isEmpty) {
                xsw.writeEmptyElement(nsURI, localName);
            } else {
                xsw.writeStartElement(nsURI, localName);
            }
        }
    }

    public static void writeAttributeNS(XMLStreamWriter xsw, String nsURI, String localName, String prefix, String value) throws XMLStreamException {
        if (prefix == null) {
            xsw.writeAttribute(localName, value);
        } else {
            if (xsw.getNamespaceContext().getPrefix(prefix) == null) {
                StaxUtils.writeNamespaceNS(xsw, nsURI, prefix);
            }
            xsw.writeAttribute(prefix, nsURI, localName, value);
        }
    }

    public static void writeNamespaceNS(XMLStreamWriter xsw, String nsURI, String prefix) throws XMLStreamException {
        if (nsURI != null) {
            NamespaceContext namespaceContext = xsw.getNamespaceContext();
            if (prefix == null) {
                String nsFoundNS = namespaceContext.getNamespaceURI("");
                if (nsFoundNS == null || !nsFoundNS.equals(nsURI)) {
                    xsw.writeNamespace("", nsURI);
                }
            } else {
                String nsFoundNS = namespaceContext.getNamespaceURI(prefix);
                if (!("".equals(prefix) || nsFoundNS != null && nsFoundNS.equals(nsURI))) {
                    xsw.writeNamespace(prefix, nsURI);
                    xsw.setPrefix(prefix, nsURI);
                }
            }
        }
    }

    public static boolean isWhiteSpace(XMLStreamReader xsr) {
        return xsr.isCharacters() && xsr.getText().trim().length() == 0;
    }
}

