/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.bux.utils.xml.stream;

import com.ibm.cognos.bux.utils.Messages;
import com.ibm.cognos.bux.utils.xml.stream.StaxUtils;
import com.ibm.cognos.bux.utils.xml.stream.XMLStreamFactory;
import java.util.Stack;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.util.StreamReaderDelegate;
import javax.xml.transform.Source;
import javax.xml.transform.TransformerException;
import javax.xml.transform.URIResolver;

public class XIncludeStreamReader
extends StreamReaderDelegate {
    private static final QName Q_XINCLUDE = new QName("http://www.w3.org/2001/XInclude", "include");
    private final transient URIResolver uriResolver;
    private final transient Stack<XMLStreamReader> stack = new Stack();

    public XIncludeStreamReader(XMLStreamReader reader, URIResolver uriResolver) {
        super(reader);
        this.uriResolver = uriResolver;
    }

    public int next() throws XMLStreamException {
        int next = super.next();
        switch (next) {
            case 1: {
                if (!Q_XINCLUDE.equals(this.getName())) break;
                next = this.startElementXInclude(this.getParent());
                break;
            }
            case 8: {
                if (this.stack.size() <= 0) break;
                next = this.endElementXInclude(this.getParent());
                break;
            }
        }
        return next;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public int nextTag() throws XMLStreamException {
        int next;
        block5: while (true) {
            next = this.next();
            switch (next) {
                case 3: 
                case 5: 
                case 6: {
                    continue block5;
                }
                case 4: 
                case 12: {
                    if (!StaxUtils.isWhiteSpace(this)) throw new XMLStreamException(Messages.XINCLUDE_TAG_ERROR1.toString(), this.getLocation());
                    continue block5;
                }
                case 1: 
                case 2: {
                    return next;
                }
            }
            break;
        }
        throw new XMLStreamException(Messages.XINCLUDE_TAG_ERROR2.format(new Object[]{StaxUtils.tokenTypeDesc(next)}), this.getLocation());
    }

    private int startElementXInclude(XMLStreamReader xsr) throws XMLStreamException {
        String href = xsr.getAttributeValue("", "href");
        try {
            StaxUtils.moveToNextSibling(xsr);
            this.stack.push(xsr);
            Source source = this.uriResolver.resolve(href, xsr.getLocation().getSystemId());
            XMLStreamReader _xsr = XMLStreamFactory.createXMLStreamReader(source);
            int next = _xsr.getEventType();
            if (7 == next) {
                next = _xsr.next();
            }
            this.setParent(_xsr);
            return next;
        }
        catch (TransformerException e) {
            throw new XMLStreamException(Messages.XINCLUDE_RESOLVE_ERROR.format(new Object[]{href}), xsr.getLocation(), e);
        }
    }

    private int endElementXInclude(XMLStreamReader xsr) throws XMLStreamException {
        xsr.close();
        XMLStreamReader _xsr = this.stack.pop();
        int next = _xsr.next();
        this.setParent(_xsr);
        return next;
    }
}

