<?xml version="1.0" encoding="UTF-8"?>
<!--
 +========================================================================+
 | IBM Confidential
 | OCO Source Materials
 | IBM Cognos Products: BUX
 | (C) Copyright IBM Corp. 2009, 2013
 |
 | The source code for this program is not published or otherwise
 | divested of its trade secrets, irrespective of what has been deposited
 | with the U.S. Copyright Office.
 +========================================================================+
-->
<xsl:stylesheet version="1.0"
	xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
	xmlns:helper="com.ibm.cognos.bux.platform.helpers.XsltHelpers"
	extension-element-prefixes="helper">
	<xsl:output method="text" version="1.0" encoding="UTF-8" indent="no"/>
	<xsl:param name="prefixes" select="'atom'"/>
	<xsl:param name="exclude-prefixes" select="concat(' ', $prefixes, ' ')"/>
	<xsl:param name="include-lang" select="true()"/>
	<xsl:param name="tagsAsStrings" select="''"/>
	<xsl:template match="/">
		<xsl:apply-templates select="*|@*" mode="json"/>
	</xsl:template>

	<xsl:template name="processArray">
		<xsl:param name="currentnode"/>
		<xsl:param name="localname"/>
		<xsl:param name="name"/>
		<xsl:param name="ns"/>

		<xsl:apply-templates select="." mode="label"/>
		<xsl:text>[</xsl:text>
		<xsl:for-each select="$currentnode/../*[local-name() = $localname and namespace-uri() = $ns]">
			<xsl:if test="position() &gt; 1">,</xsl:if>
			<xsl:apply-templates mode="processChildren" select="."/>
		</xsl:for-each>
		<xsl:text>]</xsl:text>

	</xsl:template>

	<xsl:template match="*|@*|text()" mode="json">
		<xsl:variable name="this-node" select="local-name()"/>
		<xsl:variable name="this-ns" select="namespace-uri()"/>
		<xsl:variable name="precedings" select="preceding-sibling::*[local-name() = $this-node and namespace-uri() = $this-ns]"/>
		<xsl:variable name="followings" select="following-sibling::*[local-name() = $this-node and namespace-uri() = $this-ns]"/>

		<xsl:if test="not($precedings)">
			<xsl:if test="position() &gt; 1">,</xsl:if>
			<xsl:if test="position() = 1">{</xsl:if>

			<xsl:if test="$followings">
				<xsl:call-template name="processArray">
					<xsl:with-param name="currentnode" select="." />
					<xsl:with-param name="localname" select="$this-node" />
					<xsl:with-param name="name" select="name()" />
					<xsl:with-param name="ns" select="$this-ns" />
				</xsl:call-template>
			</xsl:if>

			<xsl:if test="not($followings)">
				<xsl:apply-templates select="." mode="label"/>
				<xsl:apply-templates select="." mode="processChildren"/>
			</xsl:if>
		</xsl:if>
		<xsl:if test="position() = last()">}</xsl:if>
	</xsl:template>

	<xsl:template match="*|@*|text()" mode="label">
		<xsl:text>&quot;</xsl:text>
		<xsl:choose>
			<xsl:when test="name() != '' and not(contains($exclude-prefixes, concat(' ', substring-before(name(), ':'), ' ')))">
				<xsl:value-of select="translate(name(),':','$')"/>
			</xsl:when>
			<xsl:when test="local-name() != ''">
				<xsl:value-of select="local-name()"/>
			</xsl:when>
			<xsl:otherwise>_text</xsl:otherwise>
		</xsl:choose>
		<xsl:text>&quot;:</xsl:text>
	</xsl:template>

	<xsl:template match="*|@*|text()" mode="processChildren">
		<xsl:choose>
			<xsl:when test="*">
				<xsl:apply-templates select="*|@*" mode="json"/>
			</xsl:when>
			<xsl:when test="@*[$include-lang or namespace-uri()!='http://www.w3.org/XML/1998/namespace']">
				<xsl:apply-templates select="@*|text()" mode="json"/>
			</xsl:when>
			<xsl:otherwise>
				<xsl:choose>
					<xsl:when test="not(contains($tagsAsStrings,concat(',', local-name(parent::node()) ,','))) and (.='true' or .='false' or string(number(.))!='NaN')">
						<xsl:value-of select="."/>
					</xsl:when>
					<xsl:otherwise>
						<xsl:value-of select="concat('&quot;', helper:javascriptencode(string(.)), '&quot;')"/>
					</xsl:otherwise>
				</xsl:choose>
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>

	<xsl:template match="text()"/>
</xsl:stylesheet>
