/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.bux;

import com.ibm.cognos.bux.BUXBundleActivator;
import com.ibm.cognos.bux.BUXControllerInfo;
import com.ibm.cognos.bux.config.BiBusConfiguration;
import com.ibm.cognos.bux.config.ConfigurationServiceTrackerCustomizer;
import com.ibm.cognos.bux.content.AtomContentType;
import com.ibm.cognos.bux.content.DhtmlContentType;
import com.ibm.cognos.bux.content.HtmlContentType;
import com.ibm.cognos.bux.content.XmlContentType;
import com.ibm.cognos.bux.http.HttpClientFactory;
import com.ibm.cognos.bux.http.HttpClientServiceTrackerCustomizer;
import com.ibm.cognos.bux.validator.BiBusValidatorFactory;
import com.ibm.cognos.bux.validator.ValidatorServiceTrackerCustomizer;
import org.osgi.framework.BundleContext;
import org.osgi.util.tracker.ServiceTracker;
import org.osgi.util.tracker.ServiceTrackerCustomizer;

public class Activator
extends BUXBundleActivator {
    private ServiceTracker configurationServiceTracker;
    private ServiceTracker validatorServiceTracker;
    private ServiceTracker httpClientServiceTracker;

    public void start(BundleContext context) throws Exception {
        ConfigurationServiceTrackerCustomizer configCustomizer = new ConfigurationServiceTrackerCustomizer(context);
        this.configurationServiceTracker = new ServiceTracker(context, BiBusConfiguration.class.getName(), (ServiceTrackerCustomizer)configCustomizer);
        this.configurationServiceTracker.open();
        ValidatorServiceTrackerCustomizer validatorCustomizer = new ValidatorServiceTrackerCustomizer(context);
        this.validatorServiceTracker = new ServiceTracker(context, BiBusValidatorFactory.class.getName(), (ServiceTrackerCustomizer)validatorCustomizer);
        this.validatorServiceTracker.open();
        HttpClientServiceTrackerCustomizer httpClientCustomizer = new HttpClientServiceTrackerCustomizer(context);
        this.httpClientServiceTracker = new ServiceTracker(context, HttpClientFactory.class.getName(), (ServiceTrackerCustomizer)httpClientCustomizer);
        this.httpClientServiceTracker.open();
        this.registerBUXController(context, new BUXControllerInfo());
        this.registerViewType(context, new AtomContentType());
        this.registerViewType(context, new DhtmlContentType());
        this.registerViewType(context, new HtmlContentType());
        this.registerViewType(context, new XmlContentType());
        super.start(context);
    }

    public void stop(BundleContext context) throws Exception {
        if (this.configurationServiceTracker != null) {
            this.configurationServiceTracker.close();
        }
        if (this.validatorServiceTracker != null) {
            this.validatorServiceTracker.close();
        }
        if (this.httpClientServiceTracker != null) {
            this.httpClientServiceTracker.close();
        }
        super.stop(context);
    }
}

