/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.bux;

import com.ibm.cognos.bux.BUXBaseActivator;
import com.ibm.cognos.bux.BUXController;
import com.ibm.cognos.bux.BUXModel;
import com.ibm.cognos.bux.BUXService;
import com.ibm.cognos.bux.BUXView;
import com.ibm.cognos.bux.content.BUXViewType;
import com.ibm.cognos.bux.logging.BUXAuditLogger;
import com.ibm.cognos.bux.logging.BUXAuditLoggerFactory;
import com.ibm.cognos.bux.logging.BUXLogBaseDetails;
import com.ibm.cognos.bux.logging.BUXLogDetails;
import java.util.Collections;
import java.util.Dictionary;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Map;
import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleContext;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceReference;
import org.osgi.framework.ServiceRegistration;
import org.osgi.service.http.HttpService;
import org.osgi.util.tracker.ServiceTracker;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class BUXBundleActivator
extends BUXBaseActivator {
    public static final String MVCTYPE_CONTROL = "control";
    public static final String MVCTYPE_MODEL = "model";
    public static final String MVCTYPE_VIEW = "view";
    protected static final String PARAM_NAME = "Name";
    protected static final String WILDCARD = "*";
    private static final String PARAM_VIEW_TYPE = "ViewType";
    private static final String PARAM_MVCTYPE = "MVCType";
    private static final String PARAM_URL_PATH = "UrlPath";
    private static final String PARAM_MVCCONTROLLER = "MVCController";
    protected static BundleContext myContext;
    protected static Map<BundleActivator, BundleContext> activatorContextMap;
    private ServiceTracker httpServiceTracker;
    protected Map<String, String> webUrlMap;
    private static Map<String, Object> config;

    static {
        config = new HashMap<String, Object>();
    }

    @Override
    public void start(BundleContext context) throws Exception {
        if (activatorContextMap == null) {
            activatorContextMap = new HashMap<BundleActivator, BundleContext>(16);
            myContext = context;
        }
        activatorContextMap.put(this, context);
        this.createContentMapper();
        super.start(context);
    }

    @Override
    public void stop(BundleContext context) throws Exception {
        this.terminateContentMapper();
        super.stop(context);
    }

    public BundleContext getBundleContext() {
        return activatorContextMap.get(this);
    }

    public String getBundleId() {
        return this.getBundleContext().getBundle().getSymbolicName();
    }

    public void registerViewType(BundleContext context, BUXViewType type) {
        Hashtable<String, String> props = new Hashtable<String, String>();
        ((Dictionary)props).put(PARAM_VIEW_TYPE, type.getViewType());
        ServiceRegistration sr = context.registerService(BUXViewType.class.getName(), (Object)type, props);
        type.setBundleReference(context.getBundle());
        type.setServiceReference(sr.getReference());
    }

    protected void registerBUXService(BundleContext context, BUXService service, Dictionary<String, Object> props, Map<String, Object> theConfig) {
        ServiceRegistration sr = context.registerService(BUXService.class.getName(), (Object)service, props);
        service.setBundleReference(context.getBundle());
        service.setServiceReference(sr.getReference());
        service.init(Collections.unmodifiableMap(theConfig));
        BUXLogDetails logDetails = new BUXLogDetails();
        logDetails.setStatus("Success");
        logDetails.setOperation(BUXLogBaseDetails.Operation.BUX_STARTSERVICE);
        HashMap<String, String> logParams = new HashMap<String, String>();
        logParams.put("BUXServiceName", BUXService.class.getName());
        logDetails.setLogDataParameters(logParams);
        logDetails.setObjectPath(BUXService.class.getName());
        logDetails.setObjectType(context.getBundle().getSymbolicName());
        BUXAuditLogger logger = BUXAuditLoggerFactory.getAuditLogger();
        logger.auditLogRequestLevelEvent(logDetails, null);
    }

    protected Map<String, Object> getConfig() {
        return config;
    }

    public void registerBUXModel(BundleContext context, BUXController controller, BUXModel service) {
        Hashtable<String, Object> props = new Hashtable<String, Object>();
        ((Dictionary)props).put(PARAM_NAME, service.getServiceName());
        ((Dictionary)props).put(PARAM_MVCTYPE, MVCTYPE_MODEL);
        ((Dictionary)props).put(PARAM_MVCCONTROLLER, controller.getServiceName());
        this.registerBUXService(context, service, props, this.getConfig());
    }

    public void registerBUXView(BundleContext context, BUXController controller, BUXView service) {
        Hashtable<String, Object> props = new Hashtable<String, Object>();
        ((Dictionary)props).put(PARAM_NAME, service.getServiceName());
        ((Dictionary)props).put(PARAM_MVCTYPE, MVCTYPE_VIEW);
        ((Dictionary)props).put(PARAM_MVCCONTROLLER, controller.getServiceName());
        ((Dictionary)props).put(PARAM_VIEW_TYPE, service.getViewType());
        this.registerBUXService(context, service, props, this.getConfig());
    }

    public void registerBUXController(BundleContext context, BUXController service) {
        Hashtable<String, Object> props = new Hashtable<String, Object>();
        ((Dictionary)props).put(PARAM_URL_PATH, service.getUrlPath());
        ((Dictionary)props).put(PARAM_NAME, service.getServiceName());
        ((Dictionary)props).put(PARAM_MVCTYPE, MVCTYPE_CONTROL);
        this.registerBUXService(context, service, props, this.getConfig());
    }

    public static BUXController getBUXControllerForPathInfo(String path) {
        BUXController result = null;
        ServiceReference[] services = BUXBundleActivator.getBUXControllers(null);
        if (services != null) {
            int bestMatch = -1;
            ServiceReference[] serviceReferenceArray = services;
            int n = services.length;
            int n2 = 0;
            while (n2 < n) {
                ServiceReference service = serviceReferenceArray[n2];
                BUXController buxService = BUXBundleActivator.getControllerForServiceReference(service);
                String urlPath = buxService.getUrlPath();
                if (path.startsWith(urlPath)) {
                    if (urlPath.length() > bestMatch) {
                        result = buxService;
                        bestMatch = urlPath.length();
                    }
                } else {
                    BUXBundleActivator.releaseBUXService(buxService);
                }
                ++n2;
            }
        }
        return result;
    }

    public static void releaseBUXService(BUXService buxService) {
        myContext.ungetService(buxService.getServiceReference());
    }

    public static ServiceReference[] getBUXViewType(String viewTypeSpec) {
        String viewType = viewTypeSpec;
        if (viewType == null || viewType.length() == 0) {
            viewType = WILDCARD;
        }
        StringBuilder filter = new StringBuilder();
        filter.append("(").append(PARAM_VIEW_TYPE).append("=").append(viewType).append(")");
        ServiceReference[] result = null;
        try {
            result = myContext.getServiceReferences(BUXViewType.class.getName(), filter.toString());
        }
        catch (InvalidSyntaxException invalidSyntaxException) {}
        return result;
    }

    public static ServiceReference[] getBUXModels(String controllerName) {
        String controller = controllerName;
        if (controller == null || controller.length() == 0) {
            controller = WILDCARD;
        }
        StringBuilder filter = new StringBuilder();
        filter.append("(&");
        filter.append("(").append(PARAM_MVCTYPE).append("=").append(MVCTYPE_MODEL).append(")");
        filter.append("(").append(PARAM_MVCCONTROLLER).append("=").append(controller).append(")");
        filter.append(")");
        ServiceReference[] result = null;
        try {
            result = myContext.getServiceReferences(BUXService.class.getName(), filter.toString());
        }
        catch (InvalidSyntaxException invalidSyntaxException) {}
        return result;
    }

    public static ServiceReference[] getBUXViews(String controllerName, String viewType) {
        String type;
        String controller = controllerName;
        if (controller == null || controller.length() == 0) {
            controller = WILDCARD;
        }
        if ((type = viewType) == null || type.length() == 0) {
            type = WILDCARD;
        }
        StringBuilder filter = new StringBuilder();
        filter.append("(&");
        filter.append("(").append(PARAM_VIEW_TYPE).append("=").append(type).append(")");
        filter.append("(").append(PARAM_MVCTYPE).append("=").append(MVCTYPE_VIEW).append(")");
        filter.append("(").append(PARAM_MVCCONTROLLER).append("=").append(controller).append(")");
        filter.append(")");
        ServiceReference[] result = null;
        try {
            result = myContext.getServiceReferences(BUXService.class.getName(), filter.toString());
        }
        catch (InvalidSyntaxException invalidSyntaxException) {}
        return result;
    }

    public static ServiceReference[] getBUXControllers(String serviceName) {
        String name = serviceName;
        if (name == null || name.length() == 0) {
            name = WILDCARD;
        }
        StringBuilder filter = new StringBuilder();
        filter.append("(&");
        filter.append("(").append(PARAM_NAME).append("=").append(name).append(")");
        filter.append("(").append(PARAM_MVCTYPE).append("=").append(MVCTYPE_CONTROL).append(")");
        filter.append(")");
        ServiceReference[] result = null;
        try {
            result = myContext.getServiceReferences(BUXService.class.getName(), filter.toString());
        }
        catch (InvalidSyntaxException invalidSyntaxException) {}
        return result;
    }

    public static BUXViewType getViewTypeForServiceReference(ServiceReference sr) {
        Object obj = myContext.getService(sr);
        BUXViewType result = null;
        if (obj instanceof BUXViewType) {
            result = (BUXViewType)obj;
        }
        return result;
    }

    public static BUXView getViewForServiceReference(ServiceReference sr) {
        Object obj = myContext.getService(sr);
        BUXView result = null;
        if (obj instanceof BUXView) {
            result = (BUXView)obj;
        }
        return result;
    }

    public static BUXController getControllerForServiceReference(ServiceReference sr) {
        Object obj = myContext.getService(sr);
        BUXController result = null;
        if (obj instanceof BUXController) {
            result = (BUXController)obj;
        }
        return result;
    }

    public static BUXModel getModelForServiceReference(ServiceReference sr) {
        Object obj = myContext.getService(sr);
        BUXModel result = null;
        if (obj instanceof BUXModel) {
            result = (BUXModel)obj;
        }
        return result;
    }

    public Map<String, String> getMappedWebResources() {
        if (this.webUrlMap == null) {
            this.webUrlMap = new HashMap<String, String>(2);
        }
        return new HashMap<String, String>(this.webUrlMap);
    }

    public void mapWebResource(String webPath, String localPath) {
        if (this.webUrlMap == null) {
            this.webUrlMap = new HashMap<String, String>(2);
        }
        this.webUrlMap.put(webPath, localPath);
    }

    private void createContentMapper() {
        this.httpServiceTracker = new HttpServiceTracker(this.getBundleContext());
        this.httpServiceTracker.open();
    }

    private void terminateContentMapper() {
        if (this.httpServiceTracker != null) {
            this.httpServiceTracker.close();
        }
    }

    private class HttpServiceTracker
    extends ServiceTracker {
        private HttpService httpService;

        public HttpServiceTracker(BundleContext context) {
            super(context, HttpService.class.getName(), null);
        }

        public Object addingService(ServiceReference reference) {
            this.httpService = (HttpService)this.context.getService(reference);
            if (BUXBundleActivator.this.webUrlMap != null) {
                try {
                    for (String webPath : BUXBundleActivator.this.webUrlMap.keySet()) {
                        this.httpService.registerResources(webPath, BUXBundleActivator.this.webUrlMap.get(webPath), null);
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            return this.httpService;
        }

        public void removedService(ServiceReference reference, Object service) {
            if (BUXBundleActivator.this.webUrlMap != null) {
                for (String webPath : BUXBundleActivator.this.webUrlMap.keySet()) {
                    this.httpService.unregister(webPath);
                }
            }
            super.removedService(reference, service);
        }
    }
}

