/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.bux;

import com.ibm.cognos.bux.BUXBundleActivator;
import com.ibm.cognos.bux.BUXController;
import com.ibm.cognos.bux.BUXException;
import com.ibm.cognos.bux.BUXModel;
import com.ibm.cognos.bux.BUXServiceBase;
import com.ibm.cognos.bux.BUXView;
import com.ibm.cognos.bux.Messages;
import com.ibm.cognos.bux.http.RequestInformation;
import com.ibm.cognos.bux.http.ResponseInformation;
import org.osgi.framework.ServiceReference;

public abstract class BUXControllerBaseImpl
extends BUXServiceBase
implements BUXController {
    public abstract String getUrlPath();

    public BUXView getView(String viewType) {
        BUXView result = null;
        ServiceReference[] views = BUXBundleActivator.getBUXViews(this.getServiceName(), viewType);
        if (views != null && views.length > 0) {
            result = BUXBundleActivator.getViewForServiceReference(views[0]);
        }
        return result;
    }

    public BUXModel getModel() {
        BUXModel result = null;
        ServiceReference[] models = BUXBundleActivator.getBUXModels(this.getServiceName());
        if (models != null && models.length > 0) {
            result = BUXBundleActivator.getModelForServiceReference(models[0]);
        }
        return result;
    }

    protected String getViewType(RequestInformation requestInfo) {
        ServiceReference[] sr;
        String viewType = null;
        String[] param = requestInfo.getParameters().get("viewtype");
        if (param != null && param.length > 0 && (sr = BUXBundleActivator.getBUXViewType(param[0])) != null && sr.length > 0) {
            viewType = param[0];
        }
        return viewType;
    }

    public ResponseInformation mvcHandleRequest(RequestInformation requestInfo) {
        BUXView view = null;
        String viewType = this.getViewType(requestInfo);
        if (viewType == null) {
            ServiceReference[] viewRefs;
            view = this.getView("dhtml");
            if (view == null && (viewRefs = BUXBundleActivator.getBUXViews(this.getServiceName(), null)).length > 0) {
                view = BUXBundleActivator.getViewForServiceReference(viewRefs[0]);
            }
        } else {
            view = this.getView(viewType);
        }
        if (view == null) {
            throw new BUXException(Messages.VIEW_NOT_FOUND_ERROR.format(new Object[]{this.getServiceName()}));
        }
        ResponseInformation result = view.handleRequest(requestInfo);
        return result;
    }
}

