/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.bux;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.security.AccessController;
import java.security.PrivilegedAction;
import javax.xml.transform.Source;
import javax.xml.transform.URIResolver;
import javax.xml.transform.stream.StreamSource;
import org.osgi.framework.Bundle;

public class BUXURIResolver
implements URIResolver {
    private Bundle bundle;

    public BUXURIResolver(Bundle bundle) {
        this.bundle = bundle;
    }

    public Source resolve(final String href, final String base) {
        Source retVal;
        if (System.getSecurityManager() != null) {
            PrivilegedAction<Source> action = new PrivilegedAction<Source>(){

                @Override
                public Source run() {
                    return BUXURIResolver.this._resolve(href, base);
                }
            };
            retVal = AccessController.doPrivileged(action);
        } else {
            retVal = this._resolve(href, base);
        }
        return retVal;
    }

    protected Source _resolve(String href, String base) {
        StreamSource source = null;
        try {
            if (base == null) {
                InputStream in;
                URL url = -1 == href.indexOf("://") ? this.bundle.getEntry(href) : new URL(href);
                if (url != null && (in = url.openStream()) != null) {
                    source = new StreamSource(in, url.toExternalForm());
                }
            } else {
                URL baseUrl = new URL(base);
                URL url = new URL(baseUrl, href);
                InputStream in = url.openStream();
                if (in != null) {
                    source = new StreamSource(in, url.toExternalForm());
                }
            }
        }
        catch (IOException iOException) {}
        return source;
    }
}

