/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.bux.http;

import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;

public class RequestCookie {
    private static final String PATH = "path=";
    private static final String DOMAIN = "domain=";
    private static final String EXPIRES = "expires=";
    private static final String SECURE = "secure=";
    private static final String SLASH = "/";
    private String comment;
    private String domain;
    private String name;
    private String path;
    private String value;
    private int maxAge;
    private int version;
    private boolean secure;
    private static final DateFormat[] expiryFormats = new DateFormat[5];

    static {
        RequestCookie.expiryFormats[0] = new SimpleDateFormat("EEE, dd-MMM-yy HH:mm:ss z", Locale.US);
        RequestCookie.expiryFormats[1] = new SimpleDateFormat("EEE, dd-MMM-yyyy HH:mm:ss z", Locale.US);
        RequestCookie.expiryFormats[2] = new SimpleDateFormat("EEE dd-MMM-yy HH:mm:ss z", Locale.US);
        RequestCookie.expiryFormats[3] = new SimpleDateFormat("EEE dd-MMM-yyyy HH:mm:ss z", Locale.US);
        RequestCookie.expiryFormats[4] = new SimpleDateFormat("EEE, dd MMM yyyy HH:mm:ss z", Locale.US);
    }

    public RequestCookie() {
    }

    public RequestCookie(RequestCookie cookie) {
        this.comment = cookie.comment;
        this.domain = cookie.domain;
        this.name = cookie.name;
        this.path = cookie.path;
        this.value = cookie.value;
        this.maxAge = cookie.maxAge;
        this.version = cookie.version;
        this.secure = cookie.secure;
    }

    public String getComment() {
        return this.comment;
    }

    public void setComment(String comment) {
        this.comment = comment;
    }

    public String getDomain() {
        return this.domain;
    }

    public void setDomain(String domain) {
        this.domain = domain;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getPath() {
        return this.path;
    }

    public void setPath(String path) {
        this.path = path;
    }

    public String getValue() {
        return this.value;
    }

    public void setValue(String value) {
        this.value = value;
    }

    public int getMaxAge() {
        return this.maxAge;
    }

    public void setMaxAge(int maxAge) {
        this.maxAge = maxAge;
    }

    public int getVersion() {
        return this.version;
    }

    public void setVersion(int version) {
        this.version = version;
    }

    public boolean isSecure() {
        return this.secure;
    }

    public void setSecure(boolean secure) {
        this.secure = secure;
    }

    public static RequestCookie createOutboundCookie(String[] cookieParts, String proxiedCookiePath) {
        RequestCookie cookie = new RequestCookie();
        int i = 0;
        while (i < cookieParts.length) {
            String val;
            String param = cookieParts[i].trim();
            if (param.regionMatches(true, 0, PATH, 0, PATH.length())) {
                val = RequestCookie.getValue(param);
                if (val != null && (val = RequestCookie.processOutboundCookiePath(proxiedCookiePath, val)) != null) {
                    cookie.setPath(val);
                }
            } else if (!param.regionMatches(true, 0, DOMAIN, 0, DOMAIN.length())) {
                if (param.regionMatches(true, 0, EXPIRES, 0, EXPIRES.length())) {
                    cookie.setMaxAge(RequestCookie.parseMaxAgeFromExpires(RequestCookie.getValue(param)));
                } else if (param.regionMatches(true, 0, SECURE, 0, SECURE.length())) {
                    val = RequestCookie.getValue(param);
                    cookie.setSecure(val != null && val.equalsIgnoreCase("true"));
                } else {
                    String name = RequestCookie.getName(param);
                    String val2 = RequestCookie.getValue(param);
                    if (name != null && val2 != null) {
                        cookie.setName(name);
                        cookie.setValue(val2);
                    }
                }
            }
            ++i;
        }
        return cookie;
    }

    private static String getName(String param) {
        String ret = null;
        int j = param.indexOf(61);
        if (j > 0) {
            ret = param.substring(0, j).trim();
        }
        return ret;
    }

    private static String getValue(String param) {
        String ret = null;
        int j = param.indexOf(61);
        if (j != -1 && j < param.length()) {
            ret = param.substring(j + 1).trim();
        }
        return ret;
    }

    private static int parseMaxAgeFromExpires(String val) {
        int maxAgeValue = -1;
        DateFormat[] dateFormatArray = expiryFormats;
        int n = expiryFormats.length;
        int n2 = 0;
        while (n2 < n) {
            DateFormat format = dateFormatArray[n2];
            try {
                Date expiryDate = format.parse(val);
                long currentTime = System.currentTimeMillis();
                long expiryTime = expiryDate.getTime();
                if (expiryTime <= currentTime) {
                    maxAgeValue = -1;
                    break;
                }
                maxAgeValue = (int)(expiryTime - currentTime) / 1000;
                if (maxAgeValue > 0) break;
                maxAgeValue = -1;
                break;
            }
            catch (ParseException parseException) {
                ++n2;
            }
        }
        return maxAgeValue;
    }

    private static String processOutboundCookiePath(String cookiePathParameterValue, String param) {
        String newPath = null;
        if (param != null && param.length() > 0) {
            newPath = cookiePathParameterValue != null ? (param.equals(SLASH) && cookiePathParameterValue.endsWith(SLASH) ? cookiePathParameterValue : String.valueOf(cookiePathParameterValue) + param) : param;
        }
        return newPath;
    }
}

