/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.bux.http;

import com.ibm.cognos.bux.http.RequestCookie;
import com.ibm.cognos.bux.http.RequestInformationFetcher;
import com.ibm.cognos.bux.http.RequestPart;
import com.ibm.cognos.bux.http.URLInformation;
import com.ibm.cognos.bux.logging.BUXLoggerFactory;
import com.ibm.cognos.bux.logging.BUXTraceLogger;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.w3c.dom.Element;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RequestInformation {
    public static final int REQUEST_GET = 0;
    public static final int REQUEST_POST = 1;
    public static final int REQUEST_PUT = 2;
    public static final int REQUEST_DELETE = 3;
    private final int type;
    private URLInformation urlInfo;
    private final Map<String, String[]> parameters;
    private final List<RequestCookie> cookies;
    private final Map<String, String> headers;
    private final String contentType;
    private final InputStream inputStream;
    private Object loggingContext;
    private Object bibusRequestHandle;
    private UserRole currentUserRole;
    private Map<String, Object> requestContext;
    private Locale productLocale = Locale.ENGLISH;
    private Locale contentLocale = Locale.US;
    private RequestInformationFetcher lazyInfoFetcher;

    public RequestInformation(int type, URLInformation urlInfo, Map<String, String> headers, List<RequestCookie> cookies, Map<String, String[]> params) {
        this(type, urlInfo, headers, cookies, params, null, null, null);
    }

    public RequestInformation(RequestInformation src, Map<String, String> headers, Map<String, String[]> params) {
        this(src.type, src.urlInfo, headers, src.cookies, params, null, null, src.lazyInfoFetcher);
    }

    public RequestInformation(RequestInformation src, URLInformation urlInfo1) {
        this(src.type, urlInfo1, src.headers, src.cookies, src.parameters, null, null, src.lazyInfoFetcher);
    }

    public RequestInformation(RequestInformation src, int type1, URLInformation urlInfo1) {
        this(type1, urlInfo1, src.headers, src.cookies, src.parameters, null, null, src.lazyInfoFetcher);
    }

    public RequestInformation(RequestInformation src, int type1, URLInformation urlInfo1, Map<String, String[]> params) {
        this(type1, urlInfo1, src.headers, src.cookies, params, null, null, src.lazyInfoFetcher);
    }

    public RequestInformation(int type, URLInformation urlInfo, Map<String, String> headers, List<RequestCookie> cookies, Map<String, String[]> params, String contentType, InputStream inputStream) {
        this(type, urlInfo, headers, cookies, params, contentType, inputStream, null);
    }

    private RequestInformation(int type, URLInformation urlInfo, Map<String, String> headers, List<RequestCookie> cookies, Map<String, String[]> params, String contentType, InputStream inputStream, RequestInformationFetcher lazyReqInfoFetcher) {
        this.type = type;
        this.urlInfo = urlInfo;
        this.headers = headers;
        this.cookies = cookies;
        this.parameters = params;
        this.contentType = contentType;
        this.inputStream = inputStream;
        this.lazyInfoFetcher = lazyReqInfoFetcher;
    }

    public RequestInformation(RequestInformation original) {
        this.type = original.type;
        this.urlInfo = original.urlInfo;
        this.headers = original.headers;
        this.cookies = original.cookies;
        this.parameters = original.parameters;
        this.contentType = original.contentType;
        this.inputStream = original.inputStream;
        this.lazyInfoFetcher = original.lazyInfoFetcher;
        this.productLocale = original.productLocale;
        this.contentLocale = original.contentLocale;
        this.loggingContext = original.loggingContext;
        this.bibusRequestHandle = original.bibusRequestHandle;
        this.requestContext = original.requestContext;
        this.currentUserRole = original.currentUserRole;
    }

    public URLInformation getUrlInfo() {
        return this.urlInfo;
    }

    public void setUrlInfo(URLInformation urlInfo) {
        this.urlInfo = urlInfo;
    }

    public int getType() {
        return this.type;
    }

    public Map<String, String> getHeaders() {
        return this.headers;
    }

    public Map<String, String[]> getParameters() {
        return this.parameters;
    }

    public List<RequestCookie> getCookies() {
        return this.cookies;
    }

    public String getContentType() {
        return this.contentType;
    }

    public InputStream getInputStream() {
        return this.inputStream;
    }

    public String getQueryString() {
        return RequestInformation.getQueryString(this.parameters);
    }

    public static String getQueryString(Map<String, String[]> parameterMap) {
        String encoding = "UTF-8";
        StringBuilder queryString = new StringBuilder();
        if (parameterMap != null) {
            String key = null;
            String[] values = null;
            try {
                for (Map.Entry<String, String[]> param : parameterMap.entrySet()) {
                    key = URLEncoder.encode(param.getKey(), encoding);
                    String[] stringArray = values = param.getValue();
                    int n = values.length;
                    int n2 = 0;
                    while (n2 < n) {
                        String value = stringArray[n2];
                        if (queryString.length() > 0) {
                            queryString.append('&');
                        }
                        queryString.append(key);
                        queryString.append('=');
                        queryString.append(URLEncoder.encode(value, encoding));
                        ++n2;
                    }
                }
            }
            catch (UnsupportedEncodingException e) {
                BUXTraceLogger logger = BUXLoggerFactory.getLogger(RequestInformation.class.getName());
                logger.error(RequestInformation.class.getName(), e.getLocalizedMessage(), e);
            }
        }
        return queryString.toString();
    }

    public void setLoggingContext(Object context) {
        this.loggingContext = context;
    }

    public Object getLoggingContext() {
        return this.loggingContext;
    }

    public Element getBiBusHeader() {
        Element ret = null;
        if (this.lazyInfoFetcher != null) {
            ret = this.lazyInfoFetcher.getBiBusHeader();
        }
        return ret;
    }

    public Map<String, Object> getRequestContext() {
        return this.getRequestContext(true);
    }

    public Map<String, Object> getRequestContext(boolean create) {
        if (this.requestContext == null && create) {
            this.requestContext = new HashMap<String, Object>();
        }
        return this.requestContext;
    }

    public void setProductLocale(Locale productLocale) {
        this.productLocale = productLocale;
    }

    public Locale getProductLocale() {
        return this.productLocale;
    }

    public void setContentLocale(Locale contentLocale) {
        this.contentLocale = contentLocale;
    }

    public Locale getContentLocale() {
        return this.contentLocale;
    }

    public void setFetcher(RequestInformationFetcher fetcher) {
        this.lazyInfoFetcher = fetcher;
    }

    public Enumeration<RequestPart> getRequestParts() {
        Enumeration<RequestPart> parts = null;
        if (this.lazyInfoFetcher != null) {
            parts = this.lazyInfoFetcher.getRequestParts();
        }
        return parts;
    }

    public void setCurrentUserRole(UserRole userRole) {
        this.currentUserRole = userRole;
    }

    public UserRole getCurrentUserRole() {
        return this.currentUserRole;
    }

    public Object getBiBusRequestHandle() {
        return this.bibusRequestHandle;
    }

    public void setOriginalRequestHandle(Object originalRequestHandle) {
        this.bibusRequestHandle = originalRequestHandle;
    }

    public boolean isEmbeddedMobileModeOn() {
        String container = this.getSingleParam("container");
        return container != null && "mobile".compareTo(container) == 0;
    }

    private String getSingleParam(String paramName) {
        String[] entry;
        String val = null;
        if (this.parameters != null && (entry = this.parameters.get(paramName)) != null && entry.length > 0) {
            val = entry[0];
        }
        return val;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum UserRole {
        CONSUME("consume"),
        INTERACT("interact"),
        ASSEMBLE("assemble");

        private final String value;

        private UserRole(String v) {
            this.value = v;
        }

        public String value() {
            return this.value;
        }
    }
}

