/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.bux.http;

import com.ibm.cognos.bux.http.RequestCookie;
import com.ibm.cognos.bux.http.ResponsePayload;
import com.ibm.cognos.bux.http.StringResponsePayload;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.zip.GZIPInputStream;
import java.util.zip.InflaterInputStream;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ResponseInformation {
    public static final String CONTENT_TYPE_TEXTHTML = "text/html";
    private int status;
    private String contentType;
    private String redirect;
    private ResponsePayload output;
    private List<RequestCookie> cookies;
    private Map<String, String> headers;
    private Map<String, String> extraInfoMap = new HashMap<String, String>();
    private static final String COMPRESSION_ALGORITHM_GZIP = "gzip";
    private static final String COMPRESSION_ALGORITHM_DEFLATE = "deflate";

    public ResponseInformation(ResponsePayload output) {
        this(200, output);
    }

    public ResponseInformation(String output) {
        this(200, ResponseInformation.getResponsePayload(output));
    }

    public ResponseInformation(int status, ResponsePayload output) {
        this(status, output, CONTENT_TYPE_TEXTHTML);
    }

    public ResponseInformation(int status, String output) {
        this(status, ResponseInformation.getResponsePayload(output), CONTENT_TYPE_TEXTHTML);
    }

    public ResponseInformation(int status, ResponsePayload payload, String contentType) {
        this.status = status;
        this.output = payload;
        this.contentType = contentType;
    }

    public ResponseInformation(int status, String output, String contentType) {
        this(status, ResponseInformation.getResponsePayload(output), contentType);
    }

    public Map<String, String> getHeaders() {
        return this.headers;
    }

    public void addHeader(String headerName, String headerValue) {
        if (this.headers == null) {
            this.headers = new TreeMap<String, String>(String.CASE_INSENSITIVE_ORDER);
        }
        this.headers.put(headerName, headerValue);
    }

    public List<RequestCookie> getCookies() {
        return this.cookies;
    }

    public void addCookie(RequestCookie cookie) {
        if (this.cookies == null) {
            this.cookies = new ArrayList<RequestCookie>(1);
        }
        this.cookies.add(cookie);
    }

    public int getStatus() {
        return this.status;
    }

    public void setStatus(int status) {
        this.status = status;
    }

    public String getContentType() {
        return this.contentType;
    }

    public void setContentType(String contentType) {
        this.contentType = contentType;
    }

    public String getRedirect() {
        return this.redirect;
    }

    public void setRedirect(String redirect) {
        this.redirect = redirect;
    }

    public ResponsePayload getOutput() {
        return this.output;
    }

    public InputStream getResponseInputStream() {
        return this.getResponseInputStream(ResponseEncoding.Normal);
    }

    public InputStream getResponseInputStream(ResponseEncoding encoding) {
        InputStream is = this.output.getInputStream();
        if (ResponseEncoding.Decompressed.equals((Object)encoding)) {
            try {
                Map<String, String> responseHeaders = this.getHeaders();
                if (responseHeaders != null) {
                    String content_encoding = responseHeaders.get("content-encoding");
                    if (COMPRESSION_ALGORITHM_GZIP.equalsIgnoreCase(content_encoding)) {
                        is = new GZIPInputStream(is);
                        responseHeaders.remove("content-encoding");
                    } else if (COMPRESSION_ALGORITHM_DEFLATE.equalsIgnoreCase(content_encoding)) {
                        is = new InflaterInputStream(is);
                        responseHeaders.remove("content-encoding");
                    }
                }
            }
            catch (IOException iOException) {}
        }
        return is;
    }

    public void setOutput(ResponsePayload stream) {
        this.output = stream;
    }

    private static ResponsePayload getResponsePayload(String output) {
        return new StringResponsePayload(output);
    }

    public Map<String, String> getExtraInfoMap() {
        return this.extraInfoMap;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum ResponseEncoding {
        Normal,
        Decompressed;

    }
}

