/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.bux.http;

import com.ibm.cognos.bux.BUXBundleActivator;
import com.ibm.cognos.bux.BUXController;
import com.ibm.cognos.bux.http.RequestInformation;
import com.ibm.cognos.bux.http.ResponseInformation;
import com.ibm.cognos.bux.http.ResponsePayload;
import com.ibm.cognos.bux.http.ResponsePayloadUtil;
import java.io.InputStream;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ServiceRequestHelper {
    public String executeRequest(RequestInformation requestInfo, String pathInfo, Map<String, String[]> parameters) {
        return this.executeRequest(requestInfo, pathInfo, parameters, false);
    }

    public String executeRequest(RequestInformation requestInfo, String pathInfo, Map<String, String[]> parameters, boolean preventCache) {
        ResponsePayload temp;
        if (requestInfo != null && pathInfo != null && (temp = this._executeRequest(requestInfo, pathInfo, parameters, preventCache, null)) != null) {
            return ResponsePayloadUtil.outputAsString(temp);
        }
        return null;
    }

    public InputStream executeRequest_noCopy(RequestInformation requestInfo, String pathInfo, Map<String, String[]> parameters, boolean preventCache, Map<String, String> extraInfo) {
        ResponsePayload temp;
        if (requestInfo != null && pathInfo != null && (temp = this._executeRequest(requestInfo, pathInfo, parameters, preventCache, extraInfo)) != null) {
            return temp.getInputStream();
        }
        return null;
    }

    protected ResponsePayload _executeRequest(RequestInformation requestInfo, String pathInfo, Map<String, String[]> parameters, boolean preventCache, Map<String, String> extraInfo) {
        requestInfo.getUrlInfo().setPathInfo(pathInfo);
        ResponsePayload result = null;
        BUXController controller = null;
        try {
            controller = this.getController(pathInfo);
            ResponseInformation serviceResponse = controller.handleRequest(requestInfo);
            if (ServiceRequestHelper.isSuccess(serviceResponse.getStatus()) && serviceResponse.getOutput() != null) {
                result = serviceResponse.getOutput();
                if (extraInfo != null) {
                    Map<String, String> map = serviceResponse.getExtraInfoMap();
                    for (Map.Entry<String, String> entry : map.entrySet()) {
                        String key = entry.getKey();
                        String value = entry.getValue();
                        extraInfo.put(key, value);
                    }
                }
            }
        }
        finally {
            if (controller != null) {
                this.releaseController(controller);
            }
        }
        return result;
    }

    protected void releaseController(BUXController controller) {
        BUXBundleActivator.releaseBUXService(controller);
    }

    protected BUXController getController(String pathInfo) {
        return BUXBundleActivator.getBUXControllerForPathInfo(pathInfo);
    }

    private static boolean isSuccess(int statusCode) {
        return statusCode >= 200 && statusCode <= 299;
    }
}

