/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.bux.http;

import com.ibm.cognos.bux.http.RemoteTarget;
import com.ibm.cognos.bux.http.URLTemplate;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TemplateRemoteTarget
implements RemoteTarget {
    private final URLTemplate urlTemplate;
    private final String cookiePolicy;

    public TemplateRemoteTarget(String urlPattern, String cookiePolicy) {
        this.urlTemplate = new URLTemplate(urlPattern);
        this.cookiePolicy = cookiePolicy;
    }

    public TemplateRemoteTarget(URLTemplate urlTemplate, String cookiePolicy) {
        this.urlTemplate = urlTemplate;
        this.cookiePolicy = cookiePolicy;
    }

    @Override
    public String getRemotePath(String remaining, Map<String, Object> properties, Map<String, String[]> parameters) {
        StringBuilder sb = new StringBuilder();
        this.urlTemplate.generatePath(sb, properties, parameters);
        sb.append(remaining);
        return sb.toString();
    }

    @Override
    public String getQueryString(Map<String, String[]> parameters) {
        StringBuilder sb = new StringBuilder();
        this.urlTemplate.generateQueryString(sb, null, parameters);
        return sb.toString();
    }

    @Override
    public String getCookiePolicy() {
        return this.cookiePolicy;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(super.toString());
        sb.append(' ').append(this.urlTemplate);
        sb.append(" cookiePolicy: ").append(this.cookiePolicy);
        return sb.toString();
    }
}

