/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.bux.http;

public class URLInformation
implements Cloneable {
    public static final int VIA_DISPATCHER = 0;
    public static final int VIA_SERVLET = 1;
    public static final String MAIN_SERVICE_PATH = "/main";
    private String protocol;
    private String host;
    private int port;
    private String requestURL;
    private String gateway;
    private String shortGateway;
    private String requestURI;
    private String contextPath;
    private String pathInfo;
    private final int requestMode;

    public URLInformation() {
        this(0);
    }

    public URLInformation(int mode) {
        this.requestMode = mode;
    }

    public URLInformation cloneWithPathInfo(String aPathInfo) {
        URLInformation newURL = new URLInformation(this);
        newURL.setPathInfo(aPathInfo);
        newURL.setRequestURI(this.getRequestURI().replace(this.pathInfo, aPathInfo));
        newURL.setRequestURL(this.getRequestURL().replace(this.pathInfo, aPathInfo));
        return newURL;
    }

    protected Object clone() throws CloneNotSupportedException {
        return super.clone();
    }

    public URLInformation(URLInformation src) {
        this.requestMode = src.requestMode;
        this.protocol = src.protocol;
        this.setHost(src.host);
        this.setPathInfo(src.getPathInfo());
        this.setContextPath(src.getContextPath());
        this.setRequestURI(src.getRequestURI());
        this.setRequestURL(src.getRequestURL());
        this.gateway = src.getGateway();
        this.shortGateway = src.shortGateway;
    }

    public String getRequestURL() {
        return this.requestURL;
    }

    public void setRequestURL(String requestURL) {
        this.requestURL = requestURL;
    }

    public String getProtocol() {
        return this.protocol;
    }

    public String getHost() {
        return this.host;
    }

    public void setHost(String host) {
        this.host = host;
    }

    public int getPort() {
        return this.port;
    }

    public void setPort(int port) {
        this.port = port;
    }

    public String getRequestURI() {
        return this.requestURI;
    }

    public void setRequestURI(String requestURI) {
        this.requestURI = requestURI;
    }

    public String getContextPath() {
        return this.contextPath;
    }

    public void setContextPath(String contextPath) {
        this.contextPath = contextPath;
    }

    public String getPathInfo() {
        return this.pathInfo;
    }

    public void setPathInfo(String pathInfo) {
        this.pathInfo = pathInfo;
        if (this.pathInfo == null) {
            this.pathInfo = MAIN_SERVICE_PATH;
        }
    }

    public String getGateway() {
        if (this.requestMode == 0) {
            return this.gateway;
        }
        return null;
    }

    public void setGateway(String incomingGatewayURL) {
        if (incomingGatewayURL != null) {
            this.gateway = incomingGatewayURL;
            int index = this.gateway.indexOf("//");
            if (index != -1) {
                this.protocol = this.gateway.substring(0, index - 1);
                int slashIndex = this.gateway.indexOf("/", index + 2);
                if (slashIndex != -1) {
                    this.shortGateway = this.gateway.substring(index + 2);
                }
            }
        }
    }

    public String getShortGateway() {
        return this.shortGateway;
    }
}

